/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.AbstractDimensionImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.OverrideResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PermClassUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;

public class PermClassImportHandler
extends AbstractDimensionImportHandler {
    public PermClassImportHandler(DimensionImportContext context) {
        super(context);
    }

    @Override
    public void postInsert(List<PersistEntry> persistEntries) {
        ArrayList<Pair<DynamicObject, ImportBillData>> pairs = new ArrayList<Pair<DynamicObject, ImportBillData>>(16);
        for (PersistEntry persistEntry : persistEntries) {
            pairs.add((Pair<DynamicObject, ImportBillData>)new Pair((Object)persistEntry.getMemberTreeDy(), (Object)persistEntry.getBillWrap().getBill()));
        }
        this.importPermClass(pairs);
    }

    @Override
    public void postOverride(List<OverrideResultEntry> overrideEntries) {
        ArrayList<Pair<DynamicObject, ImportBillData>> pairs = new ArrayList<Pair<DynamicObject, ImportBillData>>(16);
        for (OverrideResultEntry overrideEntry : overrideEntries) {
            pairs.add((Pair<DynamicObject, ImportBillData>)new Pair((Object)overrideEntry.getOverridDy(), (Object)overrideEntry.getBillWrap().getBill()));
        }
        this.importPermClass(pairs);
    }

    private void importPermClass(List<Pair<DynamicObject, ImportBillData>> pairs) {
        List needImports = pairs.stream().map(x -> this.createPermClass(this.context.getEntityName(), (DynamicObject)x.p1, (ImportBillData)x.p2)).filter(x -> x != null).collect(Collectors.toList());
        if (!needImports.isEmpty()) {
            DynamicObject[] overWrites = needImports.stream().filter(x -> x.getLong("id") != 0L).collect(Collectors.toSet()).toArray(new DynamicObject[0]);
            DynamicObject[] newDys = needImports.stream().filter(x -> x.getLong("id") == 0L).collect(Collectors.toList()).toArray(new DynamicObject[0]);
            if (overWrites.length > 0) {
                SaveServiceHelper.save((DynamicObject[])overWrites);
            }
            if (newDys.length > 0) {
                SaveServiceHelper.save((DynamicObject[])newDys);
            }
        }
    }

    private DynamicObject createPermClass(String entityName, DynamicObject memberTreeDy, ImportBillData data) {
        if (!("bcm_periodmembertree".equalsIgnoreCase(entityName) || "bcm_fymembertree".equalsIgnoreCase(entityName) || StorageTypeEnum.SHARE.index.equals(memberTreeDy.get("storagetype")))) {
            String permClassNumber = "";
            permClassNumber = "bcm_structofextend".equals(entityName) ? String.valueOf(data.getData().get((Object)"permclass")) : String.valueOf(data.getData().get((Object)"sectoryclass"));
            if (permClassNumber.equalsIgnoreCase("null") || permClassNumber == null) {
                return null;
            }
            DynamicObject permClass = PermClassUtils.addPermClassForExcelInput(entityName, memberTreeDy.getLong("id"), this.getModelId(), permClassNumber);
            return permClass;
        }
        return null;
    }
}

