/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.helper;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.export.strategy.helper.DimShortNumAndFieldMap;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.util.DimensionUtil;

public class BatchImportReadOnlyCache {
    private static Map<String, Map<String, Cache>> REQUEST_CACHES = Collections.synchronizedMap(new HashMap(10));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        RequestContext rq = RequestContext.get();
        Map<String, Map<String, Cache>> map = REQUEST_CACHES;
        synchronized (map) {
            Map<String, Cache> cache = REQUEST_CACHES.get(rq.getRequestId());
            if (Objects.nonNull(cache)) {
                REQUEST_CACHES.remove(rq.getRequestId());
                cache.values().forEach(x -> x.cleanUp());
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> Cache<K, V> getOrLoadCache(String cacheName, Supplier<Map<K, V>> dataMapSupplier) {
        Cache cache;
        String requestId = RequestContext.get().getRequestId();
        Map<String, Cache> cacheMap = REQUEST_CACHES.get(requestId);
        if (Objects.isNull(cacheMap)) {
            Map<String, Map<String, Cache>> map = REQUEST_CACHES;
            synchronized (map) {
                if (!REQUEST_CACHES.containsKey(requestId)) {
                    REQUEST_CACHES.put(requestId, new HashMap(3));
                }
            }
            cacheMap = REQUEST_CACHES.get(requestId);
        }
        if (Objects.isNull(cache = cacheMap.get(cacheName))) {
            Map<String, Cache> map = cacheMap;
            synchronized (map) {
                if (!cacheMap.containsKey(cacheName)) {
                    Cache tempCache = CacheBuilder.newBuilder().recordStats().expireAfterAccess(30L, TimeUnit.MINUTES).build();
                    tempCache.putAll(dataMapSupplier.get());
                    cacheMap.put(cacheName, tempCache);
                }
            }
            cache = cacheMap.get(cacheName);
        }
        return cache;
    }

    private static void retireSpecificCache(String cacheName) {
        String requestId = RequestContext.get().getRequestId();
        Map<String, Cache> cacheMap = REQUEST_CACHES.get(requestId);
        if (Objects.nonNull(cacheMap)) {
            cacheMap.remove(cacheName);
        }
    }

    public static DynamicObject getPermClass(String number, long modelId) {
        return (DynamicObject)BatchImportReadOnlyCache.getOrLoadCache("permisionCalssCache", () -> {
            DynamicObject[] perms = BusinessDataServiceHelper.load((String)"bcm_permissionclass", (String)"id,number", (QFilter[])new QFilter("model.id", "=", (Object)modelId).toArray());
            return Arrays.stream(perms).collect(Collectors.toMap(x -> x.getString("number"), x -> x));
        }).getIfPresent((Object)number);
    }

    public static DynamicObject getEnumItem(String enumName, long dimId) {
        return (DynamicObject)BatchImportReadOnlyCache.getOrLoadCache("enumItemCache", () -> {
            DynamicObject[] perms = BusinessDataServiceHelper.load((String)"bcm_enumitem", (String)"id,name,datatype", (QFilter[])new QFilter("dimension", "=", (Object)dimId).toArray());
            return Arrays.stream(perms).collect(Collectors.toMap(x -> x.getString("name"), x -> x));
        }).getIfPresent((Object)enumName);
    }

    public static DynamicObject getInitProperty(String initValue, long dimId) {
        return (DynamicObject)BatchImportReadOnlyCache.getOrLoadCache("InitPropertyCache", () -> {
            DynamicObject[] perms = BusinessDataServiceHelper.load((String)"bcm_definedpropertyvalue", (String)"id,number", (QFilter[])new QFilter("dimension", "=", (Object)dimId).toArray());
            return Arrays.stream(perms).collect(Collectors.toMap(x -> x.getString("number"), x -> x));
        }).getIfPresent((Object)initValue);
    }

    public static List<DynamicObject> getDatatype(long dimId, String parentNum) {
        return (List)BatchImportReadOnlyCache.getOrLoadCache("memTreeCache" + parentNum, () -> {
            QFilter qf = new QFilter("dimension", "=", (Object)dimId);
            qf.and(new QFilter("parent.number", "=", (Object)parentNum));
            DynamicObjectCollection results = QueryServiceHelper.query((String)"bcm_structofextend", (String)"id,number,datatype,fieldmapped,enumitem.id,enumitem.datatype", (QFilter[])qf.toArray());
            HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(1);
            map.put(parentNum, results);
            return map;
        }).getIfPresent((Object)parentNum);
    }

    public static DynamicObject getParGroupType(long dimId, String parentNum) {
        return (DynamicObject)BatchImportReadOnlyCache.getOrLoadCache("parGroupType" + parentNum, () -> {
            QFilter qf = new QFilter("dimension", "=", (Object)dimId);
            qf.and(new QFilter("number", "=", (Object)parentNum));
            DynamicObject results = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id,grouptype", (QFilter[])qf.toArray());
            HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(1);
            map.put(parentNum, results);
            return map;
        }).getIfPresent((Object)parentNum);
    }

    public static List<DynamicObject> getEnumDatatype(long dimId) {
        return (List)BatchImportReadOnlyCache.getOrLoadCache("enumDatatypeCache", () -> {
            QFilter qf = new QFilter("dimension", "=", (Object)dimId);
            DynamicObjectCollection results = QueryServiceHelper.query((String)"bcm_enumitem", (String)"id,datatype", (QFilter[])qf.toArray());
            HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(1);
            map.put("datatype", results);
            return map;
        }).getIfPresent((Object)"datatype");
    }

    public static DimShortNumAndFieldMap getDimShortNumAndFieldMap(String modelId) {
        return (DimShortNumAndFieldMap)BatchImportReadOnlyCache.getOrLoadCache("dimShortNumAndFieldMapCache", () -> {
            HashMap<String, DimShortNumAndFieldMap> ans = new HashMap<String, DimShortNumAndFieldMap>();
            ans.put(modelId, new DimShortNumAndFieldMap(Long.parseLong(modelId)));
            return ans;
        }).getIfPresent((Object)modelId);
    }

    public static DynamicObject getPermissionClassEntity(String entityName, Object modelId, long entityId) {
        return (DynamicObject)BatchImportReadOnlyCache.getOrLoadCache("permissionClassEntityCache", () -> {
            DynamicObject[] entityPermClass = BusinessDataServiceHelper.load((String)"bcm_permclass_entity", (String)"entityname,permclass,model,entityid", (QFilter[])new QFBuilder("model", "=", modelId).and("entityname", "=", (Object)entityName).toArray());
            return Arrays.stream(entityPermClass).collect(Collectors.toMap(x -> x.get("entityid"), x -> x, (v1, v2) -> v1));
        }).getIfPresent((Object)entityId);
    }

    public static Optional<Long> mapEnumToId(long modelId, String enumValue) {
        return Optional.ofNullable(BatchImportReadOnlyCache.getOrLoadCache("dimensionEnumCache", () -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model.id", "=", (Object)modelId);
            DynamicObjectCollection enumItems = QueryServiceHelper.query((String)"bcm_enumitem", (String)"id,name", (QFilter[])qfBuilder.toArray());
            HashMap enumValueMap = new HashMap(8);
            enumItems.stream().forEach(x -> enumValueMap.put(x.getString("name"), x.getLong("id")));
            return enumValueMap;
        }).getIfPresent((Object)enumValue));
    }

    public static synchronized Integer getNexMemberMaxSeq(Long parentId) {
        Cache cache = BatchImportReadOnlyCache.getOrLoadCache("currencyMemberCache", () -> new HashMap(100));
        if (Objects.isNull(cache.getIfPresent((Object)parentId))) {
            cache.put((Object)parentId, (Object)new AtomicInteger(PersistProxy.instance.getParentMaxSequence(parentId)));
        }
        return ((AtomicInteger)cache.getIfPresent((Object)parentId)).incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Long> getIcDimensionIDByModel(long modelId) {
        Cache cache = BatchImportReadOnlyCache.getOrLoadCache("icDimensionIdCache", () -> new HashMap(1));
        if (Objects.isNull(cache.getIfPresent((Object)modelId))) {
            Cache cache2 = cache;
            synchronized (cache2) {
                if (Objects.isNull(cache.getIfPresent((Object)modelId))) {
                    QFilter filterINTNumber = new QFilter("number", "=", (Object)DimTypesEnum.INTERCOMPANY.getNumber());
                    QFilter filterINTModel = new QFilter("model", "=", (Object)modelId);
                    QFilter[] filters = new QFilter[]{filterINTNumber, filterINTModel};
                    DynamicObject icDimension = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number", (QFilter[])filters);
                    if (Objects.isNull(icDimension)) {
                        cache.put((Object)modelId, Optional.empty());
                    } else {
                        cache.put((Object)modelId, Optional.of(icDimension.getLong("id")));
                    }
                }
            }
        }
        return (Optional)cache.getIfPresent((Object)modelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Long> getMyOrgDimensionIDByModel(long modelId) {
        Cache cache = BatchImportReadOnlyCache.getOrLoadCache("myOrgDimensionIdCache", () -> new HashMap(1));
        if (Objects.isNull(cache.getIfPresent((Object)modelId))) {
            Cache cache2 = cache;
            synchronized (cache2) {
                if (Objects.isNull(cache.getIfPresent((Object)modelId))) {
                    QFilter filterINTNumber = new QFilter("number", "=", (Object)DimTypesEnum.MYCOMPANY.getNumber());
                    QFilter filterINTModel = new QFilter("model", "=", (Object)modelId);
                    QFilter[] filters = new QFilter[]{filterINTNumber, filterINTModel};
                    DynamicObject icDimension = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number", (QFilter[])filters);
                    if (Objects.isNull(icDimension)) {
                        cache.put((Object)modelId, Optional.empty());
                    } else {
                        cache.put((Object)modelId, Optional.of(icDimension.getLong("id")));
                    }
                }
            }
        }
        return (Optional)cache.getIfPresent((Object)modelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<DynamicObject> getIcMemberByNumber(long icDimensionID, String icNumber, long modelId) {
        String key = String.format("%s_%s", icDimensionID, icNumber);
        Cache cache = BatchImportReadOnlyCache.getOrLoadCache("icmemberEntityCache", () -> new HashMap(1));
        if (Objects.isNull(cache.getIfPresent((Object)key))) {
            Cache cache2 = cache;
            synchronized (cache2) {
                if (Objects.isNull(cache.getIfPresent((Object)key))) {
                    QFilter filterDimension = new QFilter("dimension", "=", (Object)icDimensionID);
                    QFilter filterNumber = new QFilter("number", "=", (Object)icNumber);
                    QFilter filterModel = new QFilter("model", "=", (Object)modelId);
                    DynamicObject dyObj = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"id,parent.number", (QFilter[])new QFilter[]{filterNumber, filterModel, filterDimension});
                    if (Objects.isNull(dyObj)) {
                        cache.put((Object)key, Optional.empty());
                    } else {
                        cache.put((Object)key, Optional.of(dyObj));
                    }
                }
            }
        }
        return (Optional)cache.getIfPresent((Object)key);
    }

    public static void clearIcMemberCache() {
        BatchImportReadOnlyCache.retireSpecificCache("icmemberEntityCache");
    }

    public static Optional<DynamicObject> getBdCurrencyByNumber(String number) {
        return Optional.ofNullable(BatchImportReadOnlyCache.getOrLoadCache("dimensionEnumCache", () -> {
            HashMap cacheMap = new HashMap(6);
            DynamicObject[] currencyList = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id,number,name", null);
            if (Objects.nonNull(currencyList)) {
                Arrays.stream(currencyList).forEach(x -> cacheMap.put(x.getString("number"), x));
            }
            return cacheMap;
        }).getIfPresent((Object)number));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkCurrencyAndCreateCurrencyMember(long modelId, String currencyNumber, String currencyName) {
        Cache cache = BatchImportReadOnlyCache.getOrLoadCache("currencyMemberCache", () -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model.id", "=", (Object)modelId);
            DynamicObjectCollection currencyNumbers = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"number,id", (QFilter[])new QFilter("model.id", "=", (Object)modelId).toArray());
            return currencyNumbers.stream().collect(Collectors.toMap(x -> x.getString("number"), x -> x.getLong("id")));
        });
        if (Objects.isNull(cache.getIfPresent((Object)currencyNumber))) {
            Cache cache2 = cache;
            synchronized (cache2) {
                if (Objects.isNull(cache.getIfPresent((Object)currencyNumber))) {
                    DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray());
                    try (TXHandle tx = TX.required();){
                        try {
                            Optional<DynamicObject> newCurrency = BatchImportReadOnlyCache.createCurrencyMember(model, currencyNumber, currencyName);
                            if (newCurrency.isPresent()) {
                                cache.put((Object)currencyName, (Object)newCurrency.get().getLong("id"));
                            }
                        }
                        catch (Throwable e) {
                            tx.markRollback();
                            throw new KDBizException(e.getMessage());
                        }
                    }
                }
            }
        }
    }

    private static Optional<DynamicObject> createCurrencyMember(DynamicObject model, String currencyNumber, String currencyName) {
        long modelId = model.getLong("id");
        DynamicObject currency = ORM.create().newDynamicObject("bcm_currencymember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)currency);
        DimensionUtil.initModelAndDimension(currency, "Currency", modelId);
        QFilter filter1 = new QFilter("number", "=", (Object)currencyNumber);
        QFilter filter2 = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        if (!QueryServiceHelper.exists((String)"bcm_currencymembertree", (QFilter[])filters)) {
            currency.set("number", (Object)currencyNumber);
            currency.set("name", (Object)currencyName);
            Object[] currencys = new Object[]{currency};
            currencys = BusinessDataWriter.save((IDataEntityType)currency.getDynamicObjectType(), (Object[])currencys);
            DynamicObject currencyTree = ORM.create().newDynamicObject("bcm_currencymembertree");
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)currencyTree);
            DimensionUtil.initModelAndDimension(currencyTree, "Currency", modelId);
            currencyTree.set("member", (Object)currency);
            currencyTree.set("number", currency.get("number"));
            currencyTree.set("name", currency.get("name"));
            currencyTree.set("storagetype", (Object)"4");
            currencyTree.set("aggoprt", (Object)5);
            currencyTree.set("isleaf", (Object)1);
            currencyTree.set("level", (Object)2);
            String parentTreeid = DimensionUtil.getParentid(currencyTree.getString("model.id"), "bcm_currencymembertree", "Currency", BatchImportReadOnlyCache.class.getName());
            currencyTree.set("longnumber", (Object)("Currency!" + currencyTree.getString("number")));
            currencyTree.set("parent", (Object)parentTreeid);
            currencyTree.set("dseq", (Object)DimensionUtil.getDSeq(Long.parseLong(parentTreeid), "bcm_currencymembertree"));
            currencyTree.set("member", currencys[0]);
            currencyTree.set("issysmember", (Object)9);
            Object[] currencyTrees = new Object[]{currencyTree};
            BusinessDataWriter.save((IDataEntityType)currencyTree.getDynamicObjectType(), (Object[])currencyTrees);
            OlapServiceHelper.createMember((String)model.getString("number"), (String)"Currency", (String)currencyNumber, (int)currencyTree.getInt("aggoprt"), (String)DimensionServiceHelper.getMemberNumber((String)"bcm_currencymembertree", (DynamicObject)currencyTree));
            BatchImportReadOnlyCache.createProcessMember(modelId, currencyTree, model.getString("number"));
            return Optional.of(currency);
        }
        return Optional.empty();
    }

    private static void createProcessMember(long modelId, DynamicObject currencyTree, String modelName) {
        DynamicObject process = ORM.create().newDynamicObject("bcm_processmember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)process);
        DimensionUtil.initModelAndDimension(process, "TCF", modelId);
        QFilter filter1 = new QFilter("number", "=", currencyTree.get("number"));
        QFilter filter2 = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        if (!QueryServiceHelper.exists((String)"bcm_processmembertree", (QFilter[])filters)) {
            process.set("number", currencyTree.get("number"));
            process.set("name", currencyTree.get("name"));
            Object[] processs = new Object[]{process};
            processs = BusinessDataWriter.save((IDataEntityType)process.getDynamicObjectType(), (Object[])processs);
            DynamicObject processTree = ORM.create().newDynamicObject("bcm_processmembertree");
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)processTree);
            DimensionUtil.initModelAndDimension(processTree, "Process", modelId);
            processTree.set("member", (Object)process);
            processTree.set("number", currencyTree.get("number"));
            processTree.set("name", currencyTree.get("name"));
            processTree.set("storagetype", (Object)"4");
            processTree.set("aggoprt", (Object)5);
            processTree.set("isleaf", (Object)1);
            processTree.set("level", (Object)3);
            String parentTreeid = DimensionUtil.getParentid(String.valueOf(modelId), "bcm_processmembertree", "TCF", BatchImportReadOnlyCache.class.getName());
            processTree.set("longnumber", (Object)("Process!TCF!" + processTree.getString("number")));
            processTree.set("parent", (Object)parentTreeid);
            processTree.set("dseq", (Object)DimensionUtil.getDSeq(Long.parseLong(parentTreeid), "bcm_processmembertree"));
            processTree.set("member", processs[0]);
            processTree.set("issysmember", (Object)9);
            processTree.set("id", (Object)currencyTree.getLong("id"));
            currencyTree.set("issysmember", (Object)9);
            Object[] processTrees = new Object[]{processTree};
            BusinessDataWriter.save((IDataEntityType)processTree.getDynamicObjectType(), (Object[])processTrees);
            OlapServiceHelper.createMember((String)modelName, (String)"Process", (String)currencyTree.getString("number"), (int)processTree.getInt("aggoprt"), (String)DimensionServiceHelper.getMemberNumber((String)"bcm_processmembertree", (DynamicObject)processTree));
        }
    }

    public static List<DynamicObject> getAllCslSchemes(long modelId) {
        return (List)BatchImportReadOnlyCache.getOrLoadCache("all_cslschemes_cache", () -> {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("nodetype", "=", (Object)"1");
            DynamicObjectCollection csls = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, number", (QFilter[])qFilter.toArray());
            HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(1);
            map.put("cslscheme", csls);
            return map;
        }).getIfPresent((Object)"cslscheme");
    }

    public static List<DynamicObject> getDPropertys(String enumItemNum, long dimId) {
        return (List)BatchImportReadOnlyCache.getOrLoadCache("dim_dproperty_number2value_" + dimId, () -> {
            DynamicObject[] dproValues = BusinessDataServiceHelper.load((String)"bcm_definedpropertyvalue", (String)"id,number,propertyid.number,propertyid.id", (QFilter[])new QFilter("dimension", "=", (Object)dimId).toArray());
            HashMap<String, List> enumItemNum2EnumValue = new HashMap<String, List>(16);
            for (DynamicObject dproValue : dproValues) {
                enumItemNum2EnumValue.computeIfAbsent(dproValue.getString("propertyid.number"), k -> new ArrayList(10)).add(dproValue);
            }
            return enumItemNum2EnumValue;
        }).getIfPresent((Object)enumItemNum);
    }
}

