/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.helper;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.SilentJSONUtils;
import org.apache.commons.lang3.StringUtils;

public class DimensionDependencyResolver
implements AutoCloseable {
    protected static final Log LOG = LogFactory.getLog(DimensionDependencyResolver.class);
    private Map<String, Boolean> existingNumberInfos = null;
    private Multimap<String, String> curBatchNumbers = LinkedListMultimap.create();
    private volatile Predicate<ImportBillData> isShareType = x -> StorageTypeEnum.SHARE.name.equals(x.getData().get((Object)"storagetype"));

    public DimensionDependencyResolver(List<ImportBillData> waitingBills) {
        if (!CollectionUtils.isEmpty(waitingBills)) {
            this.existingNumberInfos = new HashMap<String, Boolean>(waitingBills.size());
            waitingBills.stream().forEach(x -> {
                String memNumber = x.getData().getString("number");
                if (!this.existingNumberInfos.containsKey(memNumber)) {
                    Boolean hasNonShareType = this.isShareType.test((ImportBillData)x) ? Boolean.FALSE : Boolean.TRUE;
                    this.existingNumberInfos.put(memNumber, hasNonShareType);
                }
            });
            long tick = System.currentTimeMillis();
            ImportContextHolder.initAllWaitingImportData(waitingBills);
            LOG.info(String.format("dimension_import:: imported data to cache: %s, cost: %s", waitingBills.size(), System.currentTimeMillis() - tick));
        }
    }

    public void notifyBillSelected(ImportBillData selectedBill) {
        this.curBatchNumbers.put((Object)selectedBill.getData().getString("number"), (Object)this.getParentNumber(selectedBill));
    }

    public boolean checkBillIsDependPrevious(ImportBillData importBillData) {
        String memNumber;
        String parentNumber = this.getParentNumber(importBillData);
        if (StringUtils.isNotEmpty((CharSequence)parentNumber)) {
            if (this.existingNumberInfos.containsKey(parentNumber) && this.existingNumberInfos.get(parentNumber).booleanValue()) {
                return true;
            }
            memNumber = importBillData.getData().getString("number");
            if (this.isShareType.test(importBillData) && this.existingNumberInfos.get(memNumber).booleanValue()) {
                return true;
            }
            if (this.isShareType.test(importBillData) && this.curBatchNumbers.containsEntry((Object)parentNumber, (Object)memNumber)) {
                return true;
            }
        }
        return this.curBatchNumbers.containsKey((Object)(memNumber = importBillData.getData().getString("number")));
    }

    private String getParentNumber(ImportBillData importBillData) {
        Object parentNumberObj;
        String parentStr = importBillData.getData().getString("parent");
        String parentNumber = "";
        if (StringUtils.isNotEmpty((CharSequence)parentStr) && Objects.nonNull(parentNumberObj = SilentJSONUtils.cast(parentStr, LinkedHashMap.class).get("number"))) {
            parentNumber = parentNumberObj.toString();
        }
        return parentNumber;
    }

    @Override
    public void close() {
        if (Objects.nonNull(this.existingNumberInfos)) {
            this.existingNumberInfos.clear();
        }
        if (Objects.nonNull(this.curBatchNumbers)) {
            this.curBatchNumbers.clear();
        }
    }
}

