/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.helper;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;

public class DimensionImportContext {
    public static final int BATCH_SINGLE = 500;
    public static final int BATCH_THRESHOLD = 2000;
    public static final ErrorCode ERROR_DIRTY_DATA = new ErrorCode("dirtyDataError", "the same number '%s' occurrence %s times, it should only one. ");
    private String appId;
    protected final boolean isModelManager;
    private final ImportOperateType importType;
    private final DynamicObject importModel;
    private final String entityName;
    private final DynamicObject importDimension;
    private final Map<String, String> newMembNums;
    private final Map<String, Set<String>> ebMembPermInfo;

    public DimensionImportContext(DynamicObject importModel, DynamicObject importDimension, String entityName, ImportOperateType importType, String appId, boolean isModelManager, Map<String, String> newMembNums, Map<String, Set<String>> ebMembPermInfo) {
        this.importModel = importModel;
        this.importDimension = importDimension;
        this.entityName = entityName;
        this.importType = importType;
        this.appId = appId;
        this.isModelManager = isModelManager;
        this.newMembNums = newMembNums;
        this.ebMembPermInfo = ebMembPermInfo;
    }

    public ImportOperateType getImportType() {
        return this.importType;
    }

    public DynamicObject getImportModel() {
        return this.importModel;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public DynamicObject getImportDimension() {
        return this.importDimension;
    }

    public boolean isEPMapp() {
        return ApplicationTypeEnum.isEBOrBGMDOrBGBDOrBGMByApp((String)this.appId);
    }

    public boolean isBGMD() {
        return ApplicationTypeEnum.BGMD.appnum.equals(this.appId);
    }

    public boolean isCM() {
        return ApplicationTypeEnum.CM.appnum.equals(this.appId);
    }

    public boolean isRpt() {
        return ApplicationTypeEnum.RPT.appnum.equals(this.appId);
    }

    public boolean isModelManager() {
        return this.isModelManager;
    }

    public Map<String, String> getNewMembNums() {
        return this.newMembNums;
    }

    public Map<String, Set<String>> getEbMembPermInfo() {
        return this.ebMembPermInfo;
    }

    public String getAppId() {
        return this.appId;
    }
}

