/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.helper;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.BatchDbCache;

public class ImportContextHolder {
    private static final Map<String, DimensionImportContext> CONTEXT_HOLDER = Collections.synchronizedMap(new HashMap(16));
    private static final Map<String, ImportInfo> IS_DRY_RUN_IMPORT_HOLDER = Collections.synchronizedMap(new HashMap(16));
    private static final Map<String, BatchDbCache> BATCH_DB_CACHE_HOLDER = Collections.synchronizedMap(new HashMap(16));
    private static final Map<String, List<ImportBillData>> WAITING_PERSIST_BILLS = Collections.synchronizedMap(new HashMap(16));
    private static final Map<String, Set<String>> WAITING_PERSIST_PARENT_DEPENDS = Collections.synchronizedMap(new HashMap(16));
    private static final ThreadLocal<Set<Long>> NEW_MEMBER_IDS = new ThreadLocal();
    private static final ThreadLocal<Set<Long>> OVERRIDE_MEMBER_IDS = new ThreadLocal();
    private static final Map<String, Map<Pair<String, String>, Pair<Integer, Long>>> DEFINED_PROPS_CACHE = new HashMap<String, Map<Pair<String, String>, Pair<Integer, Long>>>(2);

    public static void setImportContext(DimensionImportContext context) {
        CONTEXT_HOLDER.put(RequestContext.getOrCreate().getRequestId(), context);
    }

    public static DimensionImportContext getImportContext() {
        String requestId = RequestContext.getOrCreate().getRequestId();
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)requestId) && null != CONTEXT_HOLDER.get(requestId) ? 1 : 0) != 0, (Object)"no import context setting. ");
        return CONTEXT_HOLDER.get(requestId);
    }

    public static void setIsDryRunImport(boolean isDryRunPattern) {
        IS_DRY_RUN_IMPORT_HOLDER.put(RequestContext.getOrCreate().getRequestId(), new ImportInfo(isDryRunPattern));
    }

    public static boolean isDryRun() {
        String requestId = RequestContext.getOrCreate().getRequestId();
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)requestId) && null != IS_DRY_RUN_IMPORT_HOLDER.get(requestId) ? 1 : 0) != 0, (Object)"no import pattern setting. ");
        return IS_DRY_RUN_IMPORT_HOLDER.get(requestId).getDryRunPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BatchDbCache getOrCreateBatchDbCacheInstance() {
        String requestId = RequestContext.getOrCreate().getRequestId();
        BatchDbCache batchDbCache = BATCH_DB_CACHE_HOLDER.get(requestId);
        if (!Objects.isNull(batchDbCache)) return BATCH_DB_CACHE_HOLDER.get(requestId);
        Class<ImportContextHolder> clazz = ImportContextHolder.class;
        synchronized (ImportContextHolder.class) {
            if (!Objects.isNull(BATCH_DB_CACHE_HOLDER.get(requestId))) return BATCH_DB_CACHE_HOLDER.get(requestId);
            BATCH_DB_CACHE_HOLDER.put(requestId, new BatchDbCache());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return BATCH_DB_CACHE_HOLDER.get(requestId);
        }
    }

    public static synchronized void clearBatchCache() {
        Set<String> parentNumbers;
        List<ImportBillData> bills;
        String requestId = RequestContext.getOrCreate().getRequestId();
        BatchDbCache dbCacheInstance = BATCH_DB_CACHE_HOLDER.get(requestId);
        if (Objects.nonNull(dbCacheInstance)) {
            dbCacheInstance.clearCurrentBatchDBCache();
            BATCH_DB_CACHE_HOLDER.put(requestId, null);
        }
        if (Objects.nonNull(bills = WAITING_PERSIST_BILLS.get(requestId))) {
            bills.clear();
            WAITING_PERSIST_BILLS.remove(requestId);
        }
        if (Objects.nonNull(parentNumbers = WAITING_PERSIST_PARENT_DEPENDS.get(requestId))) {
            parentNumbers.clear();
            WAITING_PERSIST_PARENT_DEPENDS.remove(requestId);
        }
        DEFINED_PROPS_CACHE.remove(requestId);
    }

    public static Date getImportBeginTime() {
        String requestId = RequestContext.getOrCreate().getRequestId();
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)requestId) && null != IS_DRY_RUN_IMPORT_HOLDER.get(requestId) ? 1 : 0) != 0, (Object)"no import pattern setting. ");
        return IS_DRY_RUN_IMPORT_HOLDER.get(requestId).getBeginTime();
    }

    public static void removeCurrent() {
        String requestId = RequestContext.getOrCreate().getRequestId();
        CONTEXT_HOLDER.remove(requestId);
    }

    public static long getModelId() {
        return ImportContextHolder.getImportContext().getImportModel().getLong("id");
    }

    public static long getDimensionId() {
        return Optional.ofNullable(ImportContextHolder.getImportContext().getImportDimension()).map(dim -> dim.getLong("id")).orElse(0L);
    }

    public static ImportOperateType getImportType() {
        return ImportContextHolder.getImportContext().getImportType();
    }

    public static String getEntityName() {
        return ImportContextHolder.getImportContext().getEntityName();
    }

    public static void addBatchNewIds(Collection<Long> memberIds) {
        if (Objects.isNull(NEW_MEMBER_IDS.get())) {
            NEW_MEMBER_IDS.set(new HashSet(16));
        }
        NEW_MEMBER_IDS.get().addAll(memberIds);
    }

    public static Set<Long> getNewMemberIds() {
        if (Objects.isNull(NEW_MEMBER_IDS.get())) {
            return Collections.EMPTY_SET;
        }
        return NEW_MEMBER_IDS.get();
    }

    public static void addBatchOverrideMemberIds(Collection<Long> memberIds) {
        if (Objects.isNull(OVERRIDE_MEMBER_IDS.get())) {
            OVERRIDE_MEMBER_IDS.set(new HashSet(16));
        }
        OVERRIDE_MEMBER_IDS.get().addAll(memberIds);
    }

    public static Set<Long> getOverrideMemberIds() {
        if (Objects.isNull(OVERRIDE_MEMBER_IDS.get())) {
            return Collections.EMPTY_SET;
        }
        return OVERRIDE_MEMBER_IDS.get();
    }

    private static boolean needCached() {
        return true;
    }

    public static void initAllWaitingImportData(List<ImportBillData> waitingImportBills) {
        if (ImportContextHolder.needCached()) {
            String requestId = RequestContext.getOrCreate().getRequestId();
            if (Objects.isNull(WAITING_PERSIST_BILLS.get(requestId))) {
                WAITING_PERSIST_BILLS.put(requestId, Collections.EMPTY_LIST);
                WAITING_PERSIST_PARENT_DEPENDS.put(requestId, Collections.EMPTY_SET);
            }
            WAITING_PERSIST_BILLS.put(requestId, new ArrayList<ImportBillData>(waitingImportBills));
            WAITING_PERSIST_PARENT_DEPENDS.put(requestId, new HashSet(16));
            waitingImportBills.stream().forEach(x -> {
                String parentNumber = (String)ImportHelper.getImportBillProp(x, "parent.number");
                if (StringUtils.isNotEmpty((CharSequence)parentNumber)) {
                    WAITING_PERSIST_PARENT_DEPENDS.get(requestId).add(parentNumber);
                }
            });
        }
    }

    public static List<ImportBillData> getAllWaitingImportData() {
        if (!ImportContextHolder.needCached()) {
            throw new IllegalStateException("current import no need cache imported data");
        }
        String requestId = RequestContext.getOrCreate().getRequestId();
        if (Objects.isNull(WAITING_PERSIST_BILLS.get(requestId))) {
            return Collections.EMPTY_LIST;
        }
        return WAITING_PERSIST_BILLS.get(requestId);
    }

    public static boolean checkNumberIsDepended(String memberNumber) {
        if (!ImportContextHolder.needCached()) {
            throw new IllegalStateException("current import no need cache imported data");
        }
        String requestId = RequestContext.getOrCreate().getRequestId();
        return WAITING_PERSIST_PARENT_DEPENDS.get(requestId).contains(memberNumber);
    }

    public static synchronized Optional<Pair<Integer, Long>> getDefinedProperty(String propertyNumber, String value, long modelId, long dimensionId) {
        String requestId = RequestContext.getOrCreate().getRequestId();
        if (Objects.isNull(DEFINED_PROPS_CACHE.get(requestId))) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model", "=", (Object)modelId);
            qfBuilder.add("dimension", "=", (Object)dimensionId);
            qfBuilder.add("parentid", ">", (Object)0);
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,number,propertyid.number pnumber,propertyid.propertyn propertyn", (QFilter[])qfBuilder.toArray());
            HashMap<Pair, Pair> propPairIdMap = new HashMap<Pair, Pair>(16);
            for (DynamicObject dc : dcs) {
                String propName = dc.getString("pnumber");
                String propValue = dc.getString("number");
                propPairIdMap.put(new Pair((Object)propName, (Object)propValue), new Pair((Object)Integer.valueOf(dc.getString("propertyn").replace("dpropertyid", "")), (Object)dc.getLong("id")));
            }
            qfBuilder = new QFBuilder();
            qfBuilder.add("model", "=", (Object)modelId);
            qfBuilder.add("dimension", "=", (Object)dimensionId);
            DynamicObjectCollection propList = QueryServiceHelper.query((String)"bcm_definedproperty", (String)"id,number,propertyn", (QFilter[])qfBuilder.toArray());
            for (DynamicObject dc : propList) {
                String propName = dc.getString("number");
                propPairIdMap.put(new Pair((Object)propName, (Object)""), new Pair((Object)Integer.valueOf(dc.getString("propertyn").replace("dpropertyid", "")), (Object)0L));
            }
            DEFINED_PROPS_CACHE.put(requestId, propPairIdMap);
        }
        return Optional.ofNullable(DEFINED_PROPS_CACHE.get(requestId).get(new Pair((Object)propertyNumber, (Object)value)));
    }

    private static String buildDefinedPropertyKey(String propertyNumber, String value) {
        return String.format("%s-%s", propertyNumber, value);
    }

    public static class LightImportBill {
        private int excelStartIndex;
        private String number;
        private String ctrlorg;

        public LightImportBill(int excelStartIndex, String number, String ctrlorg) {
            this.excelStartIndex = excelStartIndex;
            this.number = number;
            this.ctrlorg = ctrlorg;
        }

        public int getExcelStartIndex() {
            return this.excelStartIndex;
        }

        public String getNumber() {
            return this.number;
        }

        public String getCtrlorg() {
            return this.ctrlorg;
        }
    }

    private static class ImportInfo {
        private Boolean isDryRunPattern;
        private Date beginTime;

        public ImportInfo(Boolean isDryRunPattern) {
            this.isDryRunPattern = isDryRunPattern;
            this.beginTime = new Date();
        }

        public Boolean getDryRunPattern() {
            return this.isDryRunPattern;
        }

        public void setDryRunPattern(Boolean dryRunPattern) {
            this.isDryRunPattern = dryRunPattern;
        }

        public Date getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(Date beginTime) {
            this.beginTime = beginTime;
        }
    }
}

