/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.defaultValue.DefaultValueDBCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.SilentJSONUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.userdefinedproperty.DBBatchCache;

public class ImportHelper {
    public static final Set<String> NOT_PERMIT_SHARED_TYPES = new HashSet<String>(2);

    private ImportHelper() {
    }

    public static ImportOperateType getImportType(ImportContext ctx) {
        return ImportOperateType.codeOf((String)ctx.getOption().get("importtype"));
    }

    public static void numberCheck(List<ImportBillData> billDatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = billDatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData row = iterator.next();
            JSONObject data = row.getData();
            ImportEntityMapping entityMapping = row.getEntityMapping();
            entityMapping.getCols().forEach((k, v) -> {
                IDataEntityProperty property = v.getProperty();
                if (Objects.nonNull(data.get(k)) && (property instanceof BigIntProp || property instanceof IntegerProp || property instanceof DecimalProp)) {
                    try {
                        new BigDecimal((String)data.get(k));
                    }
                    catch (NumberFormatException e) {
                        String displayName = v.getDisplayName();
                        logger.log(Integer.valueOf(row.getStartIndex()), ResManager.loadKDString((String)"%s\u8bf7\u8f93\u5165\u6570\u5b57\u7c7b\u578b\u3002", (String)"InvShareRelaImportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[]{displayName})).fail();
                        iterator.remove();
                    }
                }
            });
        }
    }

    public static Map<String, DynamicObject> queryUserDefinedPropertyEntities(List<String> numbers, long modelId, long dimensionId) {
        DBBatchCache dbBatchCache = DBBatchCache.getDBBatchCacheSingleInstance(modelId, dimensionId);
        return dbBatchCache.getPropertyValuesCache();
    }

    public static Map<String, DynamicObject> queryDefaultValueEntities(long modelId) {
        DefaultValueDBCache dbCache = DefaultValueDBCache.getDBBatchCacheOfDefaultValue(modelId);
        return dbCache.getDefaultValuesCache();
    }

    public static boolean isShareType(Map<String, Object> rowData) {
        Object storageType = rowData.get("storagetype");
        return ImportHelper.isShareType(String.valueOf(storageType));
    }

    public static boolean isShareType(DynamicObject member) {
        return ImportHelper.isShareType(member.getString("storagetype"));
    }

    public static boolean isShareType(String storageType) {
        return StorageTypeEnum.SHARE.index.equals(storageType);
    }

    public static boolean isStorageType(Map<String, Object> rowData) {
        Object storageType = rowData.get("storagetype");
        return ImportHelper.isStorageType(String.valueOf(storageType));
    }

    public static boolean isStorageType(String storageType) {
        return StorageTypeEnum.STORAGE.index.equals(storageType);
    }

    public static boolean isStorageType(DynamicObject member) {
        return ImportHelper.isStorageType(member.getString("storagetype"));
    }

    @Deprecated
    public static String getParentNumber(Map<String, Object> rowData) {
        if (Objects.isNull(rowData.get("parent")) || StringUtils.isEmpty((CharSequence)rowData.get("parent").toString())) {
            return "";
        }
        return (String)SilentJSONUtils.cast(rowData.get("parent").toString(), LinkedHashMap.class).get("number");
    }

    public static long getIcDimensionID(long modelId) {
        Optional<Long> icDimensionId = BatchImportReadOnlyCache.getIcDimensionIDByModel(modelId);
        if (!icDimensionId.isPresent()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u5f80\u6765\u7ec4\u7ec7\u201c%s\u201d\u6240\u5728\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u521b\u5efa\u662f\u5426\u5b8c\u5584\u3002", (String)"ImportHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.INTERCOMPANY.getNumber()));
        }
        return icDimensionId.get();
    }

    public static long getMyOrgDimensionID(long modelId) {
        Optional<Long> myOrgDimensionId = BatchImportReadOnlyCache.getMyOrgDimensionIDByModel(modelId);
        if (!myOrgDimensionId.isPresent()) {
            return 0L;
        }
        return myOrgDimensionId.get();
    }

    public static String getNumber(DynamicObject dynamicObject) {
        return dynamicObject.getString("number");
    }

    public static void syncDimmEffectiveSetting(DynamicObjectCollection sourceDmEntrys, DynamicObject targetMemberTreeDy) {
        DynamicObjectCollection shareDmEntry = targetMemberTreeDy.getDynamicObjectCollection("dm_entry");
        shareDmEntry.clear();
        int seq = 1;
        for (DynamicObject storeDmEntry : sourceDmEntrys) {
            DynamicObject dmDyn = shareDmEntry.addNew();
            dmDyn.set("dm_val", (Object)storeDmEntry.getString("dm_val"));
            dmDyn.set("dm_dim", storeDmEntry.get("dm_dim"));
            dmDyn.set("seq", (Object)seq);
            ++seq;
        }
    }

    public static long getBaseDataIdCompatible(DynamicObject dyn, String prop) {
        return Objects.isNull(dyn.get(prop)) ? 0L : (dyn.get(prop) instanceof Long ? dyn.getLong(prop) : dyn.getDynamicObject(prop).getLong("id"));
    }

    public static Object getImportBillProp(ImportBillData billData, String prop) {
        String[] propPathKeys = prop.split("\\.");
        if (propPathKeys.length > 2) {
            throw new IllegalArgumentException("current just support the depth 2. ");
        }
        if (Objects.isNull(billData.getData().get((Object)propPathKeys[0]))) {
            return "";
        }
        Object parentObj = billData.getData().get((Object)propPathKeys[0]);
        if (propPathKeys.length < 2) {
            return parentObj;
        }
        if (!(parentObj instanceof Map)) {
            throw new IllegalArgumentException("invalid prop path, parentObj is " + (parentObj == null ? "null" : parentObj.getClass()));
        }
        Map parentMap = (Map)parentObj;
        if (!parentMap.containsKey(propPathKeys[1])) {
            return "";
        }
        Object secondObj = parentMap.get(propPathKeys[1]);
        return Objects.isNull(secondObj) ? "" : secondObj;
    }

    public static List<Object> getImportBillProp(ImportBillData billData, String entity, String prop) {
        String[] propPathKeys = prop.split("\\.");
        if (propPathKeys.length > 2) {
            throw new IllegalArgumentException("current just support the depth 2. ");
        }
        JSONArray entityList = (JSONArray)billData.getData().get((Object)entity);
        ArrayList res = Lists.newArrayListWithExpectedSize((int)entityList.size());
        for (Object jObj : entityList) {
            res.add(ImportHelper.getImportBillProp((JSONObject)jObj, propPathKeys));
        }
        return res;
    }

    private static Object getImportBillProp(JSONObject jObj, String[] propPathKeys) {
        Object parentObj = jObj.get((Object)propPathKeys[0]);
        if (Objects.isNull(parentObj)) {
            return "";
        }
        if (propPathKeys.length < 2) {
            return parentObj;
        }
        if (!(parentObj instanceof Map)) {
            throw new IllegalArgumentException("invalid prop path, parentObj is " + (parentObj == null ? "null" : parentObj.getClass()));
        }
        Map parentMap = (Map)parentObj;
        if (!parentMap.containsKey(propPathKeys[1])) {
            return "";
        }
        Object secondObj = parentMap.get(propPathKeys[1]);
        return Objects.isNull(secondObj) ? "" : secondObj;
    }

    public static boolean getImportBillBooleanProp(ImportBillData billData, String prop) {
        Object value = ImportHelper.getImportBillProp(billData, prop);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return "1".equals(value.toString()) || "yes".equalsIgnoreCase(value.toString()) || ResManager.loadKDString((String)"\u662f", (String)"ImportHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(value.toString()) || Boolean.TRUE.toString().equalsIgnoreCase(value.toString());
    }

    public static String buildExceptionMsg(Exception e, int stackLimit, boolean isSimple) {
        List stackMsgs = Arrays.stream(e.getStackTrace()).filter(ele -> Objects.nonNull(ele.getClassName()) && ele.getClassName().startsWith("kd.fi.bcm")).map(ele -> isSimple ? String.format("%s:%s", ele.getFileName(), ele.getLineNumber()) : ele.toString()).collect(Collectors.toList());
        if (stackLimit > 0) {
            stackMsgs = stackMsgs.subList(0, Math.min(stackMsgs.size(), stackLimit));
        }
        return String.format("%s %s[%s] %s", ImportMsgUtils.unexpectedError(), e.getMessage(), RequestContext.get().getTraceId(), String.join((CharSequence)",", stackMsgs));
    }

    static {
        NOT_PERMIT_SHARED_TYPES.add(StorageTypeEnum.UNSHARE.index);
    }
}

