/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.helper;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import org.junit.Assert;

public class ImportResultEntry {
    private long pkId = 0L;
    private String errMsg = null;
    private Optional<DynamicObject> importedMemTreeDy = Optional.empty();
    private int index;

    public ImportResultEntry(long pkId, String errMsg, int index) {
        this.pkId = pkId;
        this.errMsg = errMsg;
        this.index = index;
    }

    public boolean isErr() {
        return this.pkId == 0L && StringUtils.isNotEmpty((CharSequence)this.errMsg);
    }

    public static ImportResultEntry error(String errMsg, int index) {
        return new ImportResultEntry(0L, errMsg, index);
    }

    public static ImportResultEntry error(Exception e, int index) {
        return new ImportResultEntry(0L, ImportHelper.buildExceptionMsg(e, 2, true), index);
    }

    public static ImportResultEntry success(long pkId, DynamicObject memberTreeDy, int index) {
        Assert.assertNotNull((Object)memberTreeDy);
        ImportResultEntry entry = new ImportResultEntry(pkId, null, index);
        entry.setImportedMemTreeDy(Optional.of(memberTreeDy));
        return entry;
    }

    public long getPkId() {
        return this.pkId;
    }

    public void setPkId(long pkId) {
        this.pkId = pkId;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public Optional<DynamicObject> getImportedMemTreeDy() {
        return this.importedMemTreeDy;
    }

    public void setImportedMemTreeDy(Optional<DynamicObject> importedMemTreeDy) {
        this.importedMemTreeDy = importedMemTreeDy;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

