/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.common.Pair;

public class RowDataExtUtil {
    private static final String EXT_EXISTING_RECORD = "existingRecordDy";
    private static final String EXT_PARENT = "extparent";
    private static final String EXT_CSLSCHEME = "extcslscheme";
    private static final String EXT_BELONG_CSLSCHEME = "extbelcslscheme";
    private static final String EXT_CURRENCY = "currency";
    private static final String EXT_CTRLORG = "extctrorg";
    private static final String EXT_ASSO = "extasso";
    private static final String EXT_DEFINED_PROPS = "extdefinedprops";
    private static final String EXT_EXISTING_DM_ENTRY = "existingDmEntry";
    private static final String EXT_EXISTING_MEMBER_PERMISSION = "memberAssignmentPermission";
    private static final String EXT_ID = "id";
    private static final String EXT_VALUE = "value";
    private static final Set<String> _allExtProps = new HashSet<String>(Arrays.asList("existingRecordDy", "extparent", "extcslscheme", "extctrorg", "extasso", "extdefinedprops", "existingDmEntry", "memberAssignmentPermission", "id", "value"));

    public static final void addExistingRecord(ImportBillData billData, DynamicObject existingRecordDy) {
        billData.getData().put(EXT_EXISTING_RECORD, (Object)existingRecordDy);
    }

    public static final Optional<DynamicObject> getExistingRecord(ImportBillData billData) {
        return Optional.ofNullable((DynamicObject)billData.getData().get((Object)EXT_EXISTING_RECORD));
    }

    public static final void addExtObject(ImportBillData billData, Object dynamicObjects, String key) {
        billData.getData().put(key, dynamicObjects);
    }

    public static final Optional<Object> getExtObject(ImportBillData billData, String key) {
        return Optional.ofNullable(billData.getData().get((Object)key));
    }

    public static final void addParent(ImportBillData billData, DynamicObject parentData) {
        billData.getData().put(EXT_PARENT, (Object)parentData);
    }

    public static final Optional<DynamicObject> getParent(ImportBillData billData) {
        return Optional.ofNullable((DynamicObject)billData.getData().get((Object)EXT_PARENT));
    }

    public static final void addCslScheme(ImportBillData billData, DynamicObject cslScheme) {
        billData.getData().put(EXT_CSLSCHEME, (Object)cslScheme);
    }

    public static final void addBelongCslScheme(ImportBillData billData, DynamicObject cslScheme) {
        billData.getData().put(EXT_BELONG_CSLSCHEME, (Object)cslScheme);
    }

    public static final Optional<DynamicObject> getCslScheme(ImportBillData billData) {
        return Optional.ofNullable((DynamicObject)billData.getData().get((Object)EXT_CSLSCHEME));
    }

    public static final Optional<DynamicObject> getBelongCslScheme(ImportBillData billData) {
        return Optional.ofNullable((DynamicObject)billData.getData().get((Object)EXT_BELONG_CSLSCHEME));
    }

    public static final void addCurrency(ImportBillData billData, DynamicObject currency) {
        billData.getData().put(EXT_CURRENCY, (Object)currency);
    }

    public static final Optional<DynamicObject> getCurrency(ImportBillData billData) {
        return Optional.ofNullable((DynamicObject)billData.getData().get((Object)EXT_CURRENCY));
    }

    public static final void addDefinedProps(ImportBillData billData, Map<String, Pair<Integer, Long>> definedPropSeqIdMap) {
        billData.getData().put(EXT_DEFINED_PROPS, definedPropSeqIdMap);
    }

    public static final Map<String, Pair<Integer, Long>> getDefinedProps(ImportBillData billData) {
        if (billData.getData().containsKey((Object)EXT_DEFINED_PROPS)) {
            return (Map)billData.getData().get((Object)EXT_DEFINED_PROPS);
        }
        return Collections.EMPTY_MAP;
    }

    public static final void addCtrlOrgId(ImportBillData billData, DynamicObject ctrlOrgId) {
        billData.getData().put(EXT_CTRLORG, (Object)ctrlOrgId);
    }

    public static final Optional<DynamicObject> getCtrlOrgId(ImportBillData billData) {
        return Optional.ofNullable((DynamicObject)billData.getData().get((Object)EXT_CTRLORG));
    }

    public static final void addAssoDy(ImportBillData billData, DynamicObject ctrlOrgId) {
        billData.getData().put(EXT_ASSO, (Object)ctrlOrgId);
    }

    public static final Optional<DynamicObject> getAssoDy(ImportBillData billData) {
        return Optional.ofNullable((DynamicObject)billData.getData().get((Object)EXT_ASSO));
    }

    public static final void addValue(ImportBillData billData, Object value) {
        billData.getData().put(EXT_VALUE, value);
    }

    public static final Object getValue(ImportBillData billData) {
        return billData.getData().get((Object)EXT_VALUE);
    }

    public static final void addId(ImportBillData billData, long id) {
        billData.getData().put(EXT_ID, (Object)id);
    }

    public static final long getId(ImportBillData billData) {
        return (Long)billData.getData().get((Object)EXT_ID);
    }

    public static final boolean isIdValid(ImportBillData billData) {
        Long id = RowDataExtUtil.getId(billData);
        return Objects.nonNull(id) && id > 0L;
    }

    public static void clearAllExtProps(Collection<ImportBillData> billDatas) {
        if (CollectionUtils.isEmpty(billDatas)) {
            return;
        }
        _allExtProps.stream().filter(x -> !EXT_ID.equals(x)).forEach(p -> billDatas.stream().forEach(x -> x.getData().remove(p)));
    }

    public static boolean checkNumberLength(MainEntityType dataEntityType, ImportBillData billData) {
        TextProp tpBaseNameProp = (TextProp)dataEntityType.getProperty("number");
        int iNameLen = tpBaseNameProp.getMaxLenth();
        String trim = billData.getData().get((Object)"number").toString().trim();
        int len = trim.length();
        return len > iNameLen;
    }

    public static boolean checkNameLength(MainEntityType dataEntityType, ImportBillData billData) {
        TextProp tpBaseNameProp = (TextProp)dataEntityType.getProperty("name");
        int iNameLen = tpBaseNameProp.getMaxLenth();
        String trim = billData.getData().get((Object)"name").toString().trim();
        int len = trim.length();
        return len > iNameLen;
    }
}

