/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.helper;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.cache.prop.DefinedPropertyUtil;
import kd.fi.bcm.common.enums.dimension.OrgStoreStatusEnum;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;

public class ShareMemberHelper {
    public static void syncSameParentMembers(List<DynamicObject> sourceMembers) {
        BatchProcessHelper.batchHandle(sourceMembers, (int)2000, source -> {
            ArrayList needUpdateMembers = new ArrayList(16);
            sourceMembers.forEach(s -> {
                DynamicObject[] needUpdateMember;
                for (DynamicObject obj : needUpdateMember = ShareMemberHelper.getSameParentMembers(s.getLong("model.id"), s)) {
                    obj.set("aggoprt", (Object)s.getInt("aggoprt"));
                    obj.set("modifytime", (Object)new Date());
                    needUpdateMembers.add(obj);
                }
            });
            if (needUpdateMembers.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            try (TXHandle tx = TX.requiresNew((String)"syncSameParentMembers");){
                try {
                    SaveServiceHelper.update((DynamicObject[])needUpdateMembers.toArray(new DynamicObject[0]));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            return Collections.EMPTY_LIST;
        }, null, (int)4);
    }

    public static DynamicObject[] getSameParentMembers(long modelId, DynamicObject member) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("number", "=", (Object)member.getString("number")));
        filter.and(new QFilter("parent.number", "=", (Object)member.getString("parent.number")));
        filter.and(new QFilter("status", "=", (Object)OrgStoreStatusEnum.AUDIT.getValue()));
        filter.and(new QFilter("id", "!=", (Object)member.getLong("id")));
        return BusinessDataServiceHelper.load((String)member.getDynamicObjectType().getName(), (String)"id,parent.number,aggoprt,modifytime", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject syncStorageSourcePropertyToShare(long dimensionId, DynamicObject sourceMember, DynamicObject shareMember, boolean isSameParent, String originName) {
        shareMember = BusinessDataServiceHelper.loadSingle((Object)shareMember.getLong("id"), (String)ImportContextHolder.getEntityName());
        String oldName = shareMember.getString("name");
        if (isSameParent) {
            shareMember.set("aggoprt", sourceMember.get("aggoprt"));
        }
        shareMember.set("number", sourceMember.get("number"));
        shareMember.set("description", sourceMember.get("description"));
        shareMember.set("storagetype", (Object)"3");
        for (int i = 1; i <= DefinedPropertyUtil.getDefinedProperty((Long)dimensionId).size(); ++i) {
            shareMember.set("dpropertyid" + i, sourceMember.get("dpropertyid" + i));
        }
        String entityName = "bcm_dimension";
        boolean dimType = "bcm_structofextend".equals(sourceMember.getDynamicObjectType().getName());
        if (dimType) {
            entityName = "bcm_dimension_ext";
        }
        DynamicObject dimensionDy = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)entityName);
        String type = dimensionDy.getString("number");
        if (!dimType && !dimensionDy.getBoolean("issysdimension")) {
            shareMember.set("datatype", sourceMember.get("datatype"));
            shareMember.set("value", sourceMember.get("value"));
            if (shareMember.getDataEntityType().getProperties().contains((Object)"enumitem")) {
                shareMember.set("enumitem", sourceMember.get("enumitem"));
            }
        }
        if ("Entity".equals(type)) {
            shareMember.set("currency", sourceMember.get("currency"));
            shareMember.set("ctrlorg", sourceMember.get("ctrlorg"));
            shareMember.set("isinnerorg", sourceMember.get("isinnerorg"));
            shareMember.set("isindependentorg", sourceMember.get("isindependentorg"));
            shareMember.set("creditcode", sourceMember.get("creditcode"));
            ShareMemberHelper.setNameChangeRd(sourceMember, shareMember, oldName, originName);
            shareMember.set("shownumber", sourceMember.get("shownumber"));
            DynamicObject parentDy = PersistProxy.instance.getById(sourceMember.getLong("parent.id"), false);
            if (parentDy != null && shareMember.getString("parent.number").equals(parentDy.getString("number"))) {
                DynamicObjectCollection bizChangeRds = sourceMember.getDynamicObjectCollection("bizchangerds");
                DynamicObjectCollection newRecords = new DynamicObjectCollection();
                for (DynamicObject biz : bizChangeRds) {
                    newRecords.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)biz, (boolean)true, (boolean)true)));
                }
                shareMember.set("bizchangerds", (Object)newRecords);
            }
        } else {
            shareMember.set("name", sourceMember.get("name"));
        }
        if ("Account".equals(type)) {
            Long storeMemberId;
            shareMember.set("islosscarry", sourceMember.get("islosscarry"));
            shareMember.set("iscaltype", sourceMember.get("iscaltype"));
            shareMember.set("datatype", sourceMember.get("datatype"));
            shareMember.set("simplename", sourceMember.get("simplename"));
            shareMember.set("accountuse", sourceMember.get("accountuse"));
            shareMember.set("accounttype", sourceMember.get("accounttype"));
            shareMember.set("drcrdirect", sourceMember.get("drcrdirect"));
            shareMember.set("isparticipmerge", sourceMember.get("isparticipmerge"));
            shareMember.set("isrelateorg", sourceMember.get("isrelateorg"));
            shareMember.set("value", sourceMember.get("value"));
            ShareMemberHelper.assembleAccountOffsetProperty(sourceMember, shareMember);
            if (shareMember.getDataEntityType().getProperties().containsKey((Object)"enumitem")) {
                shareMember.set("enumitem", sourceMember.get("enumitem"));
            }
            shareMember.set("exchange", sourceMember.get("exchange"));
            shareMember.set("entryrate", sourceMember.get("entryrate"));
            shareMember.set("assostoremem", sourceMember.get("assostoremem"));
            if ("bcm_accountmembertree".equals(sourceMember.getDynamicObjectType().getName()) && !(storeMemberId = Long.valueOf(sourceMember.getLong("id"))).equals(shareMember.getLong("id"))) {
                ImportHelper.syncDimmEffectiveSetting(sourceMember.getDynamicObjectCollection("dm_entry"), shareMember);
            }
        }
        if ("Period".equals(type)) {
            shareMember.set("simplename", sourceMember.get("simplename"));
            shareMember.set("effmonth", sourceMember.get("effmonth"));
            shareMember.set("effday", sourceMember.get("effday"));
            shareMember.set("expmonth", sourceMember.get("expmonth"));
            shareMember.set("expday", sourceMember.get("expday"));
        }
        if ("Process".equals(type)) {
            shareMember.set("enablehisrec", sourceMember.get("enablehisrec"));
            shareMember.set("dchangetype", sourceMember.get("dchangetype"));
            shareMember.set("datasource", sourceMember.get("datasource"));
        }
        if ("AuditTrail".equals(type)) {
            shareMember.set("datasource", sourceMember.get("datasource"));
            shareMember.set("assostoremem", sourceMember.get("assostoremem"));
        }
        if ("ChangeType".equals(type)) {
            shareMember.set("isyearendchargeagaint", sourceMember.get("isyearendchargeagaint"));
            shareMember.set("datatype", sourceMember.get("datatype"));
            shareMember.set("changeway", sourceMember.get("changeway"));
            shareMember.set("isexchange", sourceMember.get("isexchange"));
        }
        if ("Scenario".equals(type)) {
            shareMember.set("dchangetype", (Object)sourceMember.getString("dchangetype"));
            shareMember.set("enablehisrec", (Object)sourceMember.getString("dchangetype"));
        }
        if ("bcm_userdefinedmembertree".equals(sourceMember.getDynamicObjectType().getName())) {
            shareMember.set("assostoremem", sourceMember.get("assostoremem"));
        }
        if (dimType) {
            String fieldMapped;
            shareMember.set("simplename", (Object)sourceMember.getString("simplename"));
            shareMember.set("description", (Object)sourceMember.getString("description"));
            shareMember.set("exchange", (Object)sourceMember.getString("exchange"));
            shareMember.set("entryrate", (Object)sourceMember.getString("entryrate"));
            shareMember.set("datatype", (Object)sourceMember.getString("datatype"));
            Object mapped = ThreadCache.get((Object)dimensionId);
            if (mapped != null && StringUtils.isNotEmpty((String)(fieldMapped = (String)((Map)mapped).get(shareMember.getLong("id"))))) {
                shareMember.set("fieldmapped", (Object)fieldMapped);
            }
        }
        ShareMemberHelper.updateModifyInfo(shareMember);
        return shareMember;
    }

    private static void assembleAccountOffsetProperty(DynamicObject sourceMember, DynamicObject shareMember) {
        DynamicObject sourceMemberPart = sourceMember.getDynamicObject("accountpart");
        if (sourceMemberPart == null) {
            return;
        }
        DynamicObject accountPartDy = shareMember.getDynamicObject("accountpart");
        if (Objects.isNull(accountPartDy)) {
            long newPartId = ShareMemberHelper.createNewAccountPart(sourceMemberPart.getBoolean("isaccountoffset"));
            shareMember.set("accountpart", (Object)newPartId);
        } else {
            accountPartDy.set("isaccountoffset", (Object)sourceMemberPart.getBoolean("isaccountoffset"));
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{accountPartDy});
        }
    }

    private static long createNewAccountPart(boolean userDefinedIsAccountOffset) {
        DynamicObject newPartDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofaccountp");
        newPartDy.set("id", (Object)DBServiceHelper.genGlobalLongId());
        newPartDy.set("isaccountoffset", (Object)userDefinedIsAccountOffset);
        DynamicObject part = (DynamicObject)SaveServiceHelper.save((IDataEntityType)newPartDy.getDynamicObjectType(), (Object[])new DynamicObject[]{newPartDy})[0];
        return part.getLong("id");
    }

    private static void setNameChangeRd(DynamicObject sourceMember, DynamicObject shareMember, String oldName, String originName) {
        DynamicObjectCollection sourceRecords = sourceMember.getDynamicObjectCollection("namechangerds");
        if (oldName.equals(originName)) {
            shareMember.set("name", (Object)sourceMember.getString("name"));
            shareMember.set("simplename", (Object)sourceMember.getString("simplename"));
            shareMember.set("modifytime", (Object)TimeServiceHelper.now());
            DynamicObjectCollection nameRecords = shareMember.getDynamicObjectCollection("namechangerds");
            nameRecords.clear();
            sourceRecords.forEach(s -> {
                DynamicObject newRow = nameRecords.addNew();
                newRow.set("namerds", (Object)s.getString("namerds"));
                newRow.set("simplenamerds", (Object)s.getString("simplenamerds"));
                newRow.set("nameeffdate", (Object)s.getDate("nameeffdate"));
                newRow.set("nameexpdate", (Object)s.getDate("nameexpdate"));
                newRow.set("namemodifytime", (Object)TimeServiceHelper.now());
                newRow.set("namemodifier", s.get("namemodifier"));
                newRow.set("seq", (Object)nameRecords.size());
            });
            shareMember.set("namechangerds", (Object)nameRecords);
        }
    }

    private static void updateModifyInfo(DynamicObject dy) {
        dy.set("enable", (Object)"1");
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date createTime = Date.from(instant);
        dy.set("modifytime", (Object)createTime);
        dy.set("modifier", (Object)RequestContext.get().getUserId());
    }
}

