/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.MemNumberInfoVO;

public class UserDefinedPropertyDependencyResolver
implements AutoCloseable {
    private Map<String, MemNumberInfoVO> existingNumberInfos = null;
    private Set<String> curBatchNumbers = new HashSet<String>(16);

    public UserDefinedPropertyDependencyResolver(List<ImportBillData> waitingBills) {
        if (!CollectionUtils.isEmpty(waitingBills)) {
            this.existingNumberInfos = new HashMap<String, MemNumberInfoVO>(waitingBills.size());
            waitingBills.stream().forEach(x -> {
                String memNumber = x.getData().getString("number");
                if (!this.existingNumberInfos.containsKey(memNumber)) {
                    this.existingNumberInfos.put(memNumber, new MemNumberInfoVO());
                }
            });
            ImportContextHolder.initAllWaitingImportData(waitingBills);
        }
    }

    public void notifyBillSelected(ImportBillData selectedBill) {
        this.curBatchNumbers.add(selectedBill.getData().getString("number"));
    }

    public boolean checkBillIsDependPrevious(ImportBillData importBillData) {
        String parentStr = importBillData.getData().getString("parentnumber");
        if (StringUtils.isNotEmpty((CharSequence)parentStr) && kd.bos.util.StringUtils.isNotEmpty((String)parentStr) && this.existingNumberInfos.containsKey(parentStr)) {
            return true;
        }
        String memNumber = importBillData.getData().getString("number");
        return this.curBatchNumbers.contains(memNumber);
    }

    @Override
    public void close() {
        if (Objects.nonNull(this.existingNumberInfos)) {
            this.existingNumberInfos.clear();
        }
        if (Objects.nonNull(this.curBatchNumbers)) {
            this.curBatchNumbers.clear();
        }
    }
}

