/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.persist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistentHelper;

public class BatchDbCache {
    protected static WatchLogger LOG = BcmLogFactory.getWatchLogInstance((boolean)true, BatchDbCache.class);
    protected static final int DB_BATCH_SIZE = 100000;
    private boolean _isCacheInited = false;
    private Map<Long, DynamicObject> idIndex = Collections.synchronizedMap(new HashMap(1024));
    private Map<String, Map<Long, DynamicObject>> lowNumberIndex = Collections.synchronizedMap(new HashMap(1024));
    private Map<Long, Map<Long, DynamicObject>> parentIdIndex = Collections.synchronizedMap(new HashMap(1024));
    private Map<String, Map<Long, DynamicObject>> parentNumberIndex = Collections.synchronizedMap(new HashMap(1024));

    public BatchDbCache() {
        this.initCache();
    }

    public void clearCurrentBatchDBCache() {
        this.idIndex.clear();
        this.lowNumberIndex.clear();
        this.parentIdIndex.clear();
        this.parentNumberIndex.clear();
    }

    private void initCache() {
        if (this._isCacheInited) {
            return;
        }
        long tick = System.currentTimeMillis();
        String dimNum = ImportContextHolder.getImportContext().getImportDimension().getString("number");
        String modelNum = ImportContextHolder.getImportContext().getImportModel().getString("number");
        List ids = MemberReader.getAllNodeByDimNum((String)dimNum, (String)modelNum).stream().map(m -> m.getId()).collect(Collectors.toList());
        ArrayList<DynamicObject> entityList = new ArrayList<DynamicObject>(ids.size());
        LOG.info(String.format("dimension_import:: initCache query id cost time: %s, id size: %s", System.currentTimeMillis() - tick, ids.size()));
        tick = System.currentTimeMillis();
        while (!ids.isEmpty()) {
            HashSet<Long> tmpIds = new HashSet<Long>(100000);
            if (ids.size() > 100000) {
                tmpIds.addAll(ids.subList(0, 100000));
            } else {
                tmpIds.addAll(ids);
            }
            ids.removeAll(tmpIds);
            if ("bcm_icmembertree".equals(ImportContextHolder.getEntityName())) {
                entityList.addAll((Collection<DynamicObject>)QueryServiceHelper.query((String)ImportContextHolder.getEntityName(), (String)"id,number,longnumber,storagetype,name,level,dseq,simplename,aggoprt,isleaf,parent,parent.id,parent.number,modifier,modifytime,issysmember,status,enable,description", (QFilter[])new QFilter[]{new QFilter("id", "in", tmpIds)}));
                continue;
            }
            entityList.addAll(this.loadEntity(ImportContextHolder.getEntityName(), PersistentHelper.selectFields(ImportContextHolder.getEntityName(), ImportContextHolder.getImportType()), tmpIds));
        }
        Map<Object, Object> shieldMap = new HashMap(16);
        if (!"bcm_icmembertree".equals(ImportContextHolder.getEntityName()) && !"bcm_userdefinedmembertree".equals(ImportContextHolder.getEntityName())) {
            shieldMap = this.getShieldRules();
        }
        LOG.info(String.format("dimension_import:: initCache load data cost time: %s, id size: %s", System.currentTimeMillis() - tick, ids.size()));
        tick = System.currentTimeMillis();
        Map<Object, Object> scales = new HashMap(16);
        if ("bcm_accountmembertree".equals(ImportContextHolder.getEntityName())) {
            scales = this.getAccountScale();
        }
        for (DynamicObject member : entityList) {
            long id = member.getLong("id");
            if (shieldMap.containsKey(id)) {
                member.set("shielddim", shieldMap.get(id));
            }
            if (!scales.isEmpty()) {
                member.set("accountscale", scales.get(member.getString("number")));
            }
            this.addOrUpdateMember(member);
        }
        LOG.info(String.format("dimension_import:: initCache addOrUpdateMember cost time: %s, id size: %s", System.currentTimeMillis() - tick, ids.size()));
        this._isCacheInited = true;
    }

    private Map<Long, String> getShieldRules() {
        QFBuilder filter = new QFBuilder("rule.model", "=", (Object)ImportContextHolder.getModelId());
        return QueryServiceHelper.query((String)"bcm_aggshieldruledis", (String)"id, member, rule.rule", (QFilter[])filter.toArray()).stream().collect(Collectors.toMap(x -> x.getLong("member"), x -> x.getString("rule.rule"), (v1, v2) -> v1));
    }

    private Map<String, String> getAccountScale() {
        QFBuilder filter = new QFBuilder("model", "=", (Object)ImportContextHolder.getModelId());
        return QueryServiceHelper.query((String)"bcm_accountscale", (String)"accountnumber, scale", (QFilter[])filter.toArray()).stream().collect(Collectors.toMap(x -> x.getString("accountnumber"), x -> x.getString("scale"), (v1, v2) -> v1));
    }

    private List<DynamicObject> loadEntity(String entityName, String fields, Set<Long> ids) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        return Arrays.asList(dynamicObjects);
    }

    private void addOrUpdateMember(DynamicObject memberDy) {
        if (Objects.isNull(memberDy)) {
            throw new IllegalArgumentException("param memberDy is null");
        }
        if (memberDy != null) {
            long memberId = memberDy.getLong("id");
            if (memberId <= 0L) {
                throw new IllegalArgumentException("memberDy is invalid: id need exceed 0");
            }
            String memberNumber = memberDy.getString("number");
            Optional<DynamicObject> existingCacheMem = Optional.ofNullable(this.idIndex.get(memberId));
            this.idIndex.put(memberId, memberDy);
            String lowMemberNumber = memberNumber.toLowerCase(Locale.ENGLISH);
            if (Objects.isNull(this.lowNumberIndex.get(lowMemberNumber))) {
                this.lowNumberIndex.put(lowMemberNumber, Collections.synchronizedMap(new HashMap(1)));
            }
            if (existingCacheMem.isPresent()) {
                String existingNumber = existingCacheMem.get().getString("number");
                this.lowNumberIndex.get(existingNumber.toLowerCase(Locale.ENGLISH)).remove(memberId);
            }
            this.lowNumberIndex.get(lowMemberNumber).put(memberId, memberDy);
            long parentId = ImportHelper.getBaseDataIdCompatible(memberDy, "parent");
            if (parentId > 0L) {
                if (Objects.isNull(this.parentIdIndex.get(parentId))) {
                    this.parentIdIndex.put(parentId, Collections.synchronizedMap(new HashMap(4)));
                }
                if (existingCacheMem.isPresent()) {
                    long existingParentId = ImportHelper.getBaseDataIdCompatible(existingCacheMem.get(), "parent");
                    this.parentIdIndex.get(existingParentId).remove(memberId);
                }
                this.parentIdIndex.get(parentId).put(memberId, memberDy);
                Object parent = memberDy.get("parent");
                String parentNumber = null;
                if (parent instanceof DynamicObject) {
                    parentNumber = ((DynamicObject)parent).getString("number");
                } else if (this.idIndex.containsKey(parent)) {
                    parentNumber = this.idIndex.get((Long)parent).getString("number");
                }
                if (Objects.isNull(this.parentNumberIndex.get(parentNumber))) {
                    this.parentNumberIndex.put(parentNumber, Collections.synchronizedMap(new HashMap(4)));
                }
                if (existingCacheMem.isPresent()) {
                    long existingParentId = ImportHelper.getBaseDataIdCompatible(existingCacheMem.get(), "parent");
                    String existingParentNum = this.idIndex.get(existingParentId).getString("number");
                    this.parentNumberIndex.get(existingParentNum).remove(memberId);
                }
                this.parentNumberIndex.get(parentNumber).put(memberId, memberDy);
            }
        }
    }

    public synchronized void deleteMember(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ids.stream().forEach(id -> {
            DynamicObject member = this.idIndex.remove(id);
            if (Objects.nonNull(member)) {
                String existingNumber = member.getString("number");
                this.lowNumberIndex.get(existingNumber.toLowerCase(Locale.ENGLISH)).remove(id);
                long parentId = ImportHelper.getBaseDataIdCompatible(member, "parent");
                if (parentId > 0L) {
                    this.parentIdIndex.get(parentId).remove(id);
                    String existingParentNum = member.getDynamicObject("parent").getString("number");
                    this.parentNumberIndex.get(existingParentNum).remove(id);
                }
            }
        });
    }

    @Deprecated
    public synchronized void updateMemberById(Long[] ids) {
        if (Objects.isNull(ids) || ids.length == 0) {
            return;
        }
        String entityName = ImportContextHolder.getEntityName();
        DynamicObject[] entities = BusinessDataServiceHelper.load((String)entityName, (String)PersistentHelper.selectFields(entityName, ImportContextHolder.getImportType()), (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        ImportContextHolder.getOrCreateBatchDbCacheInstance().addOrUpdateBatchMember(entities);
    }

    public synchronized void updateMembers(List<DynamicObject> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        ImportContextHolder.getOrCreateBatchDbCacheInstance().addOrUpdateBatchMember(entities);
    }

    public void addOrUpdateBatchMember(List<DynamicObject> members) {
        BatchProcessHelper.batchHandle(members, (int)2000, (int)500, subMemList -> {
            subMemList.stream().forEach(x -> {
                boolean expression;
                Long id = x.getLong("id");
                boolean bl = expression = Objects.nonNull(id) && id > 0L;
                if (!expression) {
                    throw new IllegalArgumentException("member id is null or id is 0");
                }
                String number = ImportHelper.getNumber(x);
                if (StringUtils.isEmpty((CharSequence)number)) {
                    throw new IllegalArgumentException("member number is null or empty");
                }
                this.addOrUpdateMember((DynamicObject)x);
            });
            return Collections.EMPTY_LIST;
        }, (Integer)100, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
    }

    public void addOrUpdateBatchMember(DynamicObject[] members) {
        this.addOrUpdateBatchMember(Arrays.asList(members));
    }

    public Optional<DynamicObject> getByIdFromCache(Long memberId) {
        if (Objects.isNull(memberId)) {
            memberId = 0L;
        }
        return Optional.ofNullable(this.idIndex.get(memberId));
    }

    public Collection<DynamicObject> getByNumberFromCache(String memberNumber) {
        String lowMemberNumber;
        if (Objects.isNull(memberNumber)) {
            memberNumber = "";
        }
        if (Objects.nonNull(this.lowNumberIndex.get(lowMemberNumber = memberNumber.toLowerCase(Locale.ENGLISH)))) {
            return Collections.unmodifiableCollection(this.lowNumberIndex.get(lowMemberNumber).values());
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<DynamicObject> getByParentIdFromCache(Long parentId) {
        if (Objects.isNull(parentId)) {
            parentId = 0L;
        }
        if (Objects.nonNull(this.parentIdIndex.get(parentId))) {
            return Collections.unmodifiableCollection(this.parentIdIndex.get(parentId).values());
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<DynamicObject> getByParentNumberFromCache(String parentNumber) {
        if (Objects.isNull(parentNumber)) {
            parentNumber = "";
        }
        if (Objects.nonNull(this.parentNumberIndex.get(parentNumber))) {
            return Collections.unmodifiableCollection(this.parentNumberIndex.get(parentNumber).values());
        }
        return Collections.EMPTY_LIST;
    }

    public List<DynamicObject> getAllFromCache() {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(16);
        objs.addAll(this.idIndex.values());
        return Collections.unmodifiableList(objs);
    }

    public Set<String> getAllNumbers() {
        return this.lowNumberIndex.keySet();
    }

    private boolean isCacheInited() {
        return this._isCacheInited;
    }
}

