/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.persist;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.CachedImportResult;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.DimensionCachedStore;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistentHelper;

public class CacheStoreManager {
    private static Map<String, DimensionCachedStore> cachedStoreMap = new HashMap<String, DimensionCachedStore>(3);

    private CacheStoreManager() {
    }

    public static DimensionCachedStore createNewStore(long modelId, long dimensionId, String memberEntityName) {
        String key = CachedImportResult.buildKey(modelId, dimensionId, memberEntityName);
        DimensionCachedStore dimCach = cachedStoreMap.remove(key);
        if (Objects.nonNull(dimCach)) {
            dimCach.close();
        }
        DimensionCachedStore dimensionCachedStore = new DimensionCachedStore();
        cachedStoreMap.put(key, dimensionCachedStore);
        return dimensionCachedStore;
    }

    public static DimensionCachedStore getOrCreateStore(long modelId, long dimensionId, String memberEntityName) {
        String key = CachedImportResult.buildKey(modelId, dimensionId, memberEntityName);
        if (Objects.nonNull(cachedStoreMap.get(key))) {
            return cachedStoreMap.get(key);
        }
        DimensionCachedStore dimensionCachedStore = new DimensionCachedStore();
        cachedStoreMap.put(key, dimensionCachedStore);
        return dimensionCachedStore;
    }

    public static DimensionCachedStore getCurrentWorkStore() {
        return CacheStoreManager.getOrCreateStore(PersistentHelper.getModelId(), PersistentHelper.getDimensionId(), PersistentHelper.getEntityName());
    }

    public static String serializeStore(long modelId, long dimensionId, String memberEntityName) {
        return CacheStoreManager.getOrCreateStore(modelId, dimensionId, memberEntityName).serialize();
    }

    public static String serializeCurrentWorkStore() {
        return CacheStoreManager.getCurrentWorkStore().serialize();
    }

    public static void clearStore() {
        String key = CachedImportResult.buildKey(PersistentHelper.getModelId(), PersistentHelper.getDimensionId(), PersistentHelper.getEntityName());
        DimensionCachedStore cachedStore = cachedStoreMap.remove(key);
        if (Objects.nonNull(cachedStore)) {
            cachedStore.close();
        }
    }
}

