/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.persist;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;

public class CachedImportResult
implements Serializable {
    private long modelId;
    private long dimensionId;
    private String memberEntityId;
    private Date importBeginTime;
    final List<DynamicObject> allMembers;

    public CachedImportResult(long modelId, long dimensionId, String memberEntityId, Date importBeginTime, Collection<DynamicObject> allMembers) {
        this.modelId = modelId;
        this.dimensionId = dimensionId;
        this.memberEntityId = memberEntityId;
        this.importBeginTime = importBeginTime;
        this.allMembers = new ArrayList<DynamicObject>(allMembers);
    }

    public String serialize() {
        return SerializationUtils.serializeToBase64((Object)this);
    }

    public static CachedImportResult deserialize(String serializeStr) {
        return (CachedImportResult)SerializationUtils.deSerializeFromBase64((String)serializeStr);
    }

    public long getModelId() {
        return this.modelId;
    }

    public long getDimensionId() {
        return this.dimensionId;
    }

    public String getMemberEntityId() {
        return this.memberEntityId;
    }

    public Date getImportBeginTime() {
        return this.importBeginTime;
    }

    public Collection<DynamicObject> getAllMembers() {
        return this.allMembers;
    }

    public static String buildKey(long modelId, long dimensionId, String memberEntityName) {
        return String.format("uid: %s|modelid:%s|dimensionid:%s|entity:%s", RequestContext.getOrCreate().getUserId(), modelId, dimensionId, memberEntityName);
    }
}

