/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.persist;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.CacheStoreManager;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.DimensionCachedStore;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.IPersistent;

public class CachedStoreImpl
implements IPersistent {
    static final CachedStoreImpl instance = new CachedStoreImpl();
    private volatile Function<DynamicObject, Long> extractParentId = x -> Objects.isNull(x.get("parent")) ? null : Long.valueOf(x.get("parent") instanceof Long ? x.getLong("parent") : x.getDynamicObject("parent").getLong("id"));

    private CachedStoreImpl() {
    }

    private DimensionCachedStore getWorkCacheStore() {
        return CacheStoreManager.getOrCreateStore(ImportContextHolder.getModelId(), ImportContextHolder.getDimensionId(), ImportContextHolder.getEntityName());
    }

    @Override
    public void preInitData() {
        this.getWorkCacheStore();
    }

    @Override
    public DynamicObject getById(long id, boolean isForceRefresh) {
        return this.getWorkCacheStore().getById(id);
    }

    @Override
    public boolean existShareMember(String memberNumber, String parentNumber) {
        return !this.getMemberByParent(memberNumber, parentNumber).isEmpty();
    }

    public List<DynamicObject> listChildMembers(long parentId) {
        return this.getWorkCacheStore().listChildMembers(parentId);
    }

    @Override
    public List<DynamicObject> getMemberByParent(String memberNumber, String parentNumber) {
        return this.getWorkCacheStore().getByNumber(memberNumber, parentNumber, true);
    }

    @Override
    public Optional<DynamicObject> getMemberByParent(String memberNumber, long parentId) {
        return this.getWorkCacheStore().listByNumber(memberNumber).stream().filter(x -> Objects.equals(parentId, this.extractParentId.apply((DynamicObject)x))).findFirst();
    }

    @Override
    public List<DynamicObject> listShareMembers(String memberNumber) {
        return this.getWorkCacheStore().listByNumber(memberNumber).stream().filter(x -> ImportHelper.isShareType(x)).collect(Collectors.toList());
    }

    @Override
    public Optional<DynamicObject> getNonShareMember(String memberNumber, boolean isForceRefresh) {
        return Optional.ofNullable(this.getWorkCacheStore().getNonShareMemberByNumber(memberNumber));
    }

    @Override
    public List<DynamicObject> batchGetNonShareMember(Collection<String> memberNumbers) {
        return this.getWorkCacheStore().listByNumbers(memberNumbers).stream().filter(x -> !ImportHelper.isShareType(x)).collect(Collectors.toList());
    }

    @Override
    public List<DynamicObject> listMemberByFilter(Predicate<DynamicObject> customFilter) {
        return this.getWorkCacheStore().listAllMembers().stream().filter(customFilter).collect(Collectors.toList());
    }

    @Override
    public Collection<DynamicObject> listAllMembers(boolean isForceRefresh) {
        return this.getWorkCacheStore().listAllMembers();
    }

    @Override
    public Set<String> listAllNonShareMemberNumbers() {
        DimensionCachedStore store = this.getWorkCacheStore();
        return store.listAllNumbers().stream().map(x -> x.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
    }

    @Override
    public int getParentMaxSequence(long parentId) {
        return this.getWorkCacheStore().listChildMembers(parentId).stream().map(x -> x.getInt("dseq")).max(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Integer.compare(o1, o2);
            }
        }).orElse(-1);
    }

    @Override
    public List<DynamicObject> batchGetMembers(Collection<Long> memberIds) {
        if (CollectionUtils.isEmpty(memberIds)) {
            return Collections.EMPTY_LIST;
        }
        DimensionCachedStore store = this.getWorkCacheStore();
        return memberIds.stream().map(x -> store.getById((long)x)).collect(Collectors.toList());
    }

    @Override
    public void batchSave(List<PersistEntry> persistEntries) {
        List<DynamicObject> dys = persistEntries.stream().map(x -> x.getMemberTreeDy()).collect(Collectors.toList());
        dys.stream().forEach(x -> x.set("modifytime", (Object)new Date()));
        this.getWorkCacheStore().rebuildIndex(dys);
    }

    @Override
    public void batchSaveOrUpdate(List<DynamicObject> dynamicObjects) {
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            this.getWorkCacheStore().rebuildIndex(dynamicObjects);
        }
    }

    @Override
    public void updateParentIsLeafProp(Set<Long> parentIds) {
        if (CollectionUtils.isEmpty(parentIds)) {
            return;
        }
        this.batchGetMembers(parentIds).forEach(x -> x.set("isleaf", (Object)false));
    }

    @Override
    public void batchUpdateMemberProp(Set<Long> memberIds, String propName, Object propValue) {
        if (CollectionUtils.isEmpty(memberIds)) {
            return;
        }
        memberIds.stream().map(x -> this.getWorkCacheStore().getById((long)x)).filter(x -> Objects.nonNull(x)).forEach(x -> x.set(propName, propValue));
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ids.stream().forEach(x -> this.getWorkCacheStore().deleteById((long)x));
    }
}

