/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.persist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.IPersistent;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistentHelper;

public class DBStoreImpl
implements IPersistent {
    protected static final Log LOG = LogFactory.getLog(DBStoreImpl.class);
    static final DBStoreImpl instance = new DBStoreImpl();

    private DBStoreImpl() {
    }

    @Override
    public void preInitData() {
        ImportContextHolder.getOrCreateBatchDbCacheInstance();
    }

    @Override
    public DynamicObject getById(long id, boolean isForceRefresh) {
        if (isForceRefresh) {
            return BusinessDataServiceHelper.loadSingle((String)PersistentHelper.getEntityName(), (String)PersistentHelper.selectFields(), (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        }
        Optional<DynamicObject> value = ImportContextHolder.getOrCreateBatchDbCacheInstance().getByIdFromCache(id);
        return value.isPresent() ? value.get() : null;
    }

    @Override
    @Deprecated
    public boolean existShareMember(String memberNumber, String parentNumber) {
        return !this.getMemberByParent(memberNumber, parentNumber).isEmpty();
    }

    @Override
    public List<DynamicObject> getMemberByParent(String memberNumber, String parentNumber) {
        ArrayList<DynamicObject> matchedDys = new ArrayList<DynamicObject>(16);
        matchedDys.addAll(ImportContextHolder.getOrCreateBatchDbCacheInstance().getByNumberFromCache(memberNumber));
        matchedDys.retainAll(ImportContextHolder.getOrCreateBatchDbCacheInstance().getByParentNumberFromCache(parentNumber));
        return matchedDys.stream().filter(x -> StorageTypeEnum.SHARE.index.equals(x.getString("storagetype"))).collect(Collectors.toList());
    }

    @Override
    public List<DynamicObject> listShareMembers(String memberNumber) {
        Collection<DynamicObject> matchedDys = ImportContextHolder.getOrCreateBatchDbCacheInstance().getByNumberFromCache(memberNumber);
        return matchedDys.stream().filter(x -> ImportHelper.isShareType(x)).collect(Collectors.toList());
    }

    @Override
    public Optional<DynamicObject> getMemberByParent(String memberNumber, long parentId) {
        HashSet<DynamicObject> matchedDys = new HashSet<DynamicObject>(16);
        matchedDys.addAll(ImportContextHolder.getOrCreateBatchDbCacheInstance().getByNumberFromCache(memberNumber));
        matchedDys.retainAll(ImportContextHolder.getOrCreateBatchDbCacheInstance().getByParentIdFromCache(parentId));
        this.checkMemberUnique(matchedDys);
        return matchedDys.stream().findFirst();
    }

    @Override
    public Collection<DynamicObject> listChildMembers(long parentId) {
        return ImportContextHolder.getOrCreateBatchDbCacheInstance().getByParentIdFromCache(parentId);
    }

    @Override
    public Optional<DynamicObject> getNonShareMember(String memberNumber, boolean isForceRefresh) {
        if (isForceRefresh) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("dimension.id", "=", (Object)PersistentHelper.getDimensionId());
            qfBuilder.add("model.id", "=", (Object)PersistentHelper.getModelId());
            qfBuilder.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
            qfBuilder.add("number", "=", (Object)memberNumber);
            return Optional.ofNullable(BusinessDataServiceHelper.loadSingle((String)PersistentHelper.getEntityName(), (String)PersistentHelper.selectFields(), (QFilter[])qfBuilder.toArray()));
        }
        ArrayList<DynamicObject> matchedDys = new ArrayList<DynamicObject>(16);
        matchedDys.addAll(ImportContextHolder.getOrCreateBatchDbCacheInstance().getByNumberFromCache(memberNumber));
        List<DynamicObject> nonShareMembers = matchedDys.stream().filter(x -> !StorageTypeEnum.SHARE.index.equals(x.getString("storagetype"))).collect(Collectors.toList());
        this.checkMemberUnique(nonShareMembers);
        return nonShareMembers.stream().findFirst();
    }

    private void checkMemberUnique(Collection<DynamicObject> members) {
        if (!CollectionUtils.isEmpty(members) && members.size() > 1) {
            String memberNumber = members.iterator().next().getString("number");
            throw new KDBizException(DimensionImportContext.ERROR_DIRTY_DATA, new Object[]{memberNumber, members.size()});
        }
    }

    @Override
    public List<DynamicObject> batchGetNonShareMember(Collection<String> memberNumbers) {
        if (Objects.isNull(memberNumbers)) {
            memberNumbers = Collections.EMPTY_LIST;
        }
        ArrayList matchedDys = new ArrayList(memberNumbers.size());
        memberNumbers.stream().forEach(x -> matchedDys.addAll(ImportContextHolder.getOrCreateBatchDbCacheInstance().getByNumberFromCache((String)x)));
        return matchedDys.stream().filter(x -> !StorageTypeEnum.SHARE.index.equals(x.getString("storagetype"))).collect(Collectors.toList());
    }

    @Override
    public Set<String> listAllNonShareMemberNumbers() {
        return ImportContextHolder.getOrCreateBatchDbCacheInstance().getAllNumbers();
    }

    @Override
    public Collection<DynamicObject> listAllMembers(boolean isForceRefresh) {
        if (isForceRefresh) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("dimension.id", "=", (Object)PersistentHelper.getDimensionId());
            qfBuilder.add("model.id", "=", (Object)PersistentHelper.getModelId());
            return Arrays.asList(BusinessDataServiceHelper.load((String)PersistentHelper.getEntityName(), (String)PersistentHelper.selectFields(), (QFilter[])qfBuilder.toArray()));
        }
        return ImportContextHolder.getOrCreateBatchDbCacheInstance().getAllFromCache();
    }

    @Override
    public List<DynamicObject> listMemberByFilter(Predicate<DynamicObject> customFilter) {
        return this.listAllMembers(false).stream().filter(customFilter).collect(Collectors.toList());
    }

    @Override
    public int getParentMaxSequence(long parentId) {
        Collection child = ImportContextHolder.getOrCreateBatchDbCacheInstance().getByParentIdFromCache(parentId);
        if ("bcm_entitymembertree".equals(ImportContextHolder.getEntityName())) {
            child = child.stream().filter(x -> !Objects.equals(10000, x.getInt("dseq"))).collect(Collectors.toList());
        }
        if (!child.isEmpty()) {
            return child.stream().map(x -> x.getInt("dseq")).max(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o1.compareTo(o2);
                }
            }).get();
        }
        return -1;
    }

    @Override
    public List<DynamicObject> batchGetMembers(Collection<Long> memberIds) {
        if (Objects.isNull(memberIds)) {
            memberIds = Collections.EMPTY_LIST;
        }
        return memberIds.stream().map(x -> ImportContextHolder.getOrCreateBatchDbCacheInstance().getByIdFromCache((Long)x)).filter(x -> x.isPresent()).map(x -> (DynamicObject)x.get()).collect(Collectors.toList());
    }

    @Override
    public void batchSave(List<PersistEntry> persistEntries) {
        DynamicObjectType memberObjectType = persistEntries.get(0).getMemberDy().getDynamicObjectType();
        BusinessDataWriter.save((IDataEntityType)memberObjectType, (Object[])persistEntries.stream().map(x -> x.getMemberDy()).collect(Collectors.toList()).toArray(new DynamicObject[0]));
        this.batchSaveWithUpdateCache(persistEntries.stream().map(x -> x.getMemberTreeDy()).collect(Collectors.toList()).toArray(new DynamicObject[0]));
    }

    @Override
    public void batchSaveOrUpdate(List<DynamicObject> dynamicObjects) {
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            this.batchSaveWithUpdateCache(dynamicObjects.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public void updateParentIsLeafProp(Set<Long> parentIds) {
        DynamicObject[] parentDys;
        if (CollectionUtils.isEmpty(parentIds)) {
            return;
        }
        for (DynamicObject dy : parentDys = BusinessDataServiceHelper.load((String)ImportContextHolder.getEntityName(), (String)"id,isleaf", (QFilter[])new QFilter("id", "in", new ArrayList<Long>(parentIds)).toArray())) {
            dy.set("isleaf", (Object)false);
        }
        this.batchSaveWithUpdateCache(parentDys);
    }

    @Override
    public void batchUpdateMemberProp(Set<Long> memberIds, String propName, Object propValue) {
        DynamicObject[] parentDys;
        if (CollectionUtils.isEmpty(memberIds)) {
            return;
        }
        for (DynamicObject dy : parentDys = BusinessDataServiceHelper.load((String)ImportContextHolder.getEntityName(), (String)("id," + propName), (QFilter[])new QFilter("id", "in", new ArrayList<Long>(memberIds)).toArray())) {
            dy.set(propName, propValue);
        }
        this.batchSaveWithUpdateCache(parentDys);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ImportContextHolder.getEntityName()), (Object[])ids.toArray(new Long[0]));
        ImportContextHolder.getOrCreateBatchDbCacheInstance().deleteMember(ids);
    }

    private void batchSaveWithUpdateCache(DynamicObject[] members) {
        if (Objects.nonNull(members) && members.length > 0) {
            DynamicObjectType objectType = members[0].getDynamicObjectType();
            int batchSize = 999;
            if (members.length < batchSize) {
                BusinessDataWriter.save((IDataEntityType)objectType, (Object[])members);
            } else {
                ArrayList<DynamicObject> batch = new ArrayList<DynamicObject>(batchSize);
                for (int i = 0; i < members.length; ++i) {
                    batch.add(members[i]);
                    if (batch.size() < batchSize) continue;
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
                if (!batch.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
            }
        }
    }

    private String genLogPrefix(String operationName) {
        return String.format("dimension_import:: entity: %s, operate: %s, ", ImportContextHolder.getEntityName(), operationName);
    }
}

