/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.persist;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.CachedImportResult;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistentHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.lang3.ArrayUtils;

class DimensionCachedStore
implements AutoCloseable {
    private Map<Long, DynamicObject> idIndex = new TreeMap<Long, DynamicObject>();
    private Multimap<String, DynamicObject> numberIndex = LinkedListMultimap.create();
    private Map<Long, Map<Long, DynamicObject>> parentIdIndex = new HashMap<Long, Map<Long, DynamicObject>>(8);

    public DimensionCachedStore() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("dimension.id", "=", (Object)PersistentHelper.getDimensionId());
        qfBuilder.add("model.id", "=", (Object)PersistentHelper.getModelId());
        Object[] existingData = BusinessDataServiceHelper.load((String)PersistentHelper.getEntityName(), (String)PersistentHelper.selectFields(), (QFilter[])qfBuilder.toArray());
        if (ArrayUtils.isNotEmpty((Object[])existingData)) {
            this.rebuildIndex(Arrays.asList(existingData));
        }
    }

    public DimensionCachedStore(String serializeStr) {
        Collection members = (Collection)SerializationUtils.deSerializeFromBase64((String)serializeStr);
        this.rebuildIndex(members);
    }

    public final void rebuildIndex(Collection<DynamicObject> members) {
        members.stream().forEach(x -> {
            boolean expression;
            Long id = x.getLong("id");
            boolean bl = expression = Objects.nonNull(id) && id > 0L;
            if (!expression) {
                throw new IllegalArgumentException("member id is null or id is 0");
            }
            String number = ImportHelper.getNumber(x);
            if (StringUtils.isEmpty((CharSequence)number)) {
                throw new IllegalArgumentException("member number is null or empty");
            }
            this.idIndex.put(id, (DynamicObject)x);
            Collection serials = this.numberIndex.get((Object)number);
            serials.removeIf(y -> Objects.equals(id, y.getLong("id")));
            this.numberIndex.put((Object)number, x);
            long parentId = ImportHelper.getBaseDataIdCompatible(x, "parent");
            if (Objects.isNull(this.parentIdIndex.get(parentId))) {
                this.parentIdIndex.put(parentId, Collections.synchronizedMap(new HashMap(4)));
            }
            this.parentIdIndex.get(parentId).remove(id);
            this.parentIdIndex.get(parentId).put(id, (DynamicObject)x);
        });
    }

    public String serialize() {
        return new CachedImportResult(PersistentHelper.getModelId(), PersistentHelper.getDimensionId(), PersistentHelper.getEntityName(), ImportContextHolder.getImportBeginTime(), this.idIndex.values()).serialize();
    }

    public DynamicObject getById(long id) {
        return this.idIndex.get(id);
    }

    public DynamicObjectCollection getByNumber(String number) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        result.addAll(this.numberIndex.get((Object)number));
        return result;
    }

    public List<DynamicObject> getByNumber(String number, String parentNumber, Boolean isShare) {
        Collection serials = this.numberIndex.get((Object)number);
        if (CollectionUtils.isEmpty((Collection)serials)) {
            return Collections.EMPTY_LIST;
        }
        return serials.stream().filter(x -> {
            DynamicObject parent = null;
            parent = x.get("parent") instanceof DynamicObject ? x.getDynamicObject("parent") : this.getById(x.getLong("parent"));
            return StringUtil.equals((String)parentNumber, (String)ImportHelper.getNumber(parent)) && Objects.nonNull(isShare) && isShare.equals(ImportHelper.isShareType(x));
        }).collect(Collectors.toList());
    }

    public DynamicObject getNonShareMemberByNumber(String number) {
        Collection serials = this.numberIndex.get((Object)number);
        if (CollectionUtils.isEmpty((Collection)serials)) {
            return null;
        }
        return serials.stream().filter(x -> !ImportHelper.isShareType(x)).findFirst().orElseGet(() -> null);
    }

    public Collection<DynamicObject> listByNumber(String number) {
        if (Objects.isNull(this.numberIndex.get((Object)number))) {
            return Collections.EMPTY_LIST;
        }
        return this.numberIndex.get((Object)number);
    }

    public Collection<DynamicObject> listByNumbers(Collection<String> numbers) {
        if (CollectionUtils.isEmpty(numbers)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        numbers.stream().forEach(x -> result.addAll(this.numberIndex.get(x)));
        return result;
    }

    public void deleteById(long id) {
        DynamicObject existing = this.idIndex.get(id);
        if (Objects.nonNull(existing)) {
            this.idIndex.remove(id);
            this.numberIndex.get((Object)ImportHelper.getNumber(existing)).removeIf(x -> Long.valueOf(id).equals(x.getLong("id")));
        }
    }

    public Collection<DynamicObject> listAllMembers() {
        return this.idIndex.values();
    }

    public List<DynamicObject> listChildMembers(long parentId) {
        Map<Long, DynamicObject> child = this.parentIdIndex.get(parentId);
        if (Objects.isNull(child)) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<DynamicObject>(child.values());
    }

    public Set<String> listAllNumbers() {
        return this.numberIndex.keySet();
    }

    @Override
    public void close() {
        this.idIndex.clear();
        this.numberIndex.clear();
        this.parentIdIndex.clear();
    }
}

