/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.persist;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.upgrade.DimensionNode;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.CachedStoreImpl;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.DBStoreImpl;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.IPersistent;
import org.apache.commons.lang3.StringUtils;

public class PersistProxy
implements IPersistent {
    private static final Log LOG = LogFactory.getLog(PersistProxy.class);
    public static final String KEY_MODIFYTIME = "modifytime";
    public static final PersistProxy instance = new PersistProxy();

    private PersistProxy() {
    }

    private IPersistent route() {
        return ImportContextHolder.isDryRun() ? CachedStoreImpl.instance : DBStoreImpl.instance;
    }

    @Override
    public void preInitData() {
        this.route().preInitData();
    }

    @Override
    public DynamicObject getById(long id, boolean isForceRefresh) {
        return this.route().getById(id, isForceRefresh);
    }

    @Override
    @Deprecated
    public boolean existShareMember(String memberNumber, String parentNumber) {
        return this.route().existShareMember(memberNumber, parentNumber);
    }

    @Override
    public List<DynamicObject> getMemberByParent(String memberNumber, String parentNumber) {
        return this.route().getMemberByParent(memberNumber, parentNumber);
    }

    @Override
    public List<DynamicObject> listShareMembers(String memberNumber) {
        return this.route().listShareMembers(memberNumber);
    }

    public Optional<DynamicObject> getEditableShareMember(String memberNumber, String parentNumber, String longNumber) {
        List<DynamicObject> members = this.route().getMemberByParent(memberNumber, parentNumber);
        List shareMembers = members.stream().filter(x -> {
            if (StringUtils.isNotEmpty((CharSequence)longNumber) && !x.getString("longnumber").equals(longNumber)) {
                return false;
            }
            Long parentId = ImportHelper.getBaseDataIdCompatible(x, "parent.id");
            if (Objects.isNull(parentId)) {
                return false;
            }
            DynamicObject parent = instance.getById(parentId, false);
            if (Objects.isNull(parent)) {
                return false;
            }
            return !ImportHelper.isShareType(parent) && !StorageTypeEnum.UNSHARE.index.equals(parent.getString("storagetype"));
        }).collect(Collectors.toList());
        if (shareMembers.size() > 1) {
            throw new KDBizException(DimensionImportContext.ERROR_DIRTY_DATA, new Object[]{memberNumber, shareMembers.size()});
        }
        return shareMembers.stream().findFirst();
    }

    @Override
    public Optional<DynamicObject> getMemberByParent(String memberNumber, long parentId) {
        return this.route().getMemberByParent(memberNumber, parentId);
    }

    @Override
    public Collection<DynamicObject> listChildMembers(long parentId) {
        return this.route().listChildMembers(parentId);
    }

    @Override
    public Optional<DynamicObject> getNonShareMember(String memberNumber, boolean isForceRefresh) {
        return this.route().getNonShareMember(memberNumber, isForceRefresh);
    }

    @Override
    public Collection<DynamicObject> listAllMembers(boolean isForceRefresh) {
        return this.route().listAllMembers(isForceRefresh);
    }

    @Override
    public List<DynamicObject> batchGetNonShareMember(Collection<String> memberNumbers) {
        return this.route().batchGetNonShareMember(memberNumbers);
    }

    @Override
    public List<DynamicObject> listMemberByFilter(Predicate<DynamicObject> customFilter) {
        return this.route().listMemberByFilter(customFilter);
    }

    @Override
    public Set<String> listAllNonShareMemberNumbers() {
        return this.route().listAllNonShareMemberNumbers();
    }

    @Override
    public int getParentMaxSequence(long parentId) {
        return this.route().getParentMaxSequence(parentId);
    }

    @Override
    public List<DynamicObject> batchGetMembers(Collection<Long> memberIds) {
        return this.route().batchGetMembers(memberIds);
    }

    @Override
    public void batchSave(List<PersistEntry> persistEntries) {
        this.route().batchSave(persistEntries);
    }

    @Override
    public void batchSaveOrUpdate(List<DynamicObject> dynamicObjects) {
        dynamicObjects.stream().forEach(x -> x.set(KEY_MODIFYTIME, (Object)new Date()));
        ImportContextHolder.addBatchOverrideMemberIds(dynamicObjects.stream().map(x -> x.getLong("id")).collect(Collectors.toList()));
        this.route().batchSaveOrUpdate(dynamicObjects);
    }

    @Override
    public void updateParentIsLeafProp(Set<Long> parentIds) {
        this.route().updateParentIsLeafProp(parentIds);
    }

    @Override
    public void batchUpdateMemberProp(Set<Long> memberIds, String propName, Object propValue) {
        this.route().batchUpdateMemberProp(memberIds, propName, propValue);
    }

    public void syncMemberNodeIsLeaf() {
        long bTick = System.currentTimeMillis();
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            Collection<DynamicObject> allMembers = this.route().listAllMembers(true);
            if (allMembers.isEmpty()) {
                return;
            }
            try {
                DimensionTree originMemberTree = DimensionNode.createDimTreeWithShareRef((DynamicObject[])allMembers.toArray(new DynamicObject[0]));
                HashSet<Long> nonLeafIds = new HashSet<Long>(allMembers.size() / 3);
                HashSet<Long> leafIds = new HashSet<Long>(allMembers.size() / 3 * 2);
                originMemberTree.dfsPreOrder(x -> {
                    if (CollectionUtils.isEmpty((Collection)x.getChildren())) {
                        leafIds.add(((DimensionNode)x.getData()).getId());
                    } else {
                        nonLeafIds.add(((DimensionNode)x.getData()).getId());
                    }
                });
                this.route().batchUpdateMemberProp(nonLeafIds, "isleaf", false);
                this.route().batchUpdateMemberProp(leafIds, "isleaf", true);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        LOG.info("dimension_import:: sync member is leaf cost time: " + (System.currentTimeMillis() - bTick));
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        this.route().deleteByIds(ids);
    }
}

