/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.plugins;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.upgrade.DimNodeType;
import kd.fi.bcm.business.upgrade.DimensionNode;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.ArrayUtils;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.CachedImportResult;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistentHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.plugins.fieldsetting.AbstractDiffShowModel;
import kd.fi.bcm.formplugin.dimension.batchimp.plugins.fieldsetting.AccountDiffShowModel;
import kd.fi.bcm.formplugin.dimension.batchimp.plugins.fieldsetting.AuditTrialDiffShowModel;
import kd.fi.bcm.formplugin.dimension.batchimp.plugins.fieldsetting.ChangeTypeDiffShowModel;
import kd.fi.bcm.formplugin.dimension.batchimp.plugins.fieldsetting.ExtendsDiffShowModel;
import kd.fi.bcm.formplugin.dimension.batchimp.plugins.fieldsetting.ICODiffShowModel;
import kd.fi.bcm.formplugin.dimension.batchimp.plugins.fieldsetting.OrgDiffShowModel;
import kd.fi.bcm.formplugin.dimension.batchimp.plugins.fieldsetting.UserDefinedDiffShowModel;

public class ImportDiffPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(ImportDiffPlugin.class);
    protected static final String KEY_TREE = "treeentryentity";
    private static final String KEY_BTN_VIEW_RESULT = "btnresult";
    private static final String KEY_BTN_CONFIRM = "btnconfirm";
    private static final String KEY_FULL_HIRARCH = "btnshowfull";
    protected Map<String, Boolean> fieldHasChangedMap = new HashMap<String, Boolean>(16);
    private volatile Predicate<DimensionTree<String, DimensionNode>> isTreeNodeChanged = x -> Objects.equals(1, ((DimensionNode)x.getData()).getPropExtend("issumchange"));
    private volatile Consumer<DimensionTree<String, DimensionNode>> setNodePath = x -> {
        if (Objects.isNull(x.getParent())) {
            ((DimensionNode)x.getData()).setPropExtend("_nodepath", (Object)("$" + ((DimensionNode)x.getData()).getNumber()));
        } else {
            ((DimensionNode)x.getData()).setPropExtend("_nodepath", (Object)String.join((CharSequence)".", (String)((DimensionNode)x.getParent().getData()).getPropExtend("_nodepath"), ((DimensionNode)x.getData()).getNumber()));
        }
    };
    private volatile Function<DimensionTree<String, DimensionNode>, String> getNodePath = x -> (String)((DimensionNode)x.getData()).getPropExtend("_nodepath");
    private static final String sameFieldString = "number, name,longnumber,storagetype,dpropertyid1, dpropertyid2,dpropertyid3,dpropertyid4,dpropertyid5,dpropertyid6,dpropertyid7,dpropertyid8,dpropertyid9,dpropertyid10";
    private static final String EntitySelectField = "number, name,longnumber,storagetype,dpropertyid1, dpropertyid2,dpropertyid3,dpropertyid4,dpropertyid5,dpropertyid6,dpropertyid7,dpropertyid8,dpropertyid9,dpropertyid10,diffstatus, ctrlorg, currency,isinnerorg, aggoprt,isouterorg,isindependentorg,isclearorg,description, parent,orgcode, bizchangerds,namechangerds,currencychangerds,bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate,namechangerds.namerds,namechangerds.nameeffdate,namechangerds.nameexpdate";
    private static final String AccountSelectField = "number, name,longnumber,storagetype,dpropertyid1, dpropertyid2,dpropertyid3,dpropertyid4,dpropertyid5,dpropertyid6,dpropertyid7,dpropertyid8,dpropertyid9,dpropertyid10,diffstatus";
    private static final String AuditTrailSelectField = "number, name,longnumber,storagetype,dpropertyid1, dpropertyid2,dpropertyid3,dpropertyid4,dpropertyid5,dpropertyid6,dpropertyid7,dpropertyid8,dpropertyid9,dpropertyid10,diffstatus";
    private static final String ChangeTypeSelectField = "number, name,longnumber,storagetype,dpropertyid1, dpropertyid2,dpropertyid3,dpropertyid4,dpropertyid5,dpropertyid6,dpropertyid7,dpropertyid8,dpropertyid9,dpropertyid10,diffstatus";
    private static final String UserDefinedSelectField = "number, name,longnumber,storagetype,dpropertyid1, dpropertyid2,dpropertyid3,dpropertyid4,dpropertyid5,dpropertyid6,dpropertyid7,dpropertyid8,dpropertyid9,dpropertyid10,diffstatus";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String controlKey = e.getProperty().getName();
        if (KEY_FULL_HIRARCH.equals(controlKey) || "importStatus".equalsIgnoreCase(controlKey)) {
            this.showTree((Boolean)this.getModel().getValue(KEY_FULL_HIRARCH), (String)this.getModel().getValue("importStatus"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String eventKey = evt.getItemKey();
        if (KEY_BTN_VIEW_RESULT.equalsIgnoreCase(eventKey)) {
            String pkId = this.getView().getParentView().getPageCache().get("IMPORT_PROGRESS_ID");
            if (Objects.isNull(pkId)) {
                String time = (String)this.getView().getFormShowParameter().getCustomParam("time");
                if (time == null) {
                    time = (String)AppCacheServiceHelper.get((String)"view_import_time");
                }
                String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
                String logLookKey = "dim_import_ret1_log" + RequestContext.get().getUserId() + dimensionId + time;
                Object pk = AppCacheServiceHelper.get((String)logLookKey);
                if (pk != null) {
                    pkId = String.valueOf(pk);
                }
            }
            if (Objects.isNull(pkId)) {
                this.getView().showErrorNotification(ImportMsgUtils.cacheResultExpired().getMessage());
                evt.setCancel(true);
                return;
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("bos_importlog");
            parameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
            parameter.setParentPageId(this.getView().getFormShowParameter().getPageId());
            parameter.setPkId((Object)pkId);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (KEY_BTN_CONFIRM.equals(eventKey)) {
            String dryRunParams = this.getView().getParentView().getPageCache().get("dryRun_import_parms");
            if (Objects.isNull(dryRunParams)) {
                String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
                String time = (String)this.getView().getFormShowParameter().getCustomParam("time");
                Object dryRunParamObject = AppCacheServiceHelper.get((String)("dryRun_import_parms" + RequestContext.get().getUserId() + dimensionId + time + "dryRumParams"));
                if (dryRunParamObject != null) {
                    dryRunParams = (String)dryRunParamObject;
                }
            }
            if (Objects.isNull(dryRunParams)) {
                this.getView().showErrorNotification(ImportMsgUtils.cacheResultExpired().getMessage());
                evt.setCancel(true);
                return;
            }
            FormShowParameter dryRunFormParams = (FormShowParameter)SerializationUtils.deSerializeFromBase64((String)dryRunParams);
            dryRunFormParams.setFormId("bcm_batch_bos_importing");
            dryRunFormParams.getOpenStyle().setShowType(ShowType.Modal);
            dryRunFormParams.getCustomParams().put("IsDryRunPattern", false);
            dryRunFormParams.setParentFormId(this.getView().getFormShowParameter().getFormId());
            dryRunFormParams.setParentPageId(this.getView().getFormShowParameter().getPageId());
            this.getView().showForm(dryRunFormParams);
        } else if ("baritemrefresh".equals(eventKey)) {
            this.showTree((Boolean)this.getModel().getValue(KEY_FULL_HIRARCH), (String)this.getModel().getValue("importStatus"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String dryRunParams;
        super.afterCreateNewData(e);
        String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        String time = (String)this.getView().getFormShowParameter().getCustomParam("time");
        if (time == null) {
            time = (String)AppCacheServiceHelper.get((String)"view_import_time");
        }
        if (StringUtils.isNotEmpty((CharSequence)(dryRunParams = this.getView().getParentView().getPageCache().get("dryRun_import_parms")))) {
            AppCacheServiceHelper.put((String)("dryRun_import_parms" + RequestContext.get().getUserId() + dimensionId + time + "dryRumParams"), (Object)dryRunParams);
        }
        String cachedImportResultStr = (String)AppCacheServiceHelper.get((String)("dim_import_ret1" + RequestContext.get().getUserId() + dimensionId + time + "content"));
        LOG.info("cache key\uff1a{}", (Object)("dim_import_ret1" + RequestContext.get().getUserId() + dimensionId + time + "content"));
        if (Objects.isNull(cachedImportResultStr)) {
            this.getView().showErrorNotification(ImportMsgUtils.cacheResultExpired().getMessage());
            return;
        }
        this.getModel().setValue("importStatus", (Object)"all");
        this.showTree((Boolean)this.getModel().getValue(KEY_FULL_HIRARCH), "all");
    }

    private void showTree(boolean isShowFull, String importStatus) {
        List circleNodes;
        String cachedImportResultStr;
        String dimensionId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        String time = (String)this.getView().getFormShowParameter().getCustomParam("time");
        if (Objects.isNull(time)) {
            time = (String)AppCacheServiceHelper.get((String)"view_import_time");
        }
        if (StringUtils.isEmpty((CharSequence)(cachedImportResultStr = (String)AppCacheServiceHelper.get((String)("dim_import_ret1" + RequestContext.get().getUserId() + dimensionId + time + "content"))))) {
            this.getView().showErrorNotification(ImportMsgUtils.cacheResultExpired().getMessage());
            return;
        }
        CachedImportResult cachedImportResult = CachedImportResult.deserialize(cachedImportResultStr);
        Label title = (Label)this.getControl("labelmodel");
        title.setText(QueryServiceHelper.queryOne((String)"bcm_model", (String)"name", (QFilter[])new QFilter("id", "=", (Object)cachedImportResult.getModelId()).toArray()).getString("name"));
        if (!"bcm_structofextend".equals(this.getView().getFormShowParameter().getCustomParam("entityName")) && !(circleNodes = DimensionNode.checkDimTreeCircleWithPath((DynamicObject[])cachedImportResult.getAllMembers().toArray(new DynamicObject[0]))).isEmpty()) {
            this.getView().showErrorNotification(ImportMsgUtils.failedPreviewImportMsg());
            return;
        }
        this.getModel().setValue("model", (Object)cachedImportResult.getModelId());
        Map<Long, DynamicObject> originMemMap = this.queryDBData(cachedImportResult.getMemberEntityId(), cachedImportResult.getModelId(), cachedImportResult.getDimensionId());
        DimensionTree<String, DimensionNode> diffTree = this.buildMemberDiffTree(originMemMap.values(), cachedImportResult.getAllMembers(), cachedImportResult.getMemberEntityId(), isShowFull, x -> Objects.nonNull(x) && Objects.nonNull(x.getDate("modifytime")) && x.getDate("modifytime").compareTo(cachedImportResult.getImportBeginTime()) > 0, importStatus);
        AbstractDiffShowModel diffShowModel = this.getShowDiffModel(cachedImportResult.getMemberEntityId(), cachedImportResult.getModelId(), Long.parseLong(dimensionId), time);
        if (diffShowModel == null) {
            return;
        }
        if (diffTree != null) {
            if (!importStatus.equalsIgnoreCase("all")) {
                this.recursiveFilterNode(diffTree, importStatus);
            }
            this.buildTreeBillComponent(cachedImportResult.getMemberEntityId(), diffTree, null, diffShowModel);
        }
        this.getView().updateView(KEY_TREE);
        ((TreeEntryGrid)this.getControl(KEY_TREE)).setCollapse(false);
    }

    private AbstractDiffShowModel getShowDiffModel(String memberEntityId, long modelId, long dimensionId, String time) {
        switch (memberEntityId) {
            case "bcm_entitymembertree": {
                return new OrgDiffShowModel(modelId, dimensionId, memberEntityId, time);
            }
            case "bcm_accountmembertree": {
                return new AccountDiffShowModel(modelId, dimensionId, memberEntityId, time);
            }
            case "bcm_audittrialmembertree": {
                return new AuditTrialDiffShowModel(modelId, dimensionId, memberEntityId, time);
            }
            case "bcm_changetypemembertree": {
                return new ChangeTypeDiffShowModel(modelId, dimensionId, memberEntityId, time);
            }
            case "bcm_userdefinedmembertree": {
                return new UserDefinedDiffShowModel(modelId, dimensionId, memberEntityId, time);
            }
            case "bcm_icmembertree": {
                return new ICODiffShowModel(modelId, dimensionId, memberEntityId, time);
            }
            case "bcm_structofextend": {
                return new ExtendsDiffShowModel(modelId, dimensionId, memberEntityId, time);
            }
        }
        return null;
    }

    private DimensionTree<String, DimensionNode> buildMemberDiffTree(Collection<DynamicObject> originMembers, Collection<DynamicObject> afterImportedMembers, String memberEntityId, boolean isShowFull, Predicate<DynamicObject> checkMemberOverride, String importStatus) {
        if (CollectionUtils.isEmpty(originMembers)) {
            return null;
        }
        DimensionTree originMemberTree = DimensionNode.createDimTreeWithShareRef((DynamicObject[])originMembers.toArray(new DynamicObject[0]));
        originMemberTree.dfsPreOrder(this.setNodePath);
        DimensionTree updatedMemberTree = DimensionNode.createDimTreeWithShareRef((DynamicObject[])afterImportedMembers.toArray(new DynamicObject[0]));
        updatedMemberTree.dfsPreOrder(this.setNodePath);
        HashMap pathOriginNodeIndex = new HashMap(originMembers.size());
        originMemberTree.dfsPreOrder(x -> pathOriginNodeIndex.put(this.getNodePath.apply((DimensionTree<String, DimensionNode>)x), x));
        HashMap idOriginNodeIndex = new HashMap(originMembers.size());
        originMemberTree.dfsPreOrder(x -> idOriginNodeIndex.put(((DimensionNode)x.getData()).getId(), x));
        updatedMemberTree.dfsPostTravel(treeNode -> {
            long curNodeId = ((DimensionNode)treeNode.getData()).getId();
            String curNodePath = this.getNodePath.apply((DimensionTree<String, DimensionNode>)treeNode);
            boolean isShareType = ImportHelper.isShareType(((DimensionNode)treeNode.getData()).getStorageType());
            ImportDiffPlugin.setDiffStatusFlag((DimensionTree<String, DimensionNode>)treeNode, DiffStatus.none);
            if (idOriginNodeIndex.containsKey(curNodeId)) {
                if (Objects.equals(idOriginNodeIndex.get(curNodeId), pathOriginNodeIndex.get(curNodePath))) {
                    if (checkMemberOverride.test(isShareType ? ((DimensionNode)treeNode.getData()).getShareDyn() : ((DimensionNode)treeNode.getData()).getDyn())) {
                        ImportDiffPlugin.setDiffStatusFlag((DimensionTree<String, DimensionNode>)treeNode, DiffStatus.override);
                    }
                } else if (isShareType) {
                    treeNode.dfsPreOrder(y -> ImportDiffPlugin.setDiffStatusFlag((DimensionTree<String, DimensionNode>)y, DiffStatus.newshare));
                } else {
                    ImportDiffPlugin.setDiffStatusFlag((DimensionTree<String, DimensionNode>)treeNode, DiffStatus.newstore);
                }
            } else if (DimNodeType.SHARE_V != ((DimensionNode)treeNode.getData()).getNodeType()) {
                if (isShareType) {
                    treeNode.dfsPreOrder(y -> ImportDiffPlugin.setDiffStatusFlag((DimensionTree<String, DimensionNode>)y, DiffStatus.newshare));
                } else {
                    ImportDiffPlugin.setDiffStatusFlag((DimensionTree<String, DimensionNode>)treeNode, DiffStatus.newstore);
                }
            }
        });
        HashMap pathUpdatedNodeIndex = new HashMap(updatedMemberTree.count());
        updatedMemberTree.dfsPreOrder(x -> pathUpdatedNodeIndex.put(this.getNodePath.apply((DimensionTree<String, DimensionNode>)x), x));
        originMemberTree.dfsPreOrder(treeNode -> {
            String curNodePath = this.getNodePath.apply((DimensionTree<String, DimensionNode>)treeNode);
            if (Objects.isNull(treeNode.getParent()) || pathUpdatedNodeIndex.containsKey(curNodePath)) {
                return;
            }
            if (DiffStatus.deleted.code.equals(ImportDiffPlugin.getDiffStatusFlag((DimensionTree<String, DimensionNode>)treeNode))) {
                return;
            }
            treeNode.dfsPreOrder(x -> {
                ImportDiffPlugin.setDiffStatusFlag((DimensionTree<String, DimensionNode>)x, DiffStatus.deleted);
                ((DimensionNode)x.getData()).setId(GlobalIdUtil.genGlobalLongId());
                ((DimensionNode)x.getData()).setParent(((DimensionNode)x.getParent().getData()).getId());
            });
            String parentNodePath = this.getNodePath.apply((DimensionTree<String, DimensionNode>)treeNode.getParent());
            Preconditions.checkState((boolean)pathUpdatedNodeIndex.containsKey(parentNodePath), (Object)"logic error: the parent path does not exist on updated tree. ");
            DimensionTree updatedParentNode = (DimensionTree)pathUpdatedNodeIndex.get(parentNodePath);
            if (CollectionUtils.isEmpty((Collection)updatedParentNode.getChildren())) {
                updatedParentNode.setChildren(new ArrayList(8));
            }
            updatedParentNode.getChildren().add(treeNode);
            treeNode.setParent(updatedParentNode);
        });
        updatedMemberTree.dfsPostTravel(treeNode -> {
            ((DimensionNode)treeNode.getData()).setPropExtend("issumchange", (Object)(DiffStatus.none.code.equals(((DimensionNode)treeNode.getData()).getPropExtend("diffstatus")) ? 0 : 1));
            if (this.isTreeNodeChanged.negate().test((DimensionTree<String, DimensionNode>)treeNode) && !CollectionUtils.isEmpty((Collection)treeNode.getChildren()) && treeNode.getChildren().stream().anyMatch(this.isTreeNodeChanged)) {
                ((DimensionNode)treeNode.getData()).setPropExtend("issumchange", (Object)1);
            }
            if (!isShowFull && !CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                treeNode.getChildren().removeIf(x -> this.isTreeNodeChanged.negate().test((DimensionTree<String, DimensionNode>)x));
            }
        });
        return updatedMemberTree;
    }

    private void recursiveFilterNode(DimensionTree<String, DimensionNode> node, String filterStatus) {
        if (node.getChildren().size() > 0) {
            for (DimensionTree child : node.getChildren()) {
                this.recursiveFilterNode((DimensionTree<String, DimensionNode>)child, filterStatus);
            }
            node.getChildren().removeIf(x -> Objects.isNull(x.getParent()));
        }
        if (node.getChildren().size() == 0 && node.getParent() != null && !filterStatus.equals(((DimensionNode)node.getData()).getPropExtend("diffstatus"))) {
            node.setParent(null);
        }
    }

    private static final void setDiffStatusFlag(DimensionTree<String, DimensionNode> treeNode, DiffStatus diffStatus) {
        ((DimensionNode)treeNode.getData()).setPropExtend("diffstatus", (Object)diffStatus.code);
    }

    private static final String getDiffStatusFlag(DimensionTree<String, DimensionNode> treeNode) {
        return (String)((DimensionNode)treeNode.getData()).getPropExtend("diffstatus");
    }

    private void buildTreeBillComponent(String memberEntityId, DimensionTree<String, DimensionNode> tree, Consumer<DimensionTree<String, DimensionNode>> treeNodeConsumer, AbstractDiffShowModel diffShowModel) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_TREE);
        model.getDataEntity(true);
        model.beginInit();
        model.batchCreateNewEntryRow(KEY_TREE, tree.count());
        model.endInit();
        Map<String, JSONObject> dysFromDB = diffShowModel.getFieldFormDB();
        Map<String, Map> dysFromExcel = diffShowModel.getFieldFormImportExcel();
        Map<String, String> valueAndProperty = diffShowModel.getDimensionUserDefinedPropertiesNameByValue();
        tree.dfsWithIdx((t, idx) -> {
            DimensionNode node = (DimensionNode)t.getData();
            DynamicObject rowObj = model.getEntryRowEntity(KEY_TREE, idx.intValue());
            diffShowModel.copyDynValueForImport(node, rowObj, dysFromDB, dysFromExcel, valueAndProperty);
        }, Integer.valueOf(0));
    }

    private Map<Long, DynamicObject> queryDBData(String entityName, long modelId, long dimensionId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model.id", "=", (Object)modelId);
        qfBuilder.add("dimension.id", "=", (Object)dimensionId);
        Object[] existingData = BusinessDataServiceHelper.load((String)entityName, (String)PersistentHelper.selectFields(entityName, ImportOperateType.NEW), (QFilter[])qfBuilder.toArray());
        if (ArrayUtils.isEmpty((Object[])existingData)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(existingData.length);
        for (Object dy : existingData) {
            result.put(dy.getLong("id"), (DynamicObject)dy);
        }
        return result;
    }

    private static enum DiffStatus {
        newstore("newstore"),
        newshare("newshare"),
        deleted("deleted"),
        none("none"),
        override("override");

        private String code;

        private DiffStatus(String code) {
            this.code = code;
        }
    }
}

