/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.plugins.lastimportlist;

import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class ImportCompareList
extends AbstractBaseFormPlugin
implements HyperLinkClickListener {
    private static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        String historyRecordKey = "dim_import_ret1historyContent";
        String historyListCache = (String)AppCacheServiceHelper.get((String)historyRecordKey);
        if (historyListCache == null) {
            return;
        }
        Set historyRecords = (Set)JacksonUtils.fromJson((String)historyListCache, Set.class);
        List historyRecordList = historyRecords.stream().filter(x -> modelId.equals(x.get("modelId"))).sorted(Comparator.comparing(x -> (String)x.get("time"))).collect(Collectors.toList());
        Collections.reverse(historyRecordList);
        if (historyRecordList.size() > 0) {
            this.getModel().getEntryEntity(ENTRY_ENTITY).clear();
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, historyRecordList.size());
            for (int i = 0; i < historyRecordList.size(); ++i) {
                this.getModel().setValue("user", ((Map)historyRecordList.get(i)).get("userId"), i);
                this.getModel().setValue("time", ((Map)historyRecordList.get(i)).get("time"), i);
                this.getModel().setValue("dimension", ((Map)historyRecordList.get(i)).get("dimensionName"), i);
                this.getModel().setValue("excelname", ((Map)historyRecordList.get(i)).get("fileName"), i);
                this.getModel().setValue("dimensionid", ((Map)historyRecordList.get(i)).get("dimensionId"), i);
            }
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        super.hyperLinkClick(arg0);
        this.showDetail(arg0.getRowIndex());
    }

    private void showDetail(int row) {
        DynamicObject rowObj = (DynamicObject)this.getModel().getEntryEntity(ENTRY_ENTITY).get(row);
        IFormView parentView = this.getView();
        FormShowParameter parameter = new FormShowParameter();
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entityName");
        parameter.setCustomParam("time", (Object)rowObj.getString("time"));
        parameter.setCustomParam("entityName", (Object)entityName);
        parameter.setCustomParam("dimensionId", (Object)rowObj.getString("dimensionId"));
        parameter.setFormId("bcm_dimensioncomp");
        parameter.setParentFormId(parentView.getFormShowParameter().getFormId());
        parameter.setParentPageId(parentView.getPageId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parentView.showForm(parameter);
    }
}

