/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.userdefinedproperty;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DBBatchCache {
    private static Map<String, DynamicObject> propertyValuesCache;
    private static volatile DBBatchCache dbBatchCache;

    private DBBatchCache() {
    }

    public Map<String, DynamicObject> getPropertyValuesCache() {
        return propertyValuesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBBatchCache getDBBatchCacheSingleInstance(long modelId, long dimensionId) {
        if (dbBatchCache != null) return dbBatchCache;
        Class<DBBatchCache> clazz = DBBatchCache.class;
        synchronized (DBBatchCache.class) {
            if (dbBatchCache != null) return dbBatchCache;
            DBBatchCache.initDBBatchCache(modelId, dimensionId);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return dbBatchCache;
        }
    }

    public void onceBatchSaveUpdateNewInfo2Cache(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            propertyValuesCache.put(dynamicObject.getString("number"), dynamicObject);
        }
    }

    public void onceBatchSaveUpdateNewInfo2Cache(List<DynamicObject> dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            propertyValuesCache.put(dynamicObject.getString("number"), dynamicObject);
        }
    }

    public DynamicObject getPropertyValue(String number) {
        return propertyValuesCache.get(number);
    }

    public DynamicObject[] getAllValues() {
        return propertyValuesCache.values().toArray(new DynamicObject[propertyValuesCache.size()]);
    }

    public void clearDbCache() {
        propertyValuesCache.clear();
        dbBatchCache = null;
    }

    private static void initDBBatchCache(long modelId, long dimensionId) {
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        QFilter dimensionQf = new QFilter("dimension.id", "=", (Object)dimensionId);
        DynamicObject[] propertyValues = BusinessDataServiceHelper.load((String)"bcm_definedpropertyvalue", (String)"id,number,name,longnumber,parentid,level,dseq", (QFilter[])new QFilter[]{modelQf, dimensionQf});
        propertyValuesCache = new HashMap<String, DynamicObject>(128);
        for (DynamicObject propertyValue : propertyValues) {
            propertyValuesCache.put(propertyValue.getString("number"), propertyValue);
        }
        dbBatchCache = new DBBatchCache();
    }
}

