/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.userdefinedproperty;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.webapi.DefaultOperate;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.bos.BcmBatchImportPlugin;
import kd.fi.bcm.formplugin.dimension.batchimp.event.FailLogSubscriber;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportEventHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.event.ImportFinishEvent;
import kd.fi.bcm.formplugin.dimension.batchimp.handlers.IDimensionImportHandler;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportBillIndexWrap;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.OverrideResultEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.PersistEntry;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.UserDefinedPropertyDependencyResolver;
import kd.fi.bcm.formplugin.dimension.batchimp.userdefinedproperty.DBBatchCache;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.userdefinedproperty.CurrentParentExistValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.userdefinedproperty.FormatValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.userdefinedproperty.InputContentValidator;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.userdefinedproperty.NumberNameContentCheck;
import kd.fi.bcm.formplugin.impexport.BillResult;

public class UserDefinedPropertyImport
extends BcmBatchImportPlugin {
    protected static final Log LOG = LogFactory.getLog(UserDefinedPropertyImport.class);
    protected static final String CUR_APP = "fi-bcm-formplugin";
    protected String entityName;
    protected volatile long modelId = 0L;
    protected volatile DynamicObject model = null;
    protected String appId;
    protected boolean isCM = false;
    protected boolean isRpt = false;
    protected boolean isModelManager = false;
    protected volatile long dimensionId = 0L;
    protected volatile DynamicObject dimension = null;
    protected Map<String, DynamicObject> nonSharedMemberDyMap = Collections.synchronizedMap(new HashMap(16));
    private Map<String, String> newMembNums = new HashMap<String, String>(16);
    private Map<String, Set<String>> ebMembPermInfo = null;
    private int curBatch = 0;
    private List<IDimensionImportValidator> validators;
    private List<IDimensionImportHandler> handlers;
    private DBBatchCache dbBatchCache;
    private Set<String> notOnceNameInExcel;

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        String keyFields = (String)ctx.getOption().get("KeyFields");
        if (Objects.nonNull(keyFields) && !keyFields.contains("number")) {
            throw new KDBizException(ImportMsgUtils.onlySupportNumberAsUniqueKey());
        }
        this.entityName = ctx.getBillFormId();
        this.appId = ctx.getAppId();
        this.isCM = ApplicationTypeEnum.CM.appnum.equals(this.appId);
        this.isRpt = ApplicationTypeEnum.RPT.appnum.equals(this.appId);
        return this;
    }

    public String getDefaultKeyFields() {
        return "number";
    }

    protected int getBatchImportSize() {
        return 1000000;
    }

    protected int getMaxSaveBatchSize() {
        return 4000;
    }

    protected boolean isForceBatch() {
        return true;
    }

    public AbstractOperateWebApi getSaveWebApi() {
        return new DefaultOperate();
    }

    @Override
    public void beforeImport() {
        super.beforeImport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult apiResult;
        FailLogSubscriber.importLogger.set(logger);
        ++this.curBatch;
        int batchSize = rowdatas.size();
        LOG.info(this.genLogPrefix("ready") + "size: " + batchSize);
        long sTick = System.currentTimeMillis();
        try {
            this.initCurrentContext(rowdatas);
            this.beforeValidation(rowdatas);
            List allValidateResults = BatchProcessHelper.batchHandle(rowdatas, (int)2000, (int)500, x -> this.validateBatchBills((List<ImportBillData>)x), null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
            ArrayList<BillResult> savedBillResults = new ArrayList<BillResult>(16);
            ArrayList<ImportBillData> validatedBillData = new ArrayList<ImportBillData>(16);
            Iterator<ImportBillData> rowDataIter = rowdatas.iterator();
            int index = 0;
            int validIndex = 0;
            while (rowDataIter.hasNext()) {
                ImportBillData data = rowDataIter.next();
                Optional validMsg = (Optional)allValidateResults.get(index);
                if (validMsg.isPresent()) {
                    logger.log(Integer.valueOf(data.getStartIndex()), (String)validMsg.get()).fail();
                    rowDataIter.remove();
                    ImportEventHelper.sendImportFinishEvent(new ImportFinishEvent(ImportFinishEvent.ImportStatus.FAIL, this.modelId, this.dimensionId, data.getData().getString("number")));
                } else {
                    validatedBillData.add(data);
                    BillResult result = new BillResult();
                    result.setIndex(validIndex++);
                    result.setNumber(data.getData().getString("number"));
                    result.setSucess(true);
                    result.setData((Map<String, Object>)data.getData());
                    savedBillResults.add(result);
                }
                ++index;
            }
            LOG.info(this.genLogPrefix("validation") + String.format("batchSize: %s, cost time: %s", batchSize, System.currentTimeMillis() - sTick));
            long duTick = System.currentTimeMillis();
            List<Object> resultEntries = new ArrayList(validatedBillData.size());
            if (!validatedBillData.isEmpty()) {
                resultEntries = this.saveBatch(validatedBillData);
                for (int i = 0; i < resultEntries.size(); ++i) {
                    if (((ImportResultEntry)resultEntries.get(i)).isErr()) {
                        ((BillResult)savedBillResults.get(i)).setSucess(false);
                        ((BillResult)savedBillResults.get(i)).setMessage(((ImportResultEntry)resultEntries.get(i)).getErrMsg());
                    }
                    ImportEventHelper.sendImportFinishEvent(new ImportFinishEvent(((ImportResultEntry)resultEntries.get(i)).isErr() ? ImportFinishEvent.ImportStatus.FAIL : ImportFinishEvent.ImportStatus.SUCCESS, this.modelId, this.dimensionId, ((BillResult)savedBillResults.get(i)).getNumber()));
                }
            }
            LOG.info(this.genLogPrefix("dataUpdated") + String.format("size: %s, cost time: %s", validatedBillData.size(), System.currentTimeMillis() - duTick));
            if (savedBillResults.size() != resultEntries.size()) {
                throw new IllegalStateException("the count of saved result not equals the process count");
            }
            long puTick = System.currentTimeMillis();
            ApiResult apiResult2 = new ApiResult();
            ArrayList<Map<String, Object>> apiResultData = new ArrayList<Map<String, Object>>(10);
            for (int i = 0; i < savedBillResults.size(); ++i) {
                if (((ImportResultEntry)resultEntries.get(i)).isErr()) {
                    apiResult2.setSuccess(false);
                }
                apiResultData.add(((BillResult)savedBillResults.get(i)).toMap());
            }
            apiResult2.setData(apiResultData);
            LOG.info(this.genLogPrefix("postUpdated") + String.format("size: %s, cost time: %s", validatedBillData.size(), System.currentTimeMillis() - puTick));
            apiResult = apiResult2;
        }
        catch (Throwable throwable) {
            LOG.info(this.genLogPrefix("finished") + String.format("cost: %s", System.currentTimeMillis() - sTick));
            throw throwable;
        }
        LOG.info(this.genLogPrefix("finished") + String.format("cost: %s", System.currentTimeMillis() - sTick));
        return apiResult;
    }

    @Override
    protected void beforeEndLogStatistic(ImportLogger logger) {
    }

    @Override
    protected void afterImport() {
        super.afterImport();
        this.dbBatchCache.clearDbCache();
    }

    private void initCurrentContext(List<ImportBillData> bills) {
        this.modelId = (Long)this.ctx.getOption().get("BcmModelId");
        long pageDimensionId = Long.parseLong(this.ctx.getOption().get("BcmDimensionId").toString());
        if (Objects.isNull(this.dimension)) {
            QFBuilder dmFilterBuilder = new QFBuilder();
            dmFilterBuilder.add("model.id", "=", (Object)this.modelId);
            dmFilterBuilder.add("id", "=", (Object)pageDimensionId);
            this.dimension = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number", (QFilter[])dmFilterBuilder.toArray());
            if (Objects.isNull(this.dimension)) {
                this.dimension = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension_ext", (String)"id,number", (QFilter[])dmFilterBuilder.toArray());
                if (Objects.isNull(this.dimension)) {
                    throw new KDBizException(ImportMsgUtils.dimensionNotExists(), new Object[0]);
                }
            }
            this.dimensionId = this.dimension.getLong("id");
        }
        this.model = BusinessDataServiceHelper.newDynamicObject((String)"bcm_model");
        this.model.set("id", (Object)this.modelId);
        DimensionImportContext context = new DimensionImportContext(this.model, this.dimension, this.entityName, ImportHelper.getImportType(this.ctx), this.appId, this.isModelManager, this.newMembNums, this.ebMembPermInfo);
        this.dbBatchCache = DBBatchCache.getDBBatchCacheSingleInstance(this.modelId, this.dimensionId);
        ImportContextHolder.setImportContext(context);
        this.notOnceNameInExcel = this.notOnceNameSetInExcel(bills);
        this.validators = new ArrayList<IDimensionImportValidator>(10);
        this.validators.add(new InputContentValidator());
        this.validators.add(new FormatValidator());
        this.validators.add(new CurrentParentExistValidator(this.dbBatchCache));
        this.validators.add(new NumberNameContentCheck(this.notOnceNameInExcel));
        Collections.sort(this.validators, new Comparator<IDimensionImportValidator>(){

            @Override
            public int compare(IDimensionImportValidator o1, IDimensionImportValidator o2) {
                return o2.getWeight() - o1.getWeight();
            }
        });
        this.handlers = new ArrayList<IDimensionImportHandler>(5);
    }

    private Set<String> notOnceNameSetInExcel(List<ImportBillData> bills) {
        HashMap<String, Integer> nameFrequency = new HashMap<String, Integer>(16);
        for (ImportBillData bill : bills) {
            String name = bill.getData().get((Object)"name").toString();
            if (nameFrequency.containsKey(name)) {
                int frequency = (Integer)nameFrequency.get(name);
                nameFrequency.put(name, frequency + 1);
                continue;
            }
            nameFrequency.put(name, 1);
        }
        HashSet<String> repeatName = new HashSet<String>(16);
        for (Map.Entry stringIntegerEntry : nameFrequency.entrySet()) {
            if ((Integer)stringIntegerEntry.getValue() <= 1) continue;
            repeatName.add((String)stringIntegerEntry.getKey());
        }
        return repeatName;
    }

    private List<Optional<String>> validateBatchBills(List<ImportBillData> bills) {
        ArrayList<Optional<String>> billValidateResults = new ArrayList<Optional<String>>(bills.size());
        for (int i = 0; i < bills.size(); ++i) {
            try {
                billValidateResults.add(this.validateBillData(bills.get(i)));
                continue;
            }
            catch (Exception e) {
                LOG.error("Failed to validate bill: " + bills.get(i).getData() + " for " + e.getMessage(), (Throwable)e);
                billValidateResults.add(Optional.of(e.getMessage()));
            }
        }
        return billValidateResults;
    }

    protected void beforeValidation(List<ImportBillData> importedBills) {
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        switch (importType) {
            case NEW: {
                this.updateWithNewId(importedBills);
                break;
            }
            case OVERRIDE: {
                this.updateWithExistId(importedBills, false);
                break;
            }
            case OVERRIDENEW: {
                this.updateWithExistId(importedBills, true);
                break;
            }
        }
    }

    private void updateWithNewId(List<ImportBillData> newBills) {
        if (CollectionUtils.isEmpty(newBills)) {
            return;
        }
        long[] ids = DBServiceHelper.genLongIds((String)this.entityName, (int)newBills.size());
        for (int j = 0; j < newBills.size(); ++j) {
            RowDataExtUtil.addId(newBills.get(j), ids[j]);
        }
    }

    private void updateWithExistId(List<ImportBillData> existBills, boolean isOverrideNew) {
        ArrayList nonSharedBills = new ArrayList(existBills.size());
        existBills.forEach(x -> nonSharedBills.add(x));
        if (!CollectionUtils.isEmpty(nonSharedBills)) {
            this.nonSharedMemberDyMap = ImportHelper.queryUserDefinedPropertyEntities(nonSharedBills.stream().map(x -> (String)x.getData().get((Object)"number")).collect(Collectors.toList()), this.modelId, this.dimensionId);
            nonSharedBills.forEach(x -> {
                String number = (String)x.getData().get((Object)"number");
                if (this.nonSharedMemberDyMap.containsKey(number)) {
                    RowDataExtUtil.addId(x, this.nonSharedMemberDyMap.get(number).getLong("id"));
                    RowDataExtUtil.addExistingRecord(x, this.nonSharedMemberDyMap.get(number));
                } else if (isOverrideNew) {
                    RowDataExtUtil.addId(x, DBServiceHelper.genGlobalLongId());
                } else {
                    RowDataExtUtil.addId(x, 0L);
                }
            });
        }
    }

    private List<ImportResultEntry> saveBatch(List<ImportBillData> billDataList) {
        long sTick = System.currentTimeMillis();
        List<Object> resultEntries = new ArrayList(billDataList.size());
        String sDimensionNumber = ImportHelper.getNumber(this.dimension);
        List<ImportBillIndexWrap> billWraps = ImportBillIndexWrap.buildWrapList(billDataList);
        ImportOperateType importType = ImportHelper.getImportType(this.ctx);
        try {
            if (ImportOperateType.NEW == importType) {
                resultEntries = this.insertNewBatch(billWraps);
            } else if (ImportOperateType.OVERRIDE == importType) {
                resultEntries = this.overrideBatch(billWraps);
            } else if (ImportOperateType.OVERRIDENEW == importType) {
                List<ImportResultEntry> rawOverrideResults = this.overrideBatch(billWraps);
                List<ImportBillIndexWrap> failedOverrideBillWraps = rawOverrideResults.stream().filter(x -> x.isErr()).map(x -> new ImportBillIndexWrap((ImportBillData)billDataList.get(x.getIndex()), x.getIndex())).collect(Collectors.toList());
                List<ImportResultEntry> insertResults = this.insertNewBatch(failedOverrideBillWraps);
                resultEntries.addAll(rawOverrideResults.stream().filter(x -> !x.isErr()).collect(Collectors.toList()));
                resultEntries.addAll(insertResults);
            }
        }
        catch (Exception e) {
            LOG.error("dimension_import_submit allfailed:" + e.getMessage(), (Throwable)e);
            resultEntries = billWraps.stream().map(x -> ImportResultEntry.error(ImportMsgUtils.unexpectedError() + e.getMessage(), x.getListIndex())).collect(Collectors.toList());
        }
        Collections.sort(resultEntries, new Comparator<ImportResultEntry>(){

            @Override
            public int compare(ImportResultEntry o1, ImportResultEntry o2) {
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        return resultEntries;
    }

    protected Optional<String> validateBillData(ImportBillData billData) {
        for (IDimensionImportValidator validator : this.validators) {
            Optional<Object> failedMsg = Optional.empty();
            try {
                failedMsg = validator.validate(billData);
                if (!failedMsg.isPresent()) continue;
                return failedMsg;
            }
            catch (Exception e) {
                LOG.error("Failed to import on exception:" + e.getMessage(), (Throwable)e);
                return Optional.of(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5f02\u5e38\u4e3a\uff1a%s", (String)"UserDefinedPropertyImport_0", (String)CUR_APP, (Object[])new Object[0]), e.toString()));
            }
        }
        return Optional.empty();
    }

    @Override
    protected void filterFromLeftRowDatas(List<ImportBillData> leftRowdatas, List<ImportBillData> rowdatas) {
        int batchSize = this.getMaxSaveBatchSize();
        int needRowsCount = batchSize - this.countBatchRows(rowdatas);
        try (UserDefinedPropertyDependencyResolver dependencyResolver = new UserDefinedPropertyDependencyResolver(leftRowdatas);){
            Iterator<ImportBillData> leftRowdataIter = leftRowdatas.iterator();
            while (leftRowdataIter.hasNext() && needRowsCount > 0) {
                ImportBillData billdata = leftRowdataIter.next();
                int billRowSpan = billdata.getEndIndex() - billdata.getStartIndex() + 1;
                if (dependencyResolver.checkBillIsDependPrevious(billdata)) continue;
                dependencyResolver.notifyBillSelected(billdata);
                rowdatas.add(billdata);
                leftRowdataIter.remove();
                needRowsCount -= Math.max(1, billRowSpan);
            }
        }
        if (rowdatas.isEmpty() && !leftRowdatas.isEmpty()) {
            rowdatas.add(leftRowdatas.remove(0));
        }
    }

    private List<ImportResultEntry> insertNewBatch(List<ImportBillIndexWrap> billDataList) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return Collections.EMPTY_LIST;
        }
        long packDataTick = System.currentTimeMillis();
        List persistEntries = BatchProcessHelper.batchHandle(billDataList, (int)2000, (int)500, x -> this.handleAssembleNewMemberEntity((List<ImportBillIndexWrap>)x), null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
        persistEntries.sort(new Comparator<PersistEntry>(){

            @Override
            public int compare(PersistEntry o1, PersistEntry o2) {
                return Integer.compare(o1.getBillWrap().getListIndex(), o2.getBillWrap().getListIndex());
            }
        });
        LOG.info(this.genLogPrefix("insert.packData") + String.format("batchSize: %s, cost time: %s", billDataList.size(), System.currentTimeMillis() - packDataTick));
        this.setNewDataDSequence(persistEntries);
        try (TXHandle tx = TX.required();){
            try {
                Object[] dynamicObjects = new DynamicObject[persistEntries.size()];
                int i = 0;
                for (PersistEntry persistEntry : persistEntries) {
                    dynamicObjects[i] = persistEntry.getMemberTreeDy();
                    ++i;
                }
                if (dynamicObjects.length > 0) {
                    SaveServiceHelper.save((IDataEntityType)dynamicObjects[0].getDynamicObjectType(), (Object[])dynamicObjects);
                    this.dbBatchCache.onceBatchSaveUpdateNewInfo2Cache((DynamicObject[])dynamicObjects);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        if (!ImportContextHolder.isDryRun()) {
            for (IDimensionImportHandler handler : this.handlers) {
                long handlerStartTick = System.currentTimeMillis();
                handler.postInsert(persistEntries);
                LOG.info(this.genLogPrefix("insert." + handler.getClass().getSimpleName()) + String.format("log-size: %s, cost time: %s", persistEntries.size(), System.currentTimeMillis() - handlerStartTick));
            }
        }
        ArrayList<ImportResultEntry> resultEntries = new ArrayList<ImportResultEntry>(billDataList.size());
        for (int i = 0; i < persistEntries.size(); ++i) {
            DynamicObject memberTreeDy = ((PersistEntry)persistEntries.get(i)).getMemberTreeDy();
            int billListIndex = ((PersistEntry)persistEntries.get(i)).getBillWrap().getListIndex();
            long curSucId = memberTreeDy.getLong("id");
            if (curSucId == 0L) {
                resultEntries.add(ImportResultEntry.error(ImportMsgUtils.unexpectedInsertFail(), billListIndex));
                continue;
            }
            resultEntries.add(ImportResultEntry.success(curSucId, memberTreeDy, billListIndex));
        }
        ImportContextHolder.addBatchNewIds(persistEntries.stream().map(x -> x.getMemberTreeDy().getLong("id")).collect(Collectors.toSet()));
        return resultEntries;
    }

    private List<PersistEntry> handleAssembleNewMemberEntity(List<ImportBillIndexWrap> billDataList) {
        ArrayList<PersistEntry> persistEntries = new ArrayList<PersistEntry>(billDataList.size());
        for (ImportBillIndexWrap billIndexWrap : billDataList) {
            DynamicObject memberTreeDy = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
            this.assemMemberTree(billIndexWrap.getBill(), memberTreeDy, true);
            persistEntries.add(new PersistEntry(billIndexWrap, memberTreeDy, null));
        }
        return persistEntries;
    }

    private List<ImportResultEntry> overrideBatch(List<ImportBillIndexWrap> billDataList) {
        List<ImportBillIndexWrap> nonshareBills = billDataList;
        List<ImportResultEntry> nonShareImportEntries = this.overrideNonShareMemberBatch(nonshareBills);
        ArrayList<ImportResultEntry> allEntries = new ArrayList<ImportResultEntry>(nonShareImportEntries.size());
        allEntries.addAll(nonShareImportEntries);
        return allEntries;
    }

    private List<ImportResultEntry> overrideNonShareMemberBatch(List<ImportBillIndexWrap> billDataList) {
        if (CollectionUtils.isEmpty(billDataList)) {
            return Collections.EMPTY_LIST;
        }
        long tick = System.currentTimeMillis();
        List rawOverrideEntries = BatchProcessHelper.batchHandle(billDataList, (int)2000, (int)500, x -> this.handleAssembleOverrideMemberEntity((List<ImportBillIndexWrap>)x), null, (BatchProcessHelper.Scene)BatchProcessHelper.Scene.CPU);
        LOG.info(this.genLogPrefix("override.packData") + String.format("batchSize: %s, cost time: %s", rawOverrideEntries.size(), System.currentTimeMillis() - tick));
        List needOverrideEntries = rawOverrideEntries.stream().filter(x -> x.isNeedOverride()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(needOverrideEntries)) {
            TXHandle tx = TX.required();
            Object object = null;
            try {
                try {
                    long tempTick = System.currentTimeMillis();
                    List<DynamicObject> dynamicObjects = needOverrideEntries.stream().map(x -> x.getOverridDy()).collect(Collectors.toList());
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                    this.dbBatchCache.onceBatchSaveUpdateNewInfo2Cache(dynamicObjects);
                    LOG.info(this.genLogPrefix("override.update") + String.format("batchSize: %s, cost time: %s", needOverrideEntries.size(), System.currentTimeMillis() - tempTick));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            catch (Throwable e) {
                object = e;
                throw e;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable e) {
                            ((Throwable)object).addSuppressed(e);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        ArrayList<ImportResultEntry> importEntries = new ArrayList<ImportResultEntry>(rawOverrideEntries.size());
        for (OverrideResultEntry entry : rawOverrideEntries) {
            if (entry.isNeedOverride()) {
                DynamicObject overrideDy = entry.getOverridDy();
                importEntries.add(ImportResultEntry.success(overrideDy.getLong("id"), overrideDy, entry.getBillWrap().getListIndex()));
                continue;
            }
            importEntries.add(ImportResultEntry.error(ImportMsgUtils.currentNumberNotExists(), entry.getBillWrap().getListIndex()));
        }
        return importEntries;
    }

    private List<OverrideResultEntry> handleAssembleOverrideMemberEntity(List<ImportBillIndexWrap> billDataList) {
        DynamicObject[] allValues;
        HashMap<String, DynamicObject> number2ExistValues = new HashMap<String, DynamicObject>(16);
        for (DynamicObject value : allValues = this.dbBatchCache.getAllValues()) {
            number2ExistValues.put(value.getString("number"), value);
        }
        ArrayList<OverrideResultEntry> rawOverrideEntries = new ArrayList<OverrideResultEntry>(billDataList.size());
        for (ImportBillIndexWrap billIndexWrap : billDataList) {
            JSONObject data = billIndexWrap.getBill().getData();
            DynamicObject existRecordDy = (DynamicObject)number2ExistValues.get(String.valueOf(data.get("number")));
            if (existRecordDy != null) {
                this.assemMemberTree(billIndexWrap.getBill(), existRecordDy, false);
                rawOverrideEntries.add(new OverrideResultEntry(billIndexWrap, null, data.get("parentnumber").toString(), existRecordDy, true));
                continue;
            }
            rawOverrideEntries.add(OverrideResultEntry.isSkip(billIndexWrap));
        }
        return rawOverrideEntries;
    }

    public void assemMemberTree(ImportBillData bill, DynamicObject memberTreeDy, boolean isNew) {
        JSONObject data = bill.getData();
        DynamicObject parent = this.dbBatchCache.getPropertyValue(data.get("parentnumber").toString());
        long parentId = parent.getLong("id");
        String parentLongNum = parent.getString("longnumber");
        Integer parentLevel = parent.getInt("level");
        if (!isNew) {
            memberTreeDy.set("parentid", (Object)parentId);
            memberTreeDy.set("name", data.get("name"));
            memberTreeDy.set("longnumber", (Object)(parentLongNum + '!' + data.get("number")));
        } else {
            memberTreeDy.set("parentid", (Object)parentId);
            memberTreeDy.set("number", data.get("number"));
            memberTreeDy.set("name", data.get("name"));
            memberTreeDy.set("longnumber", (Object)(parentLongNum + '!' + data.get("number")));
            if (!Objects.isNull(parentLevel)) {
                memberTreeDy.set("level", (Object)(parentLevel + 1));
            } else {
                memberTreeDy.set("level", (Object)0);
            }
            QFilter modelQf = new QFilter("model.id", "=", (Object)this.modelId);
            QFilter dimensionQf = new QFilter("dimension.id", "=", (Object)this.dimensionId);
            QFilter numberQf = new QFilter("number", "=", data.get("userdefinedkindnumber"));
            DynamicObject property = BusinessDataServiceHelper.loadSingle((String)"bcm_definedproperty", (String)"id,number", (QFilter[])new QFilter[]{modelQf, dimensionQf, numberQf});
            if (property != null) {
                memberTreeDy.set("propertyid", (Object)property.getLong("id"));
            }
            memberTreeDy.set("dimension", (Object)this.dimensionId);
            memberTreeDy.set("model", (Object)this.modelId);
        }
    }

    public String genLogPrefix(String operationName) {
        return String.format("dimension_import:: entity: %s, batch: %s, operate: %s, ", this.curBatch, this.entityName, operationName);
    }

    private void setNewDataDSequence(List<PersistEntry> persistEntries) {
        HashMap<Long, Integer> maxDseq = new HashMap<Long, Integer>(16);
        for (PersistEntry persistEntry : persistEntries) {
            ImportBillData bill = persistEntry.getBillWrap().getBill();
            Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
            if (existingDy.isPresent()) continue;
            DynamicObject parent = this.dbBatchCache.getPropertyValue(persistEntry.getBillWrap().getBill().getData().get((Object)"parentnumber").toString());
            long parentId = 0L;
            parentId = parent.getLong("id");
            if (parentId != 0L && maxDseq.get(parentId) == null) {
                maxDseq.put(parentId, this.getParentMaxDsq(parentId) + 1);
                persistEntry.getMemberTreeDy().set("dseq", maxDseq.get(parentId));
                continue;
            }
            maxDseq.put(parentId, (Integer)maxDseq.get(parentId) + 1);
            persistEntry.getMemberTreeDy().set("dseq", maxDseq.get(parentId));
        }
    }

    private int getParentMaxDsq(long parentId) {
        DynamicObject[] allData = this.dbBatchCache.getAllValues();
        int maxSeq = 0;
        for (DynamicObject dy : allData) {
            Integer otherDseq = dy.getInt("dseq");
            if (otherDseq == null || dy.getLong("parentid.id") != parentId || maxSeq >= otherDseq) continue;
            maxSeq = otherDseq;
        }
        return maxSeq;
    }
}

