/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.IDimensionImportValidator;

public abstract class AbstractDimensionImportValidator
implements IDimensionImportValidator {
    private volatile AtomicLong totalTick = new AtomicLong(0L);
    private volatile AtomicInteger totalCheckCnt = new AtomicInteger(0);
    protected static final Log LOG = LogFactory.getLog(AbstractDimensionImportValidator.class);
    protected static final String CUR_APP = "fi-bcm-formplugin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> proxyValidate(ImportBillData bill) {
        long tick = System.currentTimeMillis();
        try {
            Optional<String> optional = this.validate(bill);
            return optional;
        }
        finally {
            this.totalTick.getAndAdd(System.currentTimeMillis() - tick);
            this.totalCheckCnt.getAndIncrement();
        }
    }

    public void clearTick() {
        this.totalTick.set(0L);
        this.totalCheckCnt.set(0);
    }

    public long getTotalTick() {
        return this.totalTick.get();
    }

    public int getTotalCheckCnt() {
        return this.totalCheckCnt.get();
    }

    protected long getModelId() {
        return ImportContextHolder.getModelId();
    }

    protected long getDimensionId() {
        return ImportContextHolder.getDimensionId();
    }
}

