/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.account;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Pattern;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.util.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportText2DateUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class AccountChangeRecordInputFormatValidator
extends AbstractDimensionImportValidator {
    @Override
    public int getWeight() {
        return 500;
    }

    @Override
    public Optional<String> validate(ImportBillData bill) {
        JSONObject data = bill.getData();
        String bizChangeRdsFromExcel = (String)data.get("bizchangerds");
        if (StringUtils.isNotEmpty((String)bizChangeRdsFromExcel)) {
            String noTailBizChangeRdsFromExcel = bizChangeRdsFromExcel.substring(0, bizChangeRdsFromExcel.length() - 1);
            String[] rds = noTailBizChangeRdsFromExcel.split(";\n");
            String pat = "(\\s)*\\d{4}(\\s)*-(\\s)*\\d{2}(\\s)*-(\\s)*\\d{2}(\\s)*";
            Date initUnitDate = null;
            for (String aRd : rds) {
                for (String aUnit : aRd.split(",")) {
                    boolean isMatch = Pattern.matches(pat, aUnit);
                    if (!isMatch) {
                        return Optional.of(ImportMsgUtils.accountChangeRecordInputFormatError());
                    }
                    if (initUnitDate == null) {
                        initUnitDate = ImportText2DateUtils.dateStr2Date(aUnit);
                        continue;
                    }
                    Date curDate = ImportText2DateUtils.dateStr2Date(aUnit);
                    if (curDate.getTime() < initUnitDate.getTime()) {
                        return Optional.of(ImportMsgUtils.accountChangeRecordInputDateError());
                    }
                    initUnitDate = curDate;
                }
            }
        }
        return Optional.empty();
    }
}

