/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.util.AccountMemberUtil;
import kd.fi.bcm.business.export.EffectiveDimensionEnum;
import kd.fi.bcm.business.export.strategy.helper.DimShortNumAndFieldMap;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class DimensionEffectiveCombinationValidator
extends AbstractDimensionImportValidator {
    private static Set<String> ALLOW_DIMENSION_COLS = Arrays.stream(EffectiveDimensionEnum.values()).map(x -> x.getColName()).collect(Collectors.toSet());
    private volatile DynamicObject[] allDimensions = null;
    private Set<String> effectiveCols = null;
    private Map<String, JSONArray> entryBuildCache = Collections.synchronizedMap(new HashMap(16));
    private static String NUMBER_MARK = "number";
    private static String NAME_MARK = "name";
    private static String PID_MARK = "pid";
    private static String ID_MARK = "id";
    private static String DIMENSION_MARK = "dimension";
    private static String MODEL_MARK = "model";
    private static String EMPTY_STRING = "";
    private static String COLON_STRING = ":";
    private static String LEFT_BRACKETS = "(";
    private static String RIGHT_BRACKETS = ")";
    private static String SELECT_PROPERTIES = "id,name,number";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> validate(ImportBillData bill) {
        if (Objects.isNull(this.allDimensions)) {
            DimensionEffectiveCombinationValidator dimensionEffectiveCombinationValidator = this;
            synchronized (dimensionEffectiveCombinationValidator) {
                if (Objects.isNull(this.allDimensions)) {
                    this.allDimensions = this.loadDimension();
                    this.effectiveCols = Arrays.stream(this.allDimensions).map(x -> {
                        String sName = x.getString("shortnumber");
                        DimShortNumAndFieldMap dimShortNumAndFieldMap = BatchImportReadOnlyCache.getDimShortNumAndFieldMap(String.valueOf(this.getModelId()));
                        return dimShortNumAndFieldMap.getColFieldByDimShortNumber(sName);
                    }).collect(Collectors.toSet());
                }
            }
        }
        Pair<String, List<Map<String, Object>>> entryResult = this.creatDmEntry(bill);
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)entryResult.p1))) {
            return Optional.of(entryResult.p1);
        }
        RowDataExtUtil.addExtObject(bill, entryResult.p2, "existingDmEntry");
        return Optional.empty();
    }

    private Pair<String, List<Map<String, Object>>> creatDmEntry(ImportBillData billData) {
        JSONObject data = billData.getData();
        if (!RowDataExtUtil.isIdValid(billData)) {
            return new Pair((Object)ResManager.loadKDString((String)"\u5f02\u5e38\u6570\u636e\uff0c\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"DimensionEffectiveCombinationValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null);
        }
        for (String col2 : data.keySet().stream().filter(col -> ALLOW_DIMENSION_COLS.contains(col)).collect(Collectors.toSet())) {
            Object colValue = data.get(col2);
            if (!Objects.nonNull(colValue) || !StringUtils.isNotEmpty((CharSequence)colValue.toString()) || this.effectiveCols.contains(col2)) continue;
            return new Pair((Object)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u6709\u6548\u7ec4\u5408\u201c%s\u201d\u3002 ", (String)"DimensionEffectiveCombinationValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), col2), null);
        }
        ArrayList dynamicObjectList = new ArrayList(16);
        int seq = 1;
        for (DynamicObject dyn : this.allDimensions) {
            String sName = dyn.getString("shortnumber");
            DimShortNumAndFieldMap dimShortNumAndFieldMap = BatchImportReadOnlyCache.getDimShortNumAndFieldMap(String.valueOf(this.getModelId()));
            String value = dimShortNumAndFieldMap.getColFieldByDimShortNumber(sName);
            if (!data.containsKey(value) || data.get(value) == null) continue;
            String singCellValue = (String)data.get(value);
            List<String> entryList = this.getListFromValue(singCellValue);
            HashMap<String, Object> singMap = new HashMap<String, Object>(8);
            JSONArray entry = this.getEntryStrFromCache(entryList, dyn.getString("memberform"), this.getModelId(), dyn.getLong(ID_MARK));
            if (Objects.isNull(entry)) {
                return new Pair((Object)String.format(ResManager.loadKDString((String)"%s\u5217\u7684\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7ec4\u5408\u8bbe\u7f6e\u503c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u503c\u662f\u5426\u5b58\u5728\u3002", (String)"DimensionEffectiveCombinationValidator_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), value), null);
            }
            singMap.put("dm_val", entry.toJSONString());
            singMap.put("dm_dim", dyn);
            singMap.put("seq", seq);
            ++seq;
            dynamicObjectList.add(singMap);
        }
        return new Pair(null, dynamicObjectList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray getEntryStrFromCache(List<String> entryList, String mark, long modelId, long dimensionId) {
        Collections.sort(entryList);
        String cacheKey = String.format("entry:%s_mark:%s_model:%s_dimension:%s", CollectionUtils.isEmpty(entryList) ? "" : String.join((CharSequence)"|", entryList), mark, modelId, dimensionId);
        if (!this.entryBuildCache.containsKey(cacheKey)) {
            DimensionEffectiveCombinationValidator dimensionEffectiveCombinationValidator = this;
            synchronized (dimensionEffectiveCombinationValidator) {
                if (!this.entryBuildCache.containsKey(cacheKey)) {
                    JSONArray entryResult = this.getEntryStr(entryList, mark, modelId, dimensionId);
                    this.entryBuildCache.put(cacheKey, entryResult);
                }
            }
        }
        return this.entryBuildCache.get(cacheKey);
    }

    private DynamicObject[] loadDimension() {
        QFilter modelFilter = new QFilter(MODEL_MARK, "=", (Object)this.getModelId());
        QFilter typeFilter = new QFilter(NUMBER_MARK, "in", (Object)AccountMemberUtil.dimMapNumbers);
        typeFilter.or(new QFilter("fieldmapped", "!=", (Object)""));
        return BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"id,dseq,isuseddataperm,masterid,memberform,membermodel,name,number,shortnumber", (QFilter[])new QFilter[]{modelFilter, typeFilter}, (String)"dseq");
    }

    private JSONArray getEntryStr(List<String> entryList, String mark, long modelId, long dimensionId) {
        DynamicObjectCollection objects;
        QFBuilder qf = new QFBuilder();
        qf.add(MODEL_MARK, "=", (Object)modelId);
        qf.add(DIMENSION_MARK, "=", (Object)dimensionId);
        ArrayList<String> sList = new ArrayList<String>(entryList.size());
        for (String s : entryList) {
            sList.add(s.contains(LEFT_BRACKETS) && s.contains(RIGHT_BRACKETS) ? s.substring(s.indexOf(LEFT_BRACKETS) + 1, s.indexOf(RIGHT_BRACKETS)) : s);
        }
        String pId = EMPTY_STRING;
        String pNumber = EMPTY_STRING;
        String pName = EMPTY_STRING;
        if (((String)sList.get(0)).contains(COLON_STRING)) {
            ArrayList<String> tempList = new ArrayList<String>(sList.size());
            for (int i = 0; i < sList.size(); ++i) {
                String tempNumber = (String)sList.get(i);
                if (!tempNumber.contains(COLON_STRING)) continue;
                pNumber = tempNumber.split(COLON_STRING)[0];
                tempList.add(tempNumber.split(COLON_STRING)[1]);
            }
            qf.add(NUMBER_MARK, "=", (Object)pNumber);
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"bcm_definedproperty", (String)SELECT_PROPERTIES, (QFilter[])qf.toArray());
            if (dyo != null) {
                pId = Long.toString(dyo.getLong(ID_MARK));
                pName = dyo.getString(NAME_MARK);
            }
            objects = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)SELECT_PROPERTIES, (QFilter[])this.creatBuilder(modelId, dimensionId, tempList).toArray());
        } else {
            qf.add(NUMBER_MARK, "in", sList);
            objects = QueryServiceHelper.query((String)mark, (String)SELECT_PROPERTIES, (QFilter[])qf.toArray());
        }
        if (objects.size() == 0) {
            return null;
        }
        HashMap dynamicObjectMap = new HashMap(entryList.size());
        for (DynamicObject dynamicObject : objects) {
            HashMap<String, String> tempMap = new HashMap<String, String>(8);
            String tempNumber = EMPTY_STRING.equals(pNumber) ? dynamicObject.getString(NUMBER_MARK) : pNumber + COLON_STRING + dynamicObject.getString(NUMBER_MARK);
            tempMap.put(NUMBER_MARK, tempNumber);
            tempMap.put(NAME_MARK, EMPTY_STRING.equals(pName) ? dynamicObject.getString(NAME_MARK) : pNumber + COLON_STRING + dynamicObject.getString(NAME_MARK));
            tempMap.put(ID_MARK, dynamicObject.getString(ID_MARK));
            tempMap.put(PID_MARK, pId);
            dynamicObjectMap.put(tempNumber, tempMap);
        }
        JSONArray jsonArray = new JSONArray();
        for (String s : entryList) {
            pNumber = (s = s.trim()).contains(LEFT_BRACKETS) && s.contains(RIGHT_BRACKETS) ? s.substring(s.indexOf(LEFT_BRACKETS) + 1, s.indexOf(RIGHT_BRACKETS)) : s;
            if (!dynamicObjectMap.containsKey(pNumber)) continue;
            JSONObject valueJson = s.startsWith("Child") ? this.creatJsonObject("20", (Map)dynamicObjectMap.get(pNumber)) : (s.startsWith("Ichild") ? this.creatJsonObject("30", (Map)dynamicObjectMap.get(pNumber)) : (s.startsWith("Descendant") ? this.creatJsonObject("40", (Map)dynamicObjectMap.get(pNumber)) : (s.startsWith("Hierarchy") ? this.creatJsonObject("50", (Map)dynamicObjectMap.get(pNumber)) : (s.startsWith("Sibling") ? this.creatJsonObject("60", (Map)dynamicObjectMap.get(pNumber)) : (s.startsWith("Isibling") ? this.creatJsonObject("70", (Map)dynamicObjectMap.get(pNumber)) : (s.startsWith("Base") ? this.creatJsonObject("90", (Map)dynamicObjectMap.get(pNumber)) : this.creatJsonObject("10", (Map)dynamicObjectMap.get(pNumber))))))));
            jsonArray.add((Object)valueJson);
        }
        return jsonArray;
    }

    private QFBuilder creatBuilder(long modelId, Long dimensionId, List<String> lNumber) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(MODEL_MARK, "=", (Object)modelId);
        qfBuilder.add(DIMENSION_MARK, "=", (Object)dimensionId);
        qfBuilder.add(NUMBER_MARK, "in", lNumber);
        return qfBuilder;
    }

    private JSONObject creatJsonObject(String s1, Map<String, String> dynamicObject) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NUMBER_MARK, (Object)dynamicObject.get(NUMBER_MARK));
        jsonObject.put("scope", (Object)s1);
        jsonObject.put(NAME_MARK, (Object)dynamicObject.get(NAME_MARK));
        jsonObject.put(PID_MARK, (Object)dynamicObject.get(PID_MARK));
        jsonObject.put(ID_MARK, (Object)dynamicObject.get(ID_MARK));
        return jsonObject;
    }

    private List<String> getListFromValue(String entryValue) {
        ArrayList<String> list = new ArrayList<String>(2);
        if (entryValue.contains(";")) {
            return Arrays.asList(entryValue.split(";"));
        }
        list.add(entryValue);
        return list;
    }
}

