/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.account;

import java.util.Optional;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class ScaleValueValidator
extends AbstractDimensionImportValidator {
    private static final String ACCOUNTSCALE = "accountscale";
    private static final String STORAGETYPE = "storagetype";

    @Override
    public Optional<String> validate(ImportBillData bill) {
        if (bill.getData() != null && bill.getData().get((Object)ACCOUNTSCALE) != null && (StorageTypeEnum.STORAGE.index.equals(String.valueOf(bill.getData().get((Object)STORAGETYPE))) || StorageTypeEnum.DYNAMIC.index.equals(String.valueOf(bill.getData().get((Object)STORAGETYPE))))) {
            String scaleString = String.valueOf(bill.getData().get((Object)ACCOUNTSCALE));
            if (scaleString.contains(".")) {
                return Optional.of(ImportMsgUtils.scaleValueIllegal());
            }
            try {
                int scale = Integer.parseInt(scaleString);
                if (scale < -4 || scale > 15) {
                    return Optional.of(ImportMsgUtils.scaleValueIllegal());
                }
                return Optional.empty();
            }
            catch (NumberFormatException e) {
                return Optional.of(ImportMsgUtils.scaleValueIllegal());
            }
        }
        if (bill.getData() != null && bill.getData().get((Object)ACCOUNTSCALE) != null && StorageTypeEnum.LABEL.index.equals(String.valueOf(bill.getData().get((Object)STORAGETYPE)))) {
            return Optional.of(ImportMsgUtils.storageTypeIllegal());
        }
        return Optional.empty();
    }
}

