/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ResultCodeEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.event.AssoImportSuccessSubscriber;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;
import org.apache.commons.collections.CollectionUtils;

public class AssoStorageValidator
extends AbstractDimensionImportValidator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<String> validate(ImportBillData bill) {
        String entityName = ((DynamicObject)bill.getData().get((Object)"extparent")).getDynamicObjectType().getName();
        JSONObject data = bill.getData();
        String storagetype = data.getString("storagetype");
        String number = data.getString("number");
        String assoStorageNum = ImportHelper.getImportBillProp(bill, "assostoremem.number").toString();
        if (StringUtils.isEmpty((CharSequence)assoStorageNum)) {
            return Optional.empty();
        }
        if (!ConfigServiceHelper.getBoolParam((Long)ImportContextHolder.getModelId(), (String)"CM043")) {
            return Optional.of(ImportMsgUtils.paramNoOpenOfCM043());
        }
        if (StorageTypeEnum.SHARE.getOIndex().equals(storagetype)) {
            return Optional.empty();
        }
        if (!StorageTypeEnum.DYNAMIC.getOIndex().equals(storagetype)) {
            return Optional.of(ImportMsgUtils.onlyDynamicMemInput());
        }
        Map<String, Object> result = this.findMemInCache(number, assoStorageNum, entityName, data);
        String code = (String)result.get("code");
        if (ResultCodeEnum.ERROR.getCode().equals(code)) {
            return Optional.of(result.get("msg").toString());
        }
        ImportBillData assoCacheMem = (ImportBillData)result.get("member");
        if (ResultCodeEnum.SUCCESS.getCode().equals(code) && assoCacheMem != null) {
            AssoImportSuccessSubscriber.addDependCtrlOrgListener(RowDataExtUtil.getId(bill), assoStorageNum, bill);
            return Optional.empty();
        } else {
            List<DynamicObject> dynamicObjects = PersistProxy.instance.listMemberByFilter(x -> {
                String assoLongnumber = x.getString("longnumber");
                String longnumber = data.getString("longnumber");
                return assoLongnumber.contains(longnumber + '!');
            });
            if (!CollectionUtils.isNotEmpty(dynamicObjects)) return Optional.of(ImportMsgUtils.notExistOfAssoMem());
            List<DynamicObject> assoDys = dynamicObjects.stream().filter(x -> assoStorageNum.equals(x.getString("number"))).filter(x -> x.getBoolean("isleaf")).filter(x -> !StorageTypeEnum.LABEL.getOIndex().equals(x.getString("storagetype"))).filter(x -> !StorageTypeEnum.DYNAMIC.getOIndex().equals(x.getString("storagetype"))).collect(Collectors.toList());
            if ("bcm_audittrialmembertree".equals(entityName)) {
                assoDys = assoDys.stream().filter(x -> x.getString("longnumber").contains("RptDS!")).filter(x -> StorageTypeEnum.STORAGE.getOIndex().equals(x.getString("storagetype"))).filter(x -> DataSourceEnum.REPORTENTRY.getOIndex().equals(x.getString("datasource"))).collect(Collectors.toList());
            }
            DynamicObject dynamicObject = null;
            if ("bcm_accountmembertree".equals(entityName) || "bcm_userdefinedmembertree".equals(entityName)) {
                String datatype = data.getString("datatype");
                if ("6".equals(datatype)) {
                    String enumDatatype = this.queryDatatypeOfEnum(data);
                    if ("-1".equals(enumDatatype)) {
                        return Optional.of(ImportMsgUtils.notExistEnumOfMem());
                    }
                    datatype = enumDatatype;
                }
                dynamicObject = this.filterDatatypeOfMem(assoDys, datatype);
            } else if (assoDys.size() > 0) {
                dynamicObject = (DynamicObject)assoDys.get(0);
            }
            if (dynamicObject == null) return Optional.of(ImportMsgUtils.notExistOfAssoMem());
            RowDataExtUtil.addAssoDy(bill, dynamicObject);
        }
        return Optional.empty();
    }

    private Map<String, Object> findMemInCache(String number, String assoStorageNum, String entityName, JSONObject data) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List<ImportBillData> assoCacheMems = ImportContextHolder.getAllWaitingImportData().stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getData().getString("longnumber")) && !x.getData().getString("longnumber").contains(assoStorageNum + '!')).filter(x -> StringUtils.isNotEmpty((CharSequence)x.getData().getString("longnumber")) && x.getData().getString("longnumber").contains(number + '!')).filter(x -> assoStorageNum.equals(ImportHelper.getImportBillProp(x, "number").toString())).filter(x -> !StorageTypeEnum.LABEL.getOIndex().equals(x.getData().getString("storagetype"))).filter(x -> !StorageTypeEnum.DYNAMIC.getOIndex().equals(x.getData().getString("storagetype"))).collect(Collectors.toList());
        if ("bcm_audittrialmembertree".equals(entityName)) {
            assoCacheMems = assoCacheMems.stream().filter(x -> x.getData().getString("longnumber").contains("RptDS!")).filter(x -> StorageTypeEnum.STORAGE.getOIndex().equals(x.getData().getString("storagetype"))).filter(x -> DataSourceEnum.REPORTENTRY.getOIndex().equals(x.getData().getString("datasource"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(assoCacheMems)) {
            if ("bcm_accountmembertree".equals(entityName) || "bcm_userdefinedmembertree".equals(entityName)) {
                ImportBillData importBillData;
                String datatype = data.getString("datatype");
                if ("6".equals(datatype)) {
                    String enumDatatype = this.queryDatatypeOfEnum(data);
                    if ("-1".equals(enumDatatype)) {
                        result.put("msg", ImportMsgUtils.notExistEnumOfMem());
                        result.put("code", ResultCodeEnum.ERROR.getCode());
                        result.put("member", null);
                        return result;
                    }
                    datatype = enumDatatype;
                }
                if ((importBillData = this.filterDatatypeOfCacheMem(assoCacheMems, datatype)) == null) {
                    result.put("msg", ImportMsgUtils.notExistSuitOfAssoMem());
                    result.put("code", ResultCodeEnum.CLASS_NOT_FOUND_EXCEPTION.getCode());
                    result.put("member", null);
                    return result;
                }
                result.put("msg", "");
                result.put("code", ResultCodeEnum.SUCCESS.getCode());
                result.put("member", importBillData);
                return result;
            }
            result.put("msg", "");
            result.put("code", ResultCodeEnum.SUCCESS.getCode());
            result.put("member", assoCacheMems.get(0));
            return result;
        }
        result.put("code", ResultCodeEnum.CLASS_NOT_FOUND_EXCEPTION.getCode());
        result.put("msg", ImportMsgUtils.notExistSuitOfAssoMem());
        result.put("member", null);
        return result;
    }

    private ImportBillData filterDatatypeOfCacheMem(List<ImportBillData> assoCacheMems, String datatype) {
        for (ImportBillData assoCacheMem : assoCacheMems) {
            String assoMemDt = assoCacheMem.getData().getString("datatype");
            if ("-1".equals(assoMemDt = this.setCodeValueReverse(assoMemDt))) {
                return null;
            }
            if ("6".equals(assoMemDt)) {
                String enumName = assoCacheMem.getData().getString("enumitem.name");
                Map<Object, DynamicObject> enumDts = this.queryAllEnumOfDim();
                Optional<DynamicObject> enumitem = enumDts.values().stream().filter(y -> enumName.equals(y.getString("name"))).findFirst();
                if (enumitem.isPresent()) {
                    assoMemDt = enumitem.get().getString("datatype");
                }
            }
            if ((!"0".equals(datatype) && !"1".equals(datatype) || !"0".equals(assoMemDt) && !"1".equals(assoMemDt)) && !datatype.equals(assoMemDt)) continue;
            return assoCacheMem;
        }
        return null;
    }

    private String setCodeValueReverse(String assoMemDt) {
        for (DataTypeEnum value : DataTypeEnum.values()) {
            if (!value.getName().equals(assoMemDt)) continue;
            return value.getOIndex();
        }
        return "-1";
    }

    private DynamicObject filterDatatypeOfMem(List<DynamicObject> assoMems, String datatype) {
        for (DynamicObject assoMem : assoMems) {
            String assoMemDt = assoMem.getString("datatype");
            if ("6".equals(assoMemDt)) {
                String enumName = assoMem.getString("enumitem.name");
                Map<Object, DynamicObject> enumDts = this.queryAllEnumOfDim();
                Optional<DynamicObject> enumitem = enumDts.values().stream().filter(y -> enumName.equals(y.getString("name"))).findFirst();
                if (enumitem.isPresent()) {
                    assoMemDt = enumitem.get().getString("datatype");
                }
            }
            if (!"0".equals(datatype) && !"1".equals(datatype) || !"0".equals(assoMemDt) && !"1".equals(assoMemDt)) continue;
            return assoMem;
        }
        return null;
    }

    private String queryDatatypeOfEnum(JSONObject data) {
        String enumName = ((JSONObject)data.get((Object)"enumitem")).getString("name");
        Map<Object, DynamicObject> datatypeDys = this.queryAllEnumOfDim();
        if (datatypeDys.size() > 0) {
            Optional<DynamicObject> enumitem = datatypeDys.values().stream().filter(x -> enumName.equals(x.getString("name"))).findFirst();
            return enumitem.get().getString("datatype");
        }
        return "-1";
    }

    private Map<Object, DynamicObject> queryAllEnumOfDim() {
        String dimNum = ImportContextHolder.getImportContext().getImportDimension().getString("number");
        String modelNum = ImportContextHolder.getImportContext().getImportModel().getString("number");
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("dimension", "=", (Object)dimensionId);
        return BusinessDataServiceHelper.loadFromCache((String)"bcm_enumitem", (String)"name, datatype", (QFilter[])qf.toArray());
    }
}

