/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.SilentJSONUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class CheckFieldNullValidator
extends AbstractDimensionImportValidator {
    private static volatile Predicate<Object> notNull = x -> Objects.nonNull(x);
    private static Pattern pattern = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9._-]*");

    @Override
    public Optional<String> validate(ImportBillData billData) {
        Object storageType;
        JSONObject data = billData.getData();
        if (!notNull.test(data.get("number"))) {
            return Optional.of(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u7a7a\uff01", (String)"CheckFieldNullValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!this.formatYes(data.get("number").toString())) {
            return Optional.of(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u8fde\u63a5\u7b26\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u8fde\u63a5\u7b26\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CheckFieldNullValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Object name = data.get("name");
        if (!notNull.test(data.get("name"))) {
            return Optional.of(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a\uff01", (String)"CheckFieldNullValidator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (name instanceof Map) {
            data.put("name", LocaleString.fromMap((Map)((Map)name)));
        } else {
            data.put("name", name.toString().trim());
        }
        if (!ImportContextHolder.getEntityName().equals("bcm_currencymembertree") && !notNull.test(SilentJSONUtils.cast(data.get("parent").toString(), LinkedHashMap.class).get("number"))) {
            return Optional.of(ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"CheckFieldNullValidator_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (ImportOperateType.NEW != ImportContextHolder.getImportType() && (storageType = data.get("storagetype")) != null && !notNull.test(storageType)) {
            return Optional.of(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CheckFieldNullValidator_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private boolean formatYes(String number) {
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            return false;
        }
        return !number.contains("..") && !number.startsWith(".");
    }
}

