/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.formplugin.dimension.DimensionCircleCheckAlgorithm;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class CircleValidator
extends AbstractDimensionImportValidator {
    private static final String SPLIT_CHAR = String.valueOf('!');

    @Override
    public Optional<String> validate(ImportBillData bill) {
        Optional<DynamicObject> parentOpt = RowDataExtUtil.getParent(bill);
        if (parentOpt.isPresent()) {
            Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
            String parentLongNumber = parentOpt.get().getString("longnumber");
            String number = ((String)bill.getData().get((Object)"number")).trim();
            if (existingDy.isPresent()) {
                String curMemLongNumber;
                Optional<String> conflictNumber;
                String newParentNum;
                String oldParentNum;
                long oldParentId = ImportHelper.getBaseDataIdCompatible(existingDy.get(), "parent");
                DynamicObject oldParentDy = PersistProxy.instance.getById(oldParentId, false);
                if (Objects.nonNull(oldParentDy) && !(oldParentNum = ImportHelper.getNumber(oldParentDy)).equals(newParentNum = ImportHelper.getImportBillProp(bill, "parent.number").toString()) && (conflictNumber = DimensionCircleCheckAlgorithm.check(curMemLongNumber = existingDy.get().getString("longnumber"), this.collectAllDescendantLongNumbers(existingDy.get().getLong("id")), parentLongNumber)).isPresent()) {
                    return Optional.of(ImportMsgUtils.existReferCircle(conflictNumber.get()));
                }
            } else {
                Optional<Object> conflictNumber = Optional.empty();
                if (!ImportHelper.isShareType((Map<String, Object>)bill.getData())) {
                    conflictNumber = DimensionCircleCheckAlgorithm.check(number, null, parentLongNumber);
                } else {
                    Optional<DynamicObject> storeMember = PersistProxy.instance.getNonShareMember(number, false);
                    String curMemLongNumber = storeMember.get().getString("longnumber");
                    Collection<String> descendantLongNums = this.collectAllDescendantLongNumbers(storeMember.get().getLong("id"));
                    conflictNumber = DimensionCircleCheckAlgorithm.check(curMemLongNumber, descendantLongNums, parentLongNumber);
                }
                if (conflictNumber.isPresent()) {
                    return Optional.of(ImportMsgUtils.existReferCircle((String)conflictNumber.get()));
                }
            }
        }
        return Optional.empty();
    }

    private Collection<String> collectAllDescendantLongNumbers(long memberId) {
        ArrayList<String> result = new ArrayList<String>(8);
        HashSet history = new HashSet(10);
        ArrayDeque<DynamicObject> memberQueue = new ArrayDeque<DynamicObject>(10);
        memberQueue.add(PersistProxy.instance.getById(memberId, false));
        while (!memberQueue.isEmpty()) {
            DynamicObject curMember = (DynamicObject)memberQueue.poll();
            result.add(curMember.getString("longnumber"));
            Collection<DynamicObject> childs = PersistProxy.instance.listChildMembers(curMember.getLong("id"));
            if (childs.isEmpty()) continue;
            childs.stream().forEach(x -> {
                if (history.add(x)) {
                    memberQueue.add((DynamicObject)x);
                }
            });
        }
        return result;
    }
}

