/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;
import org.apache.commons.lang.StringUtils;

public class DataFromValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData bill) {
        JSONObject data = bill.getData();
        Object datafrom = data.get((Object)"datafrom");
        Object ismerge = data.get((Object)"ismerge");
        if (ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"isCusConfigDataFromOfCT")) {
            String msg;
            String datafromStr;
            if (!data.keySet().contains("datafromnum")) {
                return Optional.of(ImportMsgUtils.noFindDataFromNum());
            }
            Object datafromnum = data.get((Object)"datafromnum");
            if (Objects.isNull(ismerge)) {
                return Optional.of(ImportMsgUtils.notNullOfIsMerge());
            }
            if (((Boolean)ismerge).booleanValue() && !Objects.isNull(datafromnum) && StringUtils.isNotEmpty((String)datafromnum.toString())) {
                return Optional.of(ImportMsgUtils.mustWuOfDataFromNumOpendIsMerge());
            }
            if (!((Boolean)ismerge).booleanValue() && StringUtils.isNotEmpty((String)(datafromStr = String.valueOf(datafromnum))) && StringUtils.isNotEmpty((String)(msg = this.checkFormatOfDataFromNum(datafromStr)))) {
                return Optional.of(msg);
            }
        } else if (!Objects.isNull(datafrom)) {
            if (Objects.isNull(ismerge)) {
                return Optional.of(ImportMsgUtils.notNullOfIsMerge());
            }
            if (((Boolean)ismerge).booleanValue() && !"0".equals(datafrom)) {
                return Optional.of(ImportMsgUtils.mustWuOfDataFromOpendIsMerge());
            }
        }
        return Optional.empty();
    }

    private String checkFormatOfDataFromNum(String datafromnum) {
        String message = "";
        String regEx = "^(?!_)[-a-zA-Z0-9.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(datafromnum);
        if (!matcher.matches()) {
            message = ResManager.loadKDString((String)"\u201c\u6570\u636e\u6765\u6e90\u4e8e\uff08\u81ea\u5b9a\u4e49\uff09\u201d\u7684\u503c\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed", (String)"ImportMsgUtils_128", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else if (datafromnum.contains("..") || datafromnum.startsWith(".") || datafromnum.startsWith("-")) {
            message = ResManager.loadKDString((String)"\u201c\u6570\u636e\u6765\u6e90\u4e8e\uff08\u81ea\u5b9a\u4e49\uff09\u201d\u7684\u503c\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed", (String)"ImportMsgUtils_128", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return message;
    }
}

