/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class DataIntegrationValidator
extends AbstractDimensionImportValidator {
    private Map<String, Boolean> olapDataMap = Maps.newConcurrentMap();

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public Optional<String> validate(ImportBillData bill) {
        String newParentNum;
        String oldParentNum;
        long oldParentId;
        DynamicObject oldParentDy;
        String oldStorageType;
        String newStorageType;
        Optional<DynamicObject> existingDy;
        Optional<DynamicObject> parent = RowDataExtUtil.getParent(bill);
        DimensionImportContext importContext = ImportContextHolder.getImportContext();
        String modelNum = importContext.getImportModel().getString("number");
        String dimNum = importContext.getImportDimension().getString("number");
        if (parent.isPresent()) {
            String parentNumber;
            boolean isHadChild;
            boolean bl = isHadChild = !PersistProxy.instance.listChildMembers(parent.get().getLong("id")).isEmpty();
            if (!isHadChild && this.checkMemberHasOlapData(modelNum, dimNum, parentNumber = ImportHelper.getNumber(parent.get()))) {
                return Optional.of(ImportMsgUtils.leafNodeAndHasOlapData());
            }
        }
        if ((existingDy = RowDataExtUtil.getExistingRecord(bill)).isPresent() && !(newStorageType = ImportHelper.getImportBillProp(bill, "storagetype").toString()).equals(oldStorageType = existingDy.get().getString("storagetype")) && StorageTypeEnum.LABEL.index.equals(newStorageType) && this.checkMemberHasOlapData(modelNum, dimNum, bill.getData().getString("number"))) {
            return Optional.of(ImportMsgUtils.prohibitSetLabelWhenHasData());
        }
        if (parent.isPresent() && existingDy.isPresent() && Objects.nonNull(oldParentDy = PersistProxy.instance.getById(oldParentId = ImportHelper.getBaseDataIdCompatible(existingDy.get(), "parent"), false)) && !(oldParentNum = ImportHelper.getNumber(oldParentDy)).equals(newParentNum = ImportHelper.getImportBillProp(bill, "parent.number").toString()) && this.checkMemberHasOlapData(modelNum, dimNum, bill.getData().getString("number"))) {
            return Optional.of(ImportMsgUtils.prohibitChangeParentWhenHasData());
        }
        return Optional.empty();
    }

    private boolean checkMemberHasOlapData(String modelNum, String dimNum, String number) {
        if (!this.olapDataMap.containsKey(number)) {
            this.olapDataMap.put(number, OlapServiceHelper.hasOlapData((String)modelNum, (List)Lists.newArrayList((Object[])new String[]{number}), (String)dimNum));
        }
        return this.olapDataMap.get(number);
    }
}

