/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class DynamicSettingValidator
extends AbstractDimensionImportValidator {
    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public Optional<String> validate(ImportBillData billData) {
        Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(billData);
        JSONObject data = billData.getData();
        List<ImportBillData> allWaiting = ImportContextHolder.getAllWaitingImportData();
        boolean isLeafOfExcel = true;
        for (ImportBillData importBillData : allWaiting) {
            JSONObject parent = (JSONObject)importBillData.getData().get((Object)"parent");
            if (parent == null || !data.get("number").equals(parent.getString("number"))) continue;
            isLeafOfExcel = false;
        }
        if (existingDy.isPresent() ? isLeafOfExcel && existingDy.get().getBoolean("isleaf") && data.get("storagetype").equals(StorageTypeEnum.DYNAMIC.index) : isLeafOfExcel && data.get("storagetype").equals(StorageTypeEnum.DYNAMIC.index)) {
            return Optional.of(ImportMsgUtils.leafNodeShouldNotDynamic());
        }
        return Optional.empty();
    }
}

