/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.enums.AccountDataTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class EnumAndDataTypeValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData bill) {
        int newAgg;
        Object aggObj;
        int dataType;
        JSONObject billData = bill.getData();
        if (!billData.containsKey("datatype")) {
            return Optional.empty();
        }
        String dataTypeStr = ImportHelper.getImportBillProp(bill, "datatype").toString();
        int n = dataType = StringUtils.isEmpty((CharSequence)dataTypeStr) ? 0 : Integer.parseInt(dataTypeStr);
        if (AccountDataTypeEnum.ENUM.getIndex() == dataType) {
            String enumValueName = ImportHelper.getImportBillProp(bill, "enumitem.name").toString();
            if (StringUtils.isEmpty((CharSequence)enumValueName)) {
                return Optional.of(ImportMsgUtils.enumTypeError());
            }
            Optional<Long> enumId = BatchImportReadOnlyCache.mapEnumToId(this.getModelId(), enumValueName);
            if (!enumId.isPresent()) {
                return Optional.of(ImportMsgUtils.invalidEnumError(enumValueName));
            }
            RowDataExtUtil.addValue(bill, enumId.get());
        } else if (AccountDataTypeEnum.DATE.getIndex() == dataType && (aggObj = bill.getData().get((Object)"aggoprt")) != null && StringUtils.isNotEmpty((CharSequence)aggObj.toString()) && (newAgg = Integer.parseInt(aggObj.toString())) >= 1 && newAgg <= 4) {
            return Optional.of(ImportMsgUtils.dateTypeError());
        }
        return Optional.empty();
    }
}

