/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class MemberNumExistValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData billData) {
        if (ImportOperateType.NEW == ImportContextHolder.getImportType()) {
            if (this.isExitMemberNumber(billData)) {
                return Optional.of(ImportMsgUtils.existNumber());
            }
            String entityName = ImportContextHolder.getEntityName();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            if (RowDataExtUtil.checkNumberLength(dataEntityType, billData)) {
                return Optional.of(ImportMsgUtils.tooLongOfNumber());
            }
        } else if (ImportOperateType.OVERRIDE == ImportContextHolder.getImportType() && !this.isExitMemberNumber(billData)) {
            return Optional.of(ImportMsgUtils.notExistOverrideMember());
        }
        return Optional.empty();
    }

    private boolean isExitMemberNumber(ImportBillData bill) {
        JSONObject data = bill.getData();
        if (ImportHelper.isShareType((Map<String, Object>)data)) {
            return RowDataExtUtil.getExistingRecord(bill).isPresent();
        }
        Object number = data.get("number");
        return PersistProxy.instance.listAllNonShareMemberNumbers().contains(number.toString().toLowerCase(Locale.ENGLISH));
    }
}

