/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class PageHasPermClassAllowInValidator
extends AbstractDimensionImportValidator {
    @Override
    public int getWeight() {
        return 50;
    }

    @Override
    public Optional<String> validate(ImportBillData bill) {
        JSONObject data = bill.getData();
        String permClassNumber = String.valueOf(data.get("sectoryclass"));
        if (StringUtils.isEmpty((String)permClassNumber) || data.get("sectoryclass") == null || StorageTypeEnum.SHARE.index.equals(data.get("storagetype"))) {
            return Optional.empty();
        }
        DynamicObject modelNumberClassEntity = BatchImportReadOnlyCache.getPermClass(permClassNumber, this.getModelId());
        if (modelNumberClassEntity == null) {
            return Optional.of(ImportMsgUtils.importInvalidPermClass());
        }
        return Optional.empty();
    }
}

