/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;
import org.apache.commons.lang.StringUtils;

public class PropertyValueValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData billData) {
        DimensionImportContext context = ImportContextHolder.getImportContext();
        if (!context.isBGMD() && !context.isEPMapp() || !"bcm_entitymembertree".equals(context.getEntityName()) || ImportOperateType.NEW != context.getImportType()) {
            return this.checkPropertyValueNewVersion(billData);
        }
        return Optional.empty();
    }

    private Optional<String> checkPropertyValueNewVersion(ImportBillData bill) {
        JSONObject billData = bill.getData();
        HashMap<String, Pair<Integer, Long>> definedPropSeqIdMap = new HashMap<String, Pair<Integer, Long>>(3);
        for (Map.Entry entry : billData.entrySet()) {
            String propValue;
            String colName = (String)entry.getKey();
            if (!ExportUtil.isValueDefinedPropertyColumnName((String)colName)) continue;
            String definedProperty = ExportUtil.extractDefinedPropertyName((String)colName);
            Optional<Pair<Integer, Long>> definedPropId = ImportContextHolder.getDefinedProperty(definedProperty, propValue = Objects.isNull(entry.getValue()) || StringUtils.isEmpty((String)entry.getValue().toString()) ? "" : entry.getValue().toString().trim(), this.getModelId(), this.getDimensionId());
            if (!definedPropId.isPresent()) {
                return Optional.of(ImportMsgUtils.noSpecificDefinedPropExists(definedProperty, propValue));
            }
            definedPropSeqIdMap.put(definedProperty, definedPropId.get());
        }
        RowDataExtUtil.addDefinedProps(bill, definedPropSeqIdMap);
        return Optional.empty();
    }
}

