/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class ShareMemberValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData bill) {
        JSONObject billData = bill.getData();
        if (ImportHelper.isShareType((Map<String, Object>)billData)) {
            Object aggObj = bill.getData().get((Object)"aggoprt");
            if (aggObj == null || aggObj.toString().trim().equals("")) {
                return Optional.of(ImportMsgUtils.noSpecificAggAlgorithm());
            }
            int newAgg = Integer.parseInt(aggObj.toString());
            if (newAgg < 1 || newAgg > 6) {
                return Optional.of(ImportMsgUtils.wrongAggAlgorithm(newAgg));
            }
            Optional<DynamicObject> parent = RowDataExtUtil.getParent(bill);
            if (StorageTypeEnum.UNSHARE.index.equals(parent.get().getString("storagetype"))) {
                return Optional.of(ImportMsgUtils.parentMemberIsNonShareType());
            }
            String memNumber = bill.getData().getString("number");
            Optional<DynamicObject> storeMemberDy = PersistProxy.instance.getNonShareMember(memNumber, false);
            if (!storeMemberDy.isPresent()) {
                return Optional.of(ImportMsgUtils.sourceMemberNotExistOrNonShareType());
            }
            String sourceStorageType = storeMemberDy.get().getString("storagetype");
            if (ImportHelper.NOT_PERMIT_SHARED_TYPES.contains(sourceStorageType)) {
                return Optional.of(ImportMsgUtils.sourceMemberNotExistOrNonShareType());
            }
            DimensionImportContext context = ImportContextHolder.getImportContext();
            switch (context.getImportType()) {
                case OVERRIDE: {
                    Optional<DynamicObject> sourceMember = RowDataExtUtil.getExistingRecord(bill);
                    if (sourceMember.isPresent()) break;
                    return Optional.of(ImportMsgUtils.sourceMemberNotExistOrNonShareType());
                }
                case OVERRIDENEW: {
                    break;
                }
            }
        }
        return Optional.empty();
    }
}

