/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class ShieldRuleContentValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData billData) {
        Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(billData);
        JSONObject data = billData.getData();
        Object shieldDim = data.get("shielddim");
        if (existingDy.isPresent()) {
            if (shieldDim != null) {
                Set<String> excelDimShortNumberSet;
                String storageType = (String)data.get("storagetype");
                if (StorageTypeEnum.SHARE.index.equals(storageType)) {
                    return Optional.empty();
                }
                if (StorageTypeEnum.DYNAMIC.index.equals(storageType) || StorageTypeEnum.LABEL.index.equals(storageType)) {
                    return Optional.of(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7684\u52a8\u6001\u8ba1\u7b97\u6216\u6807\u7b7e\u7c7b\u578b\u4e0d\u53ef\u8bbe\u7f6e\u201c\u4e0d\u53ef\u6267\u884c\u52a8\u6001\u8ba1\u7b97\u7ef4\u5ea6\u201d\u3002", (String)"ShieldRuleContentValidator_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                Set<String> systemDimShortNumberSet = this.getSystemHasDims();
                if (!systemDimShortNumberSet.containsAll(excelDimShortNumberSet = ShieldRuleContentValidator.excelDimsFormatFilter(shieldDim, this.getModelId(), this.getDimensionId()))) {
                    return Optional.of(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7b80\u7801\u4e0d\u5b58\u5728\u3002", (String)"ShieldRuleContentValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (shieldDim != null) {
            return Optional.of(ResManager.loadKDString((String)"\u4e0d\u53ef\u6267\u884c\u52a8\u6001\u8ba1\u7b97\u5b57\u6bb5\u4ec5\u652f\u6301\u8986\u76d6\u4fee\u6539\uff0c\u4e0d\u652f\u6301\u65b0\u589e\u3002", (String)"ShieldRuleContentValidator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    public static Set<String> excelDimsFormatFilter(Object shieldDim, Object modelId, long dimId) {
        String[] dimArr = ((String)shieldDim).split(",");
        HashSet<String> dimSet = new HashSet<String>(Arrays.asList(dimArr));
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Map shortNum2Num = MemberReader.getDimensionShortNumber2NumberMap((String)modelNumber);
        HashBiMap shortNumAndNum = HashBiMap.create((Map)shortNum2Num);
        String thisDimShortNumber = (String)shortNumAndNum.inverse().get((Object)MemberReader.getDimensionNumById((long)dimId));
        dimSet.remove(thisDimShortNumber);
        return dimSet;
    }

    private Set<String> getSystemHasDims() {
        String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        return MemberReader.getDimensionShortNumber2NumberMap((String)modelNumber).keySet();
    }
}

