/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class SupportValidator
extends AbstractDimensionImportValidator {
    private static final Set<String> canAddShareDim = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"bcm_entitymembertree", "bcm_accountmembertree", "bcm_changetypemembertree", "bcm_userdefinedmembertree"}));

    @Override
    public Optional<String> validate(ImportBillData billData) {
        DimensionImportContext context = ImportContextHolder.getImportContext();
        String dataNumber = billData.getData().getString("number");
        ImportOperateType importType = context.getImportType();
        if ("bcm_entitymembertree".equals(context.getEntityName()) && ImportOperateType.NEW != importType && ImportOperateType.OVERRIDE != importType) {
            return Optional.of(ImportMsgUtils.orgOnlySupportNewAndOverride());
        }
        if (ImportOperateType.NEW != importType && "bcm_accountmembertree".equals(context.getEntityName()) && "Account".equals(dataNumber)) {
            return Optional.of(ImportMsgUtils.rootNodeNotSupportOverrideImport());
        }
        if ("bcm_changetypemembertree".equals(context.getEntityName()) && MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this.getModelId())) && "ChangeType".equals(dataNumber)) {
            return Optional.of(ImportMsgUtils.rootNodeNotSupportOverrideImport());
        }
        boolean canShare = canAddShareDim.contains(context.getEntityName());
        if (!canShare && ImportHelper.isShareType((Map<String, Object>)billData.getData())) {
            return Optional.of(ImportMsgUtils.curDimensionNotSupportShareMem());
        }
        return Optional.empty();
    }
}

