/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.common;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class SystemMemberValidator
extends AbstractDimensionImportValidator {
    private static Set<String> DISABLE_OVERRIDE_ENTITIES = null;
    private static Set<String> DISABLE_ADDCHILD_ENTITIES;

    @Override
    public Optional<String> validate(ImportBillData bill) {
        Optional<DynamicObject> parent;
        Optional<DynamicObject> existingRecord;
        String entityName = ImportContextHolder.getEntityName();
        if (DISABLE_OVERRIDE_ENTITIES.contains(entityName) && (existingRecord = RowDataExtUtil.getExistingRecord(bill)).isPresent() && this.isSysMember(existingRecord.get())) {
            return Optional.of(ImportMsgUtils.isSysMember());
        }
        if (DISABLE_ADDCHILD_ENTITIES.contains(entityName) && (parent = RowDataExtUtil.getParent(bill)).isPresent() && this.isSysMember(parent.get()) && parent.get().getBoolean("isleaf")) {
            return Optional.of(ImportMsgUtils.notAllowAppendChildForSysMember());
        }
        return Optional.empty();
    }

    private boolean isSysMember(DynamicObject existingRecord) {
        return DimMemTypeEnum.SYSMEM.getIndex() == existingRecord.getInt("issysmember");
    }

    static {
        DISABLE_OVERRIDE_ENTITIES = new HashSet<String>(3);
        DISABLE_OVERRIDE_ENTITIES.add("bcm_changetypemembertree");
        DISABLE_OVERRIDE_ENTITIES.add("bcm_audittrialmembertree");
        DISABLE_OVERRIDE_ENTITIES.add("bcm_currencymembertree");
        DISABLE_OVERRIDE_ENTITIES.add("bcm_structofextend");
        DISABLE_ADDCHILD_ENTITIES = null;
        DISABLE_ADDCHILD_ENTITIES = new HashSet<String>(2);
        DISABLE_ADDCHILD_ENTITIES.add("bcm_changetypemembertree");
        DISABLE_ADDCHILD_ENTITIES.add("bcm_audittrialmembertree");
    }
}

