/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.defaultvalue;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.defaultValue.DefaultValueDBCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class DefaultValueImportValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData bill) {
        IDNumberTreeNode memberDy;
        DynamicObject model = ImportContextHolder.getImportContext().getImportModel();
        long modelId = model.getLong("id");
        String modelNumber = model.getString("number");
        JSONObject data = bill.getData();
        String dimensionnum = data.getString("dimensionnum");
        DynamicObject dimDy = (DynamicObject)MemberReader.getDimDyoByModelId((long)modelId).get(dimensionnum);
        if (dimDy == null) {
            return Optional.of(ImportMsgUtils.notExistOfDimNum());
        }
        String usedinmenu = data.getString("usedinmenu");
        DynamicObject defaultValue = DefaultValueDBCache.getDBBatchCacheOfDefaultValue(modelId).getDefaultValue(dimensionnum, usedinmenu);
        if (ImportOperateType.NEW == ImportContextHolder.getImportContext().getImportType() && defaultValue != null && RequestContext.get().getCurrUserId() == this.getCreateId(defaultValue)) {
            return Optional.of(ImportMsgUtils.existDefaultValueOfModel());
        }
        if (ImportOperateType.OVERRIDE == ImportContextHolder.getImportContext().getImportType() && (defaultValue == null || RequestContext.get().getCurrUserId() != this.getCreateId(defaultValue))) {
            return Optional.of(ImportMsgUtils.notExistDefaultValueOfModel());
        }
        String longnumber = data.getString("longnumber");
        String defaultnumber = data.getString("defaultnumber");
        if (StringUtils.isNotEmpty((CharSequence)longnumber)) {
            String[] nums = longnumber.split("!");
            if (!nums[nums.length - 1].equals(defaultnumber)) {
                return Optional.of(ImportMsgUtils.noEqualOfLongnumberAndNum());
            }
            memberDy = MemberReader.findMemberByLongNumber((String)modelNumber, (String)dimensionnum, (String)longnumber);
            if (memberDy == IDNumberTreeNode.NotFoundTreeNode) {
                return Optional.of(ImportMsgUtils.notExistMemByLongnumber());
            }
            if ("bcm_adjustoffset_entry".equals(usedinmenu) && !SysDimensionEnum.Entity.getNumber().equals(dimensionnum) && !memberDy.isLeaf()) {
                return Optional.of(ImportMsgUtils.notChoiseNonLeafNode());
            }
        } else {
            Optional<IDNumberTreeNode> memberOp = MemberReader.getAllNodeByDimNum((String)dimensionnum, (String)modelNumber).stream().filter(x -> !"3".equals(x.getStorageType().getOIndex()) && defaultnumber.equals(x.getNumber())).findFirst();
            if (!memberOp.isPresent()) {
                return Optional.of(ImportMsgUtils.notExistStoMemBynumber());
            }
            memberDy = memberOp.get();
            if ("bcm_adjustoffset_entry".equals(usedinmenu) && !SysDimensionEnum.Entity.getNumber().equals(dimensionnum) && !memberDy.isLeaf()) {
                return Optional.of(ImportMsgUtils.notChoiseNonLeafNode());
            }
        }
        data.put("defaultvalue", (Object)memberDy.getName());
        data.put("defaultvalueid", (Object)memberDy.getId());
        return Optional.empty();
    }

    private long getCreateId(DynamicObject dy) {
        if (dy == null) {
            return 0L;
        }
        Object creatorid = dy.get("creatorid");
        return creatorid instanceof DynamicObject ? ((DynamicObject)creatorid).getLong("id") : Long.parseLong(creatorid.toString());
    }
}

