/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.extend;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.ExtDimensionHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.SilentJSONUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;
import org.apache.commons.collections.CollectionUtils;

public class ExtendsCommonValidator
extends AbstractDimensionImportValidator {
    private static final String EXTFIELD_NUM = "ExtField_Num";
    private static final String EXTFIELD_TEXT = "ExtField_Text";
    private static final String EXTFIELD_DATE = "ExtField_Date";
    private static final String textPrefix = "textext";
    private static final String numPrefix = "numext";
    private static final String datePrefix = "dateext";
    private static String NUMBER_MARK = "number";
    private static String PID_MARK = "pid";
    private static String ID_MARK = "id";
    private static String DIM_MARK = "dimId";
    private static String SCOPE_MARK = "scope";
    private static String LEFT_BRACKETS = "(";
    private static String RIGHT_BRACKETS = ")";

    @Override
    public Optional<String> validate(ImportBillData bill) {
        String permNumber;
        DynamicObject modelNumberClassEntity;
        JSONObject data = bill.getData();
        Long dimId = ImportContextHolder.getImportContext().getImportDimension().getLong("id");
        String modelSNum = MemberReader.findModelSNumberById((Object)this.getModelId());
        String number = data.get("number").toString();
        String longnumber = data.get("longnumber").toString();
        String parentNum = SilentJSONUtils.cast(data.get("parent").toString(), LinkedHashMap.class).get("number").toString();
        String datatype = String.valueOf(data.get("datatype"));
        String[] longSplits = longnumber.split(String.valueOf('!'));
        if (longSplits.length < 2 || longSplits.length > 3) {
            return Optional.of(ImportMsgUtils.longnumberFormatIllegal());
        }
        if (!number.equals(longSplits[longSplits.length - 1])) {
            return Optional.of(ImportMsgUtils.longnumberOfNumFormatIllegal());
        }
        if (!parentNum.equals(longSplits[longSplits.length - 2])) {
            return Optional.of(ImportMsgUtils.longnumberOfParNumFormatIllegal());
        }
        String entityName = ImportContextHolder.getEntityName();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (RowDataExtUtil.checkNumberLength(dataEntityType, bill)) {
            return Optional.of(ImportMsgUtils.tooLongOfNumber());
        }
        if (longSplits.length == 2) {
            if (!"1".equals(data.get("storagetype").toString())) {
                return Optional.of(ImportMsgUtils.bizStoreTypeFormatIllegal());
            }
            if (!"3".equals(data.get("datatype").toString())) {
                return Optional.of(ImportMsgUtils.bizDatatypeFormatIllegal());
            }
            if (Objects.isNull(data.get("grouptype"))) {
                return Optional.of(ImportMsgUtils.groupTypeIllegal());
            }
        } else if (!"2".equals(data.get("storagetype").toString())) {
            return Optional.of(ImportMsgUtils.fieldStoreTypeFormatIllegal());
        }
        if (data.get("permclass") != null && !StringUtils.isEmpty((String)String.valueOf(data.get("permclass"))) && (modelNumberClassEntity = BatchImportReadOnlyCache.getPermClass(permNumber = SilentJSONUtils.cast(data.get("permclass").toString(), LinkedHashMap.class).get("number").toString(), this.getModelId())) == null) {
            return Optional.of(ImportMsgUtils.importInvalidPermClass());
        }
        if (data.get("enumitem") != null && StringUtils.isNotEmpty((String)String.valueOf(String.valueOf(data.get("permclass"))))) {
            String enumName = SilentJSONUtils.cast(data.get("enumitem").toString(), LinkedHashMap.class).get("name").toString();
            modelNumberClassEntity = BatchImportReadOnlyCache.getEnumItem(enumName, dimId);
            if (modelNumberClassEntity == null) {
                return Optional.of(ImportMsgUtils.importInvalidEnumItem());
            }
        } else if ("6".equals(datatype)) {
            return Optional.of(ImportMsgUtils.importInvalidEnumItemValue());
        }
        long memId = Long.parseLong(data.get("id").toString());
        if (longSplits.length == 3) {
            Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
            if (existingDy.isPresent()) {
                DynamicObject dynamicObject = existingDy.get();
                String oldDatatype = dynamicObject.getString("datatype");
                if (!datatype.equals(oldDatatype)) {
                    if ("6".equals(datatype)) {
                        String enumName = SilentJSONUtils.cast(data.get("enumitem").toString(), LinkedHashMap.class).get("name").toString();
                        datatype = BatchImportReadOnlyCache.getEnumItem(enumName, dimId).getString("datatype");
                    }
                    List<DynamicObject> shareMembers = PersistProxy.instance.listShareMembers(ImportHelper.getNumber(dynamicObject));
                    for (DynamicObject shareMember : shareMembers) {
                        String shareParNum;
                        long shareId = shareMember.getLong("id");
                        if (this.checkMaxMappingField(datatype, shareId, shareParNum = shareMember.getString("parent.number"), dimId)) continue;
                        return Optional.of(ImportMsgUtils.importOverstepMaxLimitOfShare());
                    }
                    if (!this.checkMaxMappingField(datatype, memId, parentNum, dimId)) {
                        return Optional.of(ImportMsgUtils.importOverstepMaxLimit());
                    }
                    if (this.checkHavedData((Map<String, Object>)data)) {
                        return Optional.of(ImportMsgUtils.importInvalidDatatype());
                    }
                }
            } else if (longSplits.length == 3) {
                String fieldName;
                if ("6".equals(datatype)) {
                    String enumName = SilentJSONUtils.cast(data.get("enumitem").toString(), LinkedHashMap.class).get("name").toString();
                    datatype = BatchImportReadOnlyCache.getEnumItem(enumName, dimId).getString("datatype");
                }
                if (!this.checkMaxMappingField(datatype, memId, parentNum, dimId)) {
                    return Optional.of(ImportMsgUtils.importOverstepMaxLimit());
                }
                DynamicObject parGroupType = PersistProxy.instance.batchGetNonShareMember(Collections.singletonList(parentNum)).get(0);
                if (ThreadCache.get((Object)dimId) != null && ((Map)ThreadCache.get((Object)dimId)).get(memId) != null && !ExtDimensionHelper.checkIsExistOfField((String)(fieldName = (String)((Map)ThreadCache.get((Object)dimId)).get(memId)), (String)parGroupType.getString("grouptype"))) {
                    return Optional.of(ImportMsgUtils.fieldNameIsNull());
                }
            }
        }
        if (longSplits.length == 3) {
            ArrayList<Map<String, String>> assoDimMems = new ArrayList<Map<String, String>>(10);
            String msg = this.checkAssoDimMember((Map<String, Object>)data, assoDimMems);
            if (StringUtils.isNotEmpty((String)msg)) {
                return Optional.of(msg);
            }
            Optional<DynamicObject> existingDy = RowDataExtUtil.getExistingRecord(bill);
            if (existingDy.isPresent() && ExtDataUtil.compareAssoDimMembers(assoDimMems, (DynamicObject)existingDy.get())) {
                List<Long> id = Collections.singletonList(existingDy.get().getLong("id"));
                List<String> num = Collections.singletonList(existingDy.get().getString("number"));
                boolean existDataOfExt = ExtDataServiceHelper.isExistDataOfExt((String)modelSNum, id, (DynamicObject)RowDataExtUtil.getParent(bill).get());
                boolean existDataOfInvestExtMem = ExtDataServiceHelper.isExistDataOfInvestExtMem((String)modelSNum, (String)"", num);
                if (existDataOfExt || existDataOfInvestExtMem) {
                    return Optional.of(ImportMsgUtils.haveDataOfExtMember());
                }
            }
            if (assoDimMems.size() > 0) {
                RowDataExtUtil.addExtObject(bill, assoDimMems, "assodimmember");
            }
        }
        return Optional.empty();
    }

    private String checkAssoDimMember(Map<String, Object> data, List<Map<String, String>> assoDimMems) {
        Object assodimension = data.get("assodimension");
        Object assomember = data.get("assomember");
        if (assodimension != null && assomember == null || assodimension == null && assomember != null) {
            return ImportMsgUtils.notNullAssoMem();
        }
        if (!Objects.isNull(assodimension)) {
            JSONObject jsonDim = (JSONObject)assodimension;
            String dimNum = (String)jsonDim.get((Object)"number");
            Long assoDimId = MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)dimNum);
            if (assoDimId == null) {
                return ImportMsgUtils.notExtAssoDim();
            }
            if (ExtDataUtil.exceptDims.contains(dimNum)) {
                return ImportMsgUtils.notAllowedAssoDim();
            }
            String jsonMem = (String)assomember;
            String[] split = jsonMem.split(";");
            if (split.length > 0) {
                for (String memberComb : split) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    if (StringUtils.isEmpty((String)memberComb)) continue;
                    if (memberComb.contains(":")) {
                        String[] dproCombs = memberComb.split(":");
                        if (dproCombs.length != 2) {
                            return ImportMsgUtils.formatErrorOfDpro();
                        }
                        List<DynamicObject> dPropertys = BatchImportReadOnlyCache.getDPropertys(dproCombs[0], assoDimId);
                        if (CollectionUtils.isEmpty(dPropertys)) {
                            return ImportMsgUtils.notExistDpro();
                        }
                        List enumvalues = dPropertys.stream().filter(x -> dproCombs[1].equals(x.getString("number"))).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(enumvalues)) {
                            return ImportMsgUtils.notExistDproValue();
                        }
                        DynamicObject enumValue = (DynamicObject)enumvalues.get(0);
                        map.put(NUMBER_MARK, enumValue.getString("number"));
                        map.put(ID_MARK, enumValue.getString("id"));
                        map.put(PID_MARK, enumValue.getString("propertyid.id"));
                        map.put(SCOPE_MARK, "10");
                    } else {
                        IDNumberTreeNode memberByNumber;
                        String memberNum = memberComb;
                        String scope = "";
                        if (memberComb.contains(LEFT_BRACKETS) && memberComb.contains(RIGHT_BRACKETS)) {
                            memberNum = memberComb.substring(memberComb.indexOf(LEFT_BRACKETS) + 1, memberComb.indexOf(RIGHT_BRACKETS));
                            scope = this.getScopeInt(memberComb.substring(0, memberComb.indexOf(LEFT_BRACKETS)));
                        }
                        if ((memberByNumber = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)dimNum, (String)memberNum)) == IDNumberTreeNode.NotFoundTreeNode) {
                            return ImportMsgUtils.notExistMemberOfAssoMem();
                        }
                        map.put(NUMBER_MARK, memberByNumber.getNumber());
                        map.put(ID_MARK, String.valueOf(memberByNumber.getId()));
                        map.put(PID_MARK, "");
                        map.put(SCOPE_MARK, StringUtils.isEmpty((String)scope) ? "10" : scope);
                    }
                    map.put(DIM_MARK, String.valueOf(assoDimId));
                    assoDimMems.add(map);
                }
            }
        }
        return "";
    }

    private String getScopeInt(String scopeStr) {
        String scope = "";
        switch (scopeStr) {
            case "Child": {
                scope = "20";
                break;
            }
            case "Ichild": {
                scope = "30";
                break;
            }
            case "Descendant": {
                scope = "40";
                break;
            }
            case "Hierarchy": {
                scope = "50";
                break;
            }
            case "Sibling": {
                scope = "60";
                break;
            }
            case "Isibling": {
                scope = "70";
                break;
            }
            case "Base": {
                scope = "90";
                break;
            }
        }
        return scope;
    }

    private boolean checkHavedData(Map<String, Object> data) {
        long memId = Long.parseLong(data.get("id").toString());
        String number = data.get("number").toString();
        String shownumber = ImportContextHolder.getImportContext().getImportModel().getString("shownumber");
        boolean existDataOfExt = ExtDataServiceHelper.isExistDataOfExt((String)shownumber, Collections.singletonList(memId), (DynamicObject)((DynamicObject)data.get("extparent")));
        boolean existDataOfInvestExtMem = ExtDataServiceHelper.isExistDataOfInvestExtMem((String)shownumber, (String)"", Collections.singletonList(number));
        return existDataOfExt || existDataOfInvestExtMem;
    }

    private boolean checkMaxMappingField(String datatype, long id, String parentNum, long dimId) {
        List dataFieldArray = new ArrayList();
        List<String> txts = new ArrayList(16);
        List<String> nums = new ArrayList(16);
        List<String> dates = new ArrayList(16);
        HashMap<Long, String> id2Mapping = new HashMap<Long, String>(16);
        id2Mapping = ThreadCache.get((Object)dimId) != null ? (Map)ThreadCache.get((Object)dimId) : id2Mapping;
        String type = "";
        DynamicObject parGroupType = PersistProxy.instance.batchGetNonShareMember(Collections.singletonList(parentNum)).get(0);
        String grouptype = parGroupType.getString("grouptype");
        if ("3".equals(grouptype)) {
            id2Mapping.put(id, "");
            return true;
        }
        Integer numMax = 0;
        Integer textMax = 0;
        Integer dateMax = 0;
        Tuple tuple = ExtDimensionHelper.getTypeDataByGroupType((Integer)numMax, (Integer)textMax, (Integer)dateMax, (String)grouptype);
        numMax = (Integer)tuple.p1;
        textMax = (Integer)tuple.p2;
        dateMax = (Integer)tuple.p3;
        List<DynamicObject> childDy = BatchImportReadOnlyCache.getDatatype(dimId, parentNum);
        ArrayList<String> dataTypeEnums = new ArrayList<String>(16);
        if (datatype.equals(DataTypeEnum.TXT.getOIndex())) {
            dataTypeEnums.add(DataTypeEnum.TXT.getOIndex());
            dataFieldArray = ExtDataServiceHelper.getSQLFieldArray((String)textPrefix, (int)textMax);
            type = EXTFIELD_TEXT;
        } else if (datatype.equals(DataTypeEnum.CURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || datatype.equals(DataTypeEnum.PROPORTION.getOIndex()) || datatype.equals(DataTypeEnum.DEFAULT.getOIndex())) {
            dataTypeEnums.addAll(Arrays.asList(DataTypeEnum.CURRENCY.getOIndex(), DataTypeEnum.UNCURRENCY.getOIndex(), DataTypeEnum.PROPORTION.getOIndex(), DataTypeEnum.DEFAULT.getOIndex()));
            dataFieldArray = ExtDataServiceHelper.getSQLFieldArray((String)numPrefix, (int)numMax);
            type = EXTFIELD_NUM;
        } else if (datatype.equals(DataTypeEnum.DATETP.getOIndex())) {
            dataTypeEnums.add(DataTypeEnum.DATETP.getOIndex());
            dataFieldArray = ExtDataServiceHelper.getSQLFieldArray((String)datePrefix, (int)dateMax);
            type = EXTFIELD_DATE;
        }
        List<Object> results = null;
        results = childDy == null ? new ArrayList(0) : childDy.stream().filter(x -> dataTypeEnums.contains(x.getString("datatype")) || dataTypeEnums.contains(x.getString("enumitem.datatype"))).collect(Collectors.toList());
        List fieldmapped = results.stream().map(x -> (String)x.get("fieldmapped")).collect(Collectors.toList());
        List<DynamicObject> enumDatatypes = BatchImportReadOnlyCache.getEnumDatatype(dimId);
        List<Object> enumDatas = null;
        enumDatas = childDy != null ? childDy.stream().filter(out -> enumDatatypes.stream().anyMatch(in -> out.getLong("enumitem.id") == in.getLong("id"))).filter(dt -> dataTypeEnums.contains(dt.getString("enumitem.datatype"))).collect(Collectors.toList()) : new ArrayList(0);
        int sum = results.size();
        if (enumDatas != null && enumDatas.size() > 0) {
            sum += enumDatas.size();
            fieldmapped.addAll(enumDatas.stream().map(x -> (String)x.get("fieldmapped")).collect(Collectors.toList()));
        }
        Object texts = ThreadCache.get((Object)(dimId + parentNum + "txts"));
        Object numes = ThreadCache.get((Object)(dimId + parentNum + "nums"));
        Object dat = ThreadCache.get((Object)(dimId + parentNum + "dates"));
        if (texts != null) {
            txts = (List)texts;
        }
        if (numes != null) {
            nums = (List)numes;
        }
        if (dat != null) {
            dates = (List)dat;
        }
        if (EXTFIELD_TEXT.equals(type)) {
            fieldmapped.addAll(txts);
            if ((sum += txts.size()) >= textMax) {
                return false;
            }
            for (int i = 1; i <= dataFieldArray.size(); ++i) {
                if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                id2Mapping.put(id, textPrefix + i);
                txts.add(textPrefix + i);
                break;
            }
        } else if (EXTFIELD_NUM.equals(type)) {
            fieldmapped.addAll(nums);
            if ((sum += nums.size()) >= numMax) {
                return false;
            }
            for (int i = 1; i <= dataFieldArray.size(); ++i) {
                if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                id2Mapping.put(id, numPrefix + i);
                nums.add(numPrefix + i);
                break;
            }
        } else if (EXTFIELD_DATE.equals(type)) {
            fieldmapped.addAll(dates);
            if ((sum += dates.size()) >= dateMax) {
                return false;
            }
            for (int i = 1; i <= dataFieldArray.size(); ++i) {
                if (fieldmapped.contains(dataFieldArray.get(i - 1))) continue;
                id2Mapping.put(id, datePrefix + i);
                dates.add(datePrefix + i);
                break;
            }
        }
        ThreadCache.put((Object)dimId, id2Mapping);
        ThreadCache.put((Object)(dimId + parentNum + "txts"), txts);
        ThreadCache.put((Object)(dimId + parentNum + "nums"), nums);
        ThreadCache.put((Object)(dimId + parentNum + "dates"), dates);
        return true;
    }
}

