/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.icentity;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;
import org.apache.commons.compress.utils.Sets;

public class IcTransactionDuplicateValidator
extends AbstractDimensionImportValidator {
    private static final Set<String> IC_TOTAL = Sets.newHashSet((Object[])new String[]{"ICEntity", "ICOEntity", "ICTotal"});

    @Override
    public Optional<String> validate(ImportBillData bill) {
        JSONObject billData = bill.getData();
        if (!IC_TOTAL.contains(billData.get("number")) && StorageTypeEnum.DYNAMIC.index.equals(billData.get("storagetype"))) {
            return Optional.of(ImportMsgUtils.leafNodeShouldNotDynamic());
        }
        Optional<DynamicObject> existingMember = RowDataExtUtil.getExistingRecord(bill);
        if (!existingMember.isPresent()) {
            if (!ConfigServiceHelper.getBoolParam((Long)ImportContextHolder.getModelId(), (String)"isEntAllowImpHier") && !"ICOEntity".equals(((JSONObject)billData.get("parent")).get((Object)"number"))) {
                return Optional.of(ImportMsgUtils.iCOCheck());
            }
        } else {
            String newParentNumber = (String)((JSONObject)billData.get("parent")).get((Object)"number");
            if (existingMember.isPresent() && !newParentNumber.equals(existingMember.get().get("parent.number"))) {
                return Optional.of(ImportMsgUtils.iCOParentCheck());
            }
        }
        return Optional.empty();
    }
}

