/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.org;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.SilentJSONUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class CslSchemeValidator
extends AbstractDimensionImportValidator {
    private Map<String, Optional<DynamicObject>> cachedCslSchemes = new HashMap<String, Optional<DynamicObject>>(16);
    private Set<String> noPermCslSchme = new HashSet<String>(16);

    @Override
    public int getWeight() {
        return 1005;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> validate(ImportBillData bill) {
        if (ImportContextHolder.getImportContext().isCM()) {
            JSONObject billData = bill.getData();
            String cslNumber = SilentJSONUtils.cast(billData.get("cslscheme").toString(), LinkedHashMap.class).get("number").toString();
            if (StringUtils.isEmpty((CharSequence)cslNumber)) {
                return Optional.of(ImportMsgUtils.isNullCslScheme());
            }
            if (Objects.isNull(this.cachedCslSchemes.get(cslNumber))) {
                CslSchemeValidator cslSchemeValidator = this;
                synchronized (cslSchemeValidator) {
                    if (Objects.isNull(this.cachedCslSchemes.get(cslNumber))) {
                        QFilter filter = new QFilter("model.id", "=", (Object)this.getModelId());
                        QFilter filter3 = new QFilter("nodetype", "=", (Object)"1");
                        DynamicObjectCollection cslschemes = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,number,nodetype,longnumber", (QFilter[])new QFilter[]{filter, filter3});
                        for (DynamicObject cslscheme : cslschemes) {
                            this.cachedCslSchemes.put(cslscheme.getString("number"), Optional.ofNullable(cslscheme));
                        }
                        Set noPermCslSchemeIds = CslSchemeServiceHelper.getNoPermCslSchemeIds((Long)this.getModelId());
                        for (Long noPermCslSchemeId : noPermCslSchemeIds) {
                            Optional<String> schemeNum = cslschemes.stream().filter(x -> x.getLong("id") == noPermCslSchemeId.longValue()).map(x -> x.getString("number")).findFirst();
                            if (!schemeNum.isPresent()) continue;
                            this.noPermCslSchme.add(schemeNum.get());
                        }
                    }
                }
            }
            if (this.cachedCslSchemes.get(cslNumber) == null || !this.cachedCslSchemes.get(cslNumber).isPresent()) {
                return Optional.of(ImportMsgUtils.notExistCslScheme());
            }
            if (this.noPermCslSchme.contains(cslNumber) && !MemberPermHelper.isModelAdmin((Long)this.getModelId())) {
                return Optional.of(ImportMsgUtils.notPermCslScheme());
            }
            RowDataExtUtil.addCslScheme(bill, this.cachedCslSchemes.get(cslNumber).get());
            Object belongscheme = billData.get("belongscheme");
            if (belongscheme != null) {
                String belongSchemeNum = SilentJSONUtils.cast(billData.get("belongscheme").toString(), LinkedHashMap.class).get("number").toString();
                if (StringUtils.isNotEmpty((CharSequence)belongSchemeNum)) {
                    if (this.cachedCslSchemes.get(belongSchemeNum) == null || !this.cachedCslSchemes.get(belongSchemeNum).isPresent()) {
                        return Optional.of(ImportMsgUtils.notExistBelongCslScheme());
                    }
                    if (this.noPermCslSchme.contains(belongSchemeNum) && !MemberPermHelper.isModelAdmin((Long)this.getModelId())) {
                        return Optional.of(ImportMsgUtils.notPermBelongCslScheme());
                    }
                }
                RowDataExtUtil.addBelongCslScheme(bill, this.cachedCslSchemes.get(belongSchemeNum).get());
            }
        }
        return Optional.empty();
    }
}

