/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.org;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.event.CtrlOrgImportSuccessSubscriber;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;
import org.apache.commons.collections4.CollectionUtils;

public class CtrlOrgValidators
extends AbstractDimensionImportValidator {
    @Override
    public int getWeight() {
        return 0;
    }

    @Override
    public Optional<String> validate(ImportBillData bill) {
        DynamicObject _parent = RowDataExtUtil.getParent(bill).get();
        Long parentId = _parent.getLong("id");
        String parentNumber = ImportHelper.getNumber(_parent);
        if (this.checkMemberIsAssignedCtrlByOther(parentId, parentNumber)) {
            return Optional.of(ImportMsgUtils.noPermitAddChildOnCtrlOrg());
        }
        Optional<String> failMsg = Optional.empty();
        if (!ImportHelper.isShareType((Map<String, Object>)bill.getData())) {
            boolean isIndependentLegal;
            String orgNumber = ImportHelper.getImportBillProp(bill, "number").toString();
            String ctrlOrg = ImportHelper.getImportBillProp(bill, "ctrlorg.number").toString();
            Object isIndependentLegalObj = ImportHelper.getImportBillProp(bill, "isindependentorg");
            boolean bl = isIndependentLegal = StringUtils.isEmpty((CharSequence)isIndependentLegalObj.toString()) ? false : (Boolean)isIndependentLegalObj;
            if (isIndependentLegal) {
                if (StringUtils.isNotEmpty((CharSequence)ctrlOrg)) {
                    failMsg = Optional.of(ImportMsgUtils.notPermitCtrlOrgOnDependentOrg());
                }
            } else {
                if (this.checkMemberIsAssignedCtrlByOther(RowDataExtUtil.getId(bill), orgNumber)) {
                    return Optional.of(ImportMsgUtils.notAllowDisableCtrlOrg());
                }
                if (this.checkOrgHasChildren(bill)) {
                    if (StringUtils.isNotEmpty((CharSequence)ctrlOrg)) {
                        boolean ctrlOrgIsIndependentLegal;
                        boolean existCtrlOrg;
                        Optional<DynamicObject> ctrlOrgDy;
                        Optional<ImportBillData> ctrlBillData = ImportContextHolder.getAllWaitingImportData().stream().filter(x -> ctrlOrg.equals(ImportHelper.getImportBillProp(x, "number").toString())).findFirst();
                        if (!ctrlBillData.isPresent()) {
                            ctrlOrgDy = PersistProxy.instance.getNonShareMember(ctrlOrg, false);
                            if (ctrlOrgDy.isPresent()) {
                                existCtrlOrg = true;
                                ctrlOrgIsIndependentLegal = ctrlOrgDy.get().getBoolean("isindependentorg");
                            } else {
                                existCtrlOrg = false;
                                ctrlOrgIsIndependentLegal = false;
                            }
                        } else {
                            existCtrlOrg = true;
                            ctrlOrgIsIndependentLegal = ImportHelper.getImportBillBooleanProp(ctrlBillData.get(), "isindependentorg");
                        }
                        if (!existCtrlOrg) {
                            failMsg = Optional.of(ImportMsgUtils.notExistForCtrlOrg());
                        } else if (!ctrlOrgIsIndependentLegal) {
                            failMsg = Optional.of(ImportMsgUtils.notIndependLegalForCtrlOrg());
                        } else {
                            ctrlOrgDy = PersistProxy.instance.getNonShareMember(ctrlOrg, false);
                            if (ctrlOrgDy.isPresent()) {
                                RowDataExtUtil.addCtrlOrgId(bill, ctrlOrgDy.get());
                            } else {
                                CtrlOrgImportSuccessSubscriber.addDependCtrlOrgListener(RowDataExtUtil.getId(bill), ctrlOrg, bill);
                            }
                        }
                    }
                } else if (!StringUtils.isEmpty((CharSequence)ctrlOrg)) {
                    failMsg = Optional.of(ImportMsgUtils.notPermitOnNonDependenLegalButIsLeaf());
                }
            }
        }
        return failMsg;
    }

    private boolean checkOrgHasChildren(ImportBillData bill) {
        long curMemberId = RowDataExtUtil.getId(bill);
        Collection<DynamicObject> child = PersistProxy.instance.listChildMembers(curMemberId);
        if (CollectionUtils.isNotEmpty(child)) {
            return true;
        }
        return ImportContextHolder.checkNumberIsDepended(ImportHelper.getImportBillProp(bill, "number").toString());
    }

    private boolean checkMemberIsAssignedCtrlByOther(long memberId, String memberNumber) {
        return PersistProxy.instance.listAllMembers(false).stream().filter(x -> Objects.equals(memberId, ImportHelper.getBaseDataIdCompatible(x, "ctrlorg"))).findFirst().isPresent() || ImportContextHolder.getAllWaitingImportData().stream().filter(x -> {
            Object ctrlOrgValue = x.getData().get((Object)"ctrlorg");
            if (ctrlOrgValue instanceof Map) {
                return memberNumber.equals(ImportHelper.getImportBillProp(x, "ctrlorg.number").toString());
            }
            return Objects.nonNull(ctrlOrgValue) && String.valueOf(memberId).equals(ctrlOrgValue.toString());
        }).findFirst().isPresent();
    }
}

