/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.org;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class EffDateValidator
extends AbstractDimensionImportValidator {
    private volatile DynamicObjectCollection modelDates = null;

    @Override
    public Optional<String> validate(ImportBillData bill) {
        Object effdate = bill.getData().get((Object)"effdate");
        if (effdate != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = null;
            try {
                now = format.parse(effdate.toString());
            }
            catch (ParseException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[0]);
            }
            return Optional.ofNullable(this.checkModelDate(now));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkModelDate(Date date) {
        if (Objects.isNull(this.modelDates)) {
            EffDateValidator effDateValidator = this;
            synchronized (effDateValidator) {
                if (Objects.isNull(this.modelDates)) {
                    this.modelDates = EntityVersioningUtil.queryFYFirstDay((Object)this.getModelId());
                }
            }
        }
        if (this.modelDates.size() == 1) {
            DynamicObject modeDateDy = (DynamicObject)this.modelDates.get(0);
            String startfy = modeDateDy.getString("startfy");
            String beginyearofmonth = modeDateDy.getString("beginyearofmonth");
            String beginperiod = modeDateDy.getString("beginperiod");
            int fyyear = Integer.parseInt(startfy) + 1996;
            int fymonth = Integer.parseInt(beginperiod);
            if (FyEnum.PRE.index.equals(beginyearofmonth)) {
                --fyyear;
            }
            LocalDate ld = LocalDate.of(fyyear, fymonth, 1);
            ZoneId zd = ZoneId.systemDefault();
            ZonedDateTime zdt = ld.atStartOfDay(zd);
            Date modelEffDate = Date.from(zdt.toInstant());
            if (date == null || date.compareTo(modelEffDate) < 0) {
                String strfymonth = "";
                strfymonth = fymonth < 10 ? "0" + fymonth : String.valueOf(fymonth);
                return String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u4e0d\u53ef\u65e9\u4e8e%1$s-%2$s-01\u3002", (String)"EffDateValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fyyear, strfymonth);
            }
        }
        return null;
    }
}

