/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.org;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class InjectOrgCurrencyNumberValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData bill) {
        this.injectCtrlOrgNumber(bill);
        Optional<String> checkCurrencyMsg = this.checkOrInjectCurrencyNumber(bill);
        if (checkCurrencyMsg.isPresent()) {
            return checkCurrencyMsg;
        }
        return Optional.empty();
    }

    private void injectCtrlOrgNumber(ImportBillData bill) {
        JSONObject data = bill.getData();
        if (data.get("ctrlorg") == null) {
            data.put("ctrlorg", null);
        }
    }

    private Optional<String> checkOrInjectCurrencyNumber(ImportBillData bill) {
        String number = "";
        JSONObject data = bill.getData();
        number = data.get("currency") == null ? "CNY" : ImportHelper.getImportBillProp(bill, "currency.number").toString();
        Optional<DynamicObject> currency = BatchImportReadOnlyCache.getBdCurrencyByNumber(number);
        if (currency.isPresent()) {
            if (!ImportContextHolder.isDryRun()) {
                BatchImportReadOnlyCache.checkCurrencyAndCreateCurrencyMember(this.getModelId(), number, currency.get().getString("name"));
            }
        } else {
            return Optional.of(ResManager.loadKDString((String)"\u5e01\u79cd\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"InjectOrgCurrencyNumberValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        RowDataExtUtil.addCurrency(bill, currency.get());
        return Optional.empty();
    }
}

