/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.org;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.model.ChangeTypeModel;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportText2DateUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;
import kd.fi.bcm.spread.common.util.StringUtil;

public class OrgChangeRecordInputFormatValidator
extends AbstractDimensionImportValidator {
    @Override
    public int getWeight() {
        return 500;
    }

    @Override
    public Optional<String> validate(ImportBillData bill) {
        String namechangerds;
        JSONObject data = bill.getData();
        String bizChangeRdsFromExcel = (String)data.get("bizchangerds");
        String nameChangeRdsFromExcel = (String)data.get("namechangerds");
        String currChangeRdsFromExcel = (String)data.get("currencychangerds");
        Optional<String> ans = this.bizChangeCheck((Map<String, Object>)data, bizChangeRdsFromExcel);
        if (ans.isPresent()) {
            return ans;
        }
        Optional<String> ans1 = this.nameChangeCheck((Map<String, Object>)data, nameChangeRdsFromExcel);
        if (ans1.isPresent()) {
            return ans1;
        }
        Optional<String> ans2 = this.currChangeCheck((Map<String, Object>)data, currChangeRdsFromExcel);
        if (ans2.isPresent()) {
            return ans2;
        }
        Optional<DynamicObject> existingRecord = RowDataExtUtil.getExistingRecord(bill);
        if (existingRecord.isPresent() && StringUtil.isEmptyString((String)(namechangerds = (String)data.get("namechangerds")))) {
            return Optional.of(ImportMsgUtils.namechangerdShouldNotNull());
        }
        return Optional.empty();
    }

    private Optional<String> bizChangeCheck(Map<String, Object> data, String bizChangeRdsFromExcel) {
        Optional<String> ans = Optional.empty();
        if (StringUtils.isNotEmpty((String)bizChangeRdsFromExcel)) {
            String noTailBizChangeRdsFromExcel = bizChangeRdsFromExcel.substring(0, bizChangeRdsFromExcel.length() - 1);
            String[] rds = noTailBizChangeRdsFromExcel.split(";\n");
            String patDate = "(\\s)*\\d{4}(\\s)*-(\\s)*\\d{2}(\\s)*-(\\s)*\\d{2}(\\s)*";
            Date initUnitDate = null;
            ArrayList<String> changeTypes = new ArrayList<String>(10);
            int rowIndex = 0;
            Date prevLastDate = null;
            String errorType = ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55", (String)"OrgChangeRecordInputFormatValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            for (String aRd : rds) {
                String[] cols = aRd.split("\\|");
                Optional<String> checkFail = this.noTailRowCheck(rowIndex, cols, rds, errorType, new int[]{3, 2});
                if (checkFail.isPresent()) {
                    return checkFail;
                }
                ++rowIndex;
                int unitIndex = 0;
                for (String aUnit : cols) {
                    if (unitIndex != 0) {
                        boolean isMatch = Pattern.matches(patDate, aUnit);
                        if (!isMatch) {
                            return Optional.of(ImportMsgUtils.orgChangeRecordDateInputFormatError());
                        }
                        if (initUnitDate == null) {
                            initUnitDate = ImportText2DateUtils.dateStr2Date(aUnit);
                            ans = this.dateBigThanModelOpen(initUnitDate, errorType);
                        } else {
                            Date curDate = ImportText2DateUtils.dateStr2Date(aUnit);
                            if (prevLastDate != null && unitIndex == 1 && curDate.getTime() <= prevLastDate.getTime()) {
                                return Optional.of(ImportMsgUtils.orgChangeRecordDateInputError());
                            }
                            if (curDate.getTime() < initUnitDate.getTime()) {
                                return Optional.of(ImportMsgUtils.orgChangeRecordDateInputError());
                            }
                            initUnitDate = curDate;
                            if (unitIndex == 2) {
                                prevLastDate = curDate;
                            }
                        }
                        ++unitIndex;
                        continue;
                    }
                    long modelId = ImportContextHolder.getImportContext().getImportModel().getLong("id");
                    ChangeTypeModel changeTypeModel = (ChangeTypeModel)InvestServiceHelper.getInvChangetypeModel((Long)modelId).get(aUnit);
                    if (changeTypeModel == null) {
                        return Optional.of(ImportMsgUtils.bizChangeTypeNotExist(aUnit));
                    }
                    changeTypes.add(aUnit);
                    ++unitIndex;
                }
            }
            Optional<DynamicObject> orgId = PersistProxy.instance.getNonShareMember((String)data.get("number"), false);
            String isCheckTypeOk = OrgChangeRecordInputFormatValidator.checkChangeType(changeTypes, orgId.isPresent() ? Long.valueOf(orgId.get().getLong("id")) : null);
            if (StringUtils.isNotEmpty((String)isCheckTypeOk)) {
                return Optional.of(isCheckTypeOk);
            }
        }
        return ans;
    }

    private Optional<String> nameChangeCheck(Map<String, Object> data, String nameChangeRdsFromExcel) {
        Optional<String> ans = Optional.empty();
        if (StringUtils.isNotEmpty((String)nameChangeRdsFromExcel)) {
            String nameOfPage = ((LocaleString)data.get("name")).getLocaleValue();
            String noTailNameChangeRdsFromExcel = nameChangeRdsFromExcel.substring(0, nameChangeRdsFromExcel.length() - 1);
            String[] rds = noTailNameChangeRdsFromExcel.split(";\n");
            String patDate = "(\\s)*\\d{4}(\\s)*-(\\s)*\\d{2}(\\s)*-(\\s)*\\d{2}(\\s)*";
            Date initUnitDate = null;
            String lastRdName = null;
            int rowIndex = 0;
            Date prevLastDate = null;
            String errorType = ResManager.loadKDString((String)"\u540d\u79f0\u53d8\u66f4\u8bb0\u5f55", (String)"OrgChangeRecordInputFormatValidator_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            for (String aRd : rds) {
                String[] cols = aRd.split("\\|");
                Optional<String> checkFail = this.noTailRowCheck(rowIndex, cols, rds, errorType, new int[]{4, 3});
                if (checkFail.isPresent()) {
                    return checkFail;
                }
                int unitIndex = 0;
                for (String aUnit : cols) {
                    if (unitIndex > 1) {
                        boolean isMatch = Pattern.matches(patDate, aUnit);
                        if (!isMatch) {
                            return Optional.of(ImportMsgUtils.orgChangeRecordNameDateFormatInputError());
                        }
                        if (initUnitDate == null) {
                            initUnitDate = ImportText2DateUtils.dateStr2Date(aUnit);
                            ans = this.dateBigThanModelOpen(initUnitDate, errorType);
                        } else {
                            Date curDate = ImportText2DateUtils.dateStr2Date(aUnit);
                            if (prevLastDate != null && unitIndex == 2 && curDate.getTime() <= prevLastDate.getTime()) {
                                return Optional.of(ImportMsgUtils.orgChangeRecordNameDateInputError());
                            }
                            if (curDate.getTime() < initUnitDate.getTime()) {
                                return Optional.of(ImportMsgUtils.orgChangeRecordNameDateInputError());
                            }
                            initUnitDate = curDate;
                            if (unitIndex == 3) {
                                prevLastDate = curDate;
                            }
                        }
                    } else if (unitIndex == 0) {
                        String currRdName = aUnit;
                        if (currRdName.equals(lastRdName)) {
                            return Optional.of(ImportMsgUtils.orgChangeRecordNameInputError());
                        }
                        lastRdName = currRdName;
                    }
                    ++unitIndex;
                }
                if (rowIndex == rds.length - 1 && !nameOfPage.equals(lastRdName)) {
                    return Optional.of(ImportMsgUtils.orgChangeRecordNameConsistInputError());
                }
                ++rowIndex;
            }
        }
        return ans;
    }

    private Optional<String> currChangeCheck(Map<String, Object> data, String currChangeRdsFromExcel) {
        Optional<String> ans = Optional.empty();
        String currOfPage = ((DynamicObject)data.get("currency")).getString("number");
        if (StringUtils.isNotEmpty((String)currChangeRdsFromExcel)) {
            String noTailCurrChangeRdsFromExcel = currChangeRdsFromExcel.substring(0, currChangeRdsFromExcel.length() - 1);
            String[] rds = noTailCurrChangeRdsFromExcel.split(";\n");
            if (rds.length > 1) {
                return Optional.of(ResManager.loadKDString((String)"\u5e01\u79cd\u53d8\u66f4\u8bb0\u5f55\u53ea\u80fd\u5f55\u5165\u4e00\u6761\u3002", (String)"OrgChangeRecordInputFormatValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String errorType = ResManager.loadKDString((String)"\u5e01\u79cd\u53d8\u66f4\u8bb0\u5f55", (String)"OrgChangeRecordInputFormatValidator_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String patDate = "(\\s)*\\d{4}(\\s)*-(\\s)*\\d{2}(\\s)*-(\\s)*\\d{2}(\\s)*";
            Date initUnitDate = null;
            String nowCurr = null;
            int rowIndex = 0;
            for (String aRd : rds) {
                String[] cols = aRd.split("\\|");
                Optional<String> checkFail = this.noTailRowCheck(rowIndex, cols, rds, errorType, new int[]{3, 2});
                if (checkFail.isPresent()) {
                    return checkFail;
                }
                int unitIndex = 0;
                for (String aUnit : cols) {
                    if (unitIndex != 0) {
                        boolean isMatch = Pattern.matches(patDate, aUnit);
                        if (!isMatch) {
                            return Optional.of(ImportMsgUtils.orgChangeRecordCurrDateFormatInputError());
                        }
                        if (initUnitDate == null) {
                            initUnitDate = ImportText2DateUtils.dateStr2Date(aUnit);
                            ans = this.dateBigThanModelOpen(initUnitDate, errorType);
                        } else {
                            Date curDate = ImportText2DateUtils.dateStr2Date(aUnit);
                            if (curDate.getTime() < initUnitDate.getTime()) {
                                return Optional.of(ImportMsgUtils.currChangeRecordInputDateError());
                            }
                            initUnitDate = curDate;
                        }
                        ++unitIndex;
                        continue;
                    }
                    if (StringUtils.isEmpty((String)aUnit)) {
                        return Optional.of(ImportMsgUtils.orgCurrencyChangeRDEmpty());
                    }
                    if (aUnit.equals(nowCurr)) {
                        return Optional.of(ImportMsgUtils.orgChangeRecordCurrDiffInputError());
                    }
                    nowCurr = aUnit;
                    if (rowIndex == rds.length - 1 && !currOfPage.equals(nowCurr)) {
                        return Optional.of(ImportMsgUtils.notConsistOfCurrency());
                    }
                    ++unitIndex;
                }
                ++rowIndex;
            }
        }
        return ans;
    }

    public static String checkChangeType(List<String> changeTypes, Object orgId) {
        long modelId = ImportContextHolder.getImportContext().getImportModel().getLong("id");
        for (int i = changeTypes.size() - 1; i >= 0; --i) {
            String changetype = changeTypes.get(i);
            if (i > 0) {
                String beforeChangeType = changeTypes.get(i - 1);
                if ((beforeChangeType.equals(OrgBizChangeTypeEnum.initNewlyAdded.getValue()) || beforeChangeType.equals(OrgBizChangeTypeEnum.mergerNewlyAdded.getValue()) || beforeChangeType.equals(OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue()) || beforeChangeType.equals(OrgBizChangeTypeEnum.liquidationNewlyAdded.getValue()) || beforeChangeType.equals(OrgBizChangeTypeEnum.newAdd.getValue()) || beforeChangeType.equals(OrgBizChangeTypeEnum.newSetMergeEnable.getValue())) && (changetype.equals(OrgBizChangeTypeEnum.initNewlyAdded.getValue()) || changetype.equals(OrgBizChangeTypeEnum.mergerNewlyAdded.getValue()) || changetype.equals(OrgBizChangeTypeEnum.sameControlNewlyAdded.getValue()) || changetype.equals(OrgBizChangeTypeEnum.liquidationNewlyAdded.getValue()) || changetype.equals(OrgBizChangeTypeEnum.newAdd.getValue()) || changetype.equals(OrgBizChangeTypeEnum.newSetMergeEnable.getValue())) || EntityVersioningUtil.checkDefinedChangetype((String)beforeChangeType, (String)changetype, (long)modelId, (String)"add")) {
                    return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u7b2c%s\u6761\u7684\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u548c\u4e0a\u4e00\u6761\u8bb0\u5f55\u540c\u4e3a\u65b0\u589e\u7c7b\u578b\u3002", (String)"OrgChangeRecordInputFormatValidator_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1);
                }
                if ((beforeChangeType.equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || beforeChangeType.equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue()) || beforeChangeType.equals(OrgBizChangeTypeEnum.newSetMergeDisable.getValue())) && (changetype.equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || changetype.equals(OrgBizChangeTypeEnum.sameControlDisposal.getValue()) || changetype.equals(OrgBizChangeTypeEnum.newSetMergeDisable.getValue())) || EntityVersioningUtil.checkDefinedChangetype((String)beforeChangeType, (String)changetype, (long)modelId, (String)"disposal")) {
                    return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u7b2c%s\u6761\u7684\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u548c\u4e0a\u4e00\u6761\u8bb0\u5f55\u540c\u4e3a\u5904\u7f6e\u7c7b\u578b\u3002", (String)"OrgChangeRecordInputFormatValidator_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1);
                }
                if (!beforeChangeType.equals(OrgBizChangeTypeEnum.liquidationDisposal.getValue()) || changetype.equals(OrgBizChangeTypeEnum.liquidationNewlyAdded.getValue())) continue;
                return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u7b2c%s\u6761\u7684\u53d8\u66f4\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u201c\u6e05\u7b97\u540e\u91cd\u65b0\u56de\u8d2d\u65b0\u589e\u201d\u3002", (String)"OrgChangeRecordInputFormatValidator_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1);
            }
            if (EntityVersioningUtil.isNewTypes((String)changetype, (long)modelId)) continue;
            return ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u9996\u6761\u8bb0\u5f55\u7684\u53d8\u66f4\u7c7b\u578b\u53ef\u9009\u9879\u4ec5\u4e3a\u201c\u7cfb\u7edf\u4e0a\u7ebf\u521d\u59cb\u5316\u65b0\u589e\u201d\u3001\u201c\u65b0\u8bbe\u5408\u5e76\u53d8\u66f4\u542f\u7528\u201d\uff0c\u4ee5\u53ca\u5408\u5e76\u8303\u56f4\u53d8\u52a8\u4e3a\u201c\u65b0\u589e\u201d\u7684\u4e1a\u52a1\u53d8\u66f4\u7c7b\u578b\u3002", (String)"OrgChangeRecordInputFormatValidator_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private Optional<String> noTailRowCheck(int rowIndex, String[] cols, String[] rds, String errorType, int[] num) {
        if (rowIndex != rds.length - 1 && cols.length != num[0]) {
            return Optional.of(errorType + ImportMsgUtils.orgChangeRdFormatError());
        }
        if (rowIndex == rds.length - 1 && cols.length != num[1]) {
            return Optional.of(errorType + ImportMsgUtils.orgChangeRdFormatError());
        }
        return Optional.empty();
    }

    private Optional<String> dateBigThanModelOpen(Date initUnitDate, String whichRd) {
        Long modelId = ImportContextHolder.getImportContext().getImportModel().getLong("id");
        if (modelId != null) {
            Date modelOpenDate = EntityVersioningUtil.getModelBeginDate((Object)modelId);
            if (initUnitDate.getTime() + 2000L < modelOpenDate.getTime()) {
                return Optional.of(whichRd + ImportMsgUtils.dateBigThanModelOpenDate() + ": " + modelOpenDate.toString());
            }
        }
        return Optional.empty();
    }
}

