/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.org;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.DimensionImportContext;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.RowDataExtUtil;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.SilentJSONUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.persist.PersistProxy;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;

public class OrgCheckParentNumberValidator
extends AbstractDimensionImportValidator {
    @Override
    public int getWeight() {
        return 1004;
    }

    @Override
    public Optional<String> validate(ImportBillData bill) {
        IDNumberTreeNode node;
        JSONObject billData = bill.getData();
        DimensionImportContext context = ImportContextHolder.getImportContext();
        String longnumber = (String)billData.get("longnumber");
        if (StringUtils.isNotEmpty((CharSequence)longnumber) && IDNumberTreeNode.NotFoundTreeNode != (node = MemberReader.findMemberByLongNumber((String)context.getImportModel().getString("number"), (String)"Entity", (String)longnumber)) && node.getParent().isShare()) {
            return Optional.of(ResManager.loadKDString((String)"\u7236\u7ea7\u4e3a\u5171\u4eab\u7684\u6210\u5458\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ImportMsgUtils_124", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String parentNum = SilentJSONUtils.cast(billData.get("parent").toString(), LinkedHashMap.class).get("number").toString();
        Optional<DynamicObject> parent = PersistProxy.instance.getNonShareMember(parentNum, false);
        if (parent.isPresent()) {
            if (context.isCM()) {
                long cslId = RowDataExtUtil.getCslScheme(bill).get().getLong("id");
                QFilter qf = new QFilter("id", "=", (Object)cslId);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_cslscheme", (String)"id, islegalorgview, isenable", (QFilter[])qf.toArray());
                boolean isAllowed = ConfigServiceHelper.getBoolParam((Long)context.getImportModel().getLong("id"), (String)"isAllowImpNonStatutoryView");
                if (dynamicObject != null && !dynamicObject.getBoolean("islegalorgview")) {
                    if (!isAllowed) {
                        return Optional.of(ImportMsgUtils.notAllowedExportOrg());
                    }
                    if (dynamicObject.getBoolean("isenable")) {
                        return Optional.of(ImportMsgUtils.notAllowedExportEnableOrg());
                    }
                }
                if (parentNum.equals("Entity")) {
                    List<DynamicObject> firstLevelNodes = PersistProxy.instance.listMemberByFilter(x -> {
                        boolean isSameCslScheme = Objects.equals(x.getLong("cslscheme_id"), RowDataExtUtil.getCslScheme(bill).get().getLong("id"));
                        long parentId = ImportHelper.getBaseDataIdCompatible(x, "parent");
                        boolean isParentEntity = parentId > 0L && "Entity".equals(PersistProxy.instance.getById(parentId, false).getString("number"));
                        return isSameCslScheme && isParentEntity;
                    });
                    if (ImportOperateType.NEW == ImportContextHolder.getImportType() && firstLevelNodes.size() > 0 || ImportOperateType.NEW != ImportContextHolder.getImportType() && firstLevelNodes.stream().filter(arg_0 -> OrgCheckParentNumberValidator.lambda$validate$1((Map)billData, arg_0)).count() > 0L) {
                        return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u7ec4\u7ec7\u6811\u53ea\u80fd\u6709\u4e00\u4e2a\u6839\u8282\u70b9\u3002", (String)"OrgCheckParentNumberValidator_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                } else if (ImportHelper.getBaseDataIdCompatible(parent.get(), "cslscheme") != cslId) {
                    return Optional.of(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7f16\u7801\u5bf9\u5e94\u7684\u5b58\u50a8\u6210\u5458\u4e0d\u5728\u5f53\u524d\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u3002", (String)"OrgCheckParentNumberValidator_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            return Optional.of(ImportMsgUtils.notExistParentNumber());
        }
        RowDataExtUtil.addParent(bill, parent.get());
        return Optional.empty();
    }

    private static /* synthetic */ boolean lambda$validate$1(Map billData, DynamicObject x) {
        return !ImportHelper.getNumber(x).equals(billData.get("number"));
    }
}

