/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.scene;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;
import org.apache.commons.collections.CollectionUtils;

public class ScaleTxtValidator
extends AbstractDimensionImportValidator {
    private static final Pattern PATTERN = Pattern.compile("^\\s*[A-Za-z]*:(-[1-4]|[0-9]|1[0-5])\\s*$");

    @Override
    public Optional<String> validate(ImportBillData bill) {
        String scaletext = bill.getData().getString("scaletext");
        if (StringUtils.isNotEmpty((String)scaletext)) {
            String[] currencyScale = scaletext.split(",");
            ArrayList<String> currencies = new ArrayList<String>(currencyScale.length);
            ArrayList sysCurrencies = new ArrayList();
            for (String currencyScaleStr : currencyScale) {
                if (!PATTERN.matcher(currencyScaleStr).find()) {
                    return Optional.of(ImportMsgUtils.scaleTxtNotValid());
                }
                String[] curAndScale = currencyScaleStr.split(":");
                currencies.add(curAndScale[0]);
            }
            DynamicObjectCollection curs = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("number", "not in", (Object)new String[]{CurrencyEnum.CURRENCY.number, CurrencyEnum.DC.number, CurrencyEnum.EC.number, CurrencyEnum.PC.number}).toArray());
            curs.forEach(dyn -> sysCurrencies.add(dyn.getString("number")));
            List notSupportedCurs = currencies.stream().filter(cur -> !sysCurrencies.contains(cur)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(notSupportedCurs)) {
                return Optional.of(ImportMsgUtils.scaleTxtCurNotSupported(String.join((CharSequence)",", notSupportedCurs)));
            }
        }
        return Optional.empty();
    }
}

