/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dimension.batchimp.validators.scene;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.BatchImportReadOnlyCache;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportContextHolder;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportMsgUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.validators.AbstractDimensionImportValidator;
import org.apache.commons.collections.CollectionUtils;

public class SceneCslschemeValidator
extends AbstractDimensionImportValidator {
    @Override
    public Optional<String> validate(ImportBillData bill) {
        if (ApplicationTypeEnum.CM.getAppnum().equals(ImportContextHolder.getImportContext().getAppId())) {
            JSONObject scenePeriodJson = bill.getData().getJSONObject("scenecslscheme");
            String[] scNums = scenePeriodJson.getString("number").split(",");
            List<DynamicObject> allCslSchemes = BatchImportReadOnlyCache.getAllCslSchemes(this.getModelId());
            if (CollectionUtils.isEmpty(allCslSchemes)) {
                return Optional.of(ImportMsgUtils.noCslSchemeOfModel());
            }
            Set numbers = allCslSchemes.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
            if (!numbers.containsAll(Arrays.asList(scNums))) {
                return Optional.of(ImportMsgUtils.notExistCslOfScene());
            }
        }
        return Optional.empty();
    }
}

